/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RefWalker;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Quality Control and Simple Analysis Tools", extraDocs={CommandLineGATK.class})
public class QCRef
extends RefWalker<Integer, Integer> {
    @Output
    public PrintStream out;
    String contigName = "";
    int contigStart;
    int contigEnd;
    IndexedFastaSequenceFile uncachedRef;
    byte[] uncachedBases;

    @Override
    public void initialize() {
        super.initialize();
        this.uncachedRef = this.getToolkit().getReferenceDataSource().getReference();
    }

    private final void throwError(ReferenceContext ref, String message) {
        throw new StingException(String.format("Site %s failed: %s", ref.getLocus(), message));
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        byte uncachedBase;
        int pos;
        byte refBase;
        String locusContigName = ref.getLocus().getContig();
        if (!locusContigName.equals(this.contigName)) {
            this.contigName = locusContigName;
            ReferenceSequence refSeq = this.uncachedRef.getSequence(this.contigName);
            this.contigStart = 1;
            this.contigEnd = this.contigStart + refSeq.length() - 1;
            this.uncachedBases = this.uncachedRef.getSubsequenceAt(this.contigName, this.contigStart, this.contigEnd).getBases();
            logger.info(String.format("Loading contig %s (%d-%d)", this.contigName, this.contigStart, this.contigEnd));
        }
        if (!BaseUtils.isRegularBase(refBase = ref.getBase()) && !QCRef.isExtendFastaBase(refBase)) {
            this.throwError(ref, String.format("Refbase isn't a regular base (%d %c)", refBase, Character.valueOf((char)refBase)));
        }
        if ((pos = (int)context.getPosition() - this.contigStart) > this.contigEnd) {
            this.throwError(ref, String.format("off contig (len=%d)", this.contigEnd));
        }
        if ((uncachedBase = this.uncachedBases[pos]) != refBase) {
            this.throwError(ref, String.format("Provided refBase (%d %c) not equal to uncached one (%d %c)", refBase, Character.valueOf((char)refBase), uncachedBase, Character.valueOf((char)uncachedBase)));
        }
        return 1;
    }

    private static final boolean isExtendFastaBase(byte b) {
        switch (b) {
            case 45: 
            case 66: 
            case 68: 
            case 72: 
            case 75: 
            case 77: 
            case 78: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer one, Integer sum) {
        return one + sum;
    }
}

