/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.List;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidGenotype;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.fragments.FragmentCollection;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class DiploidSNPGenotypeLikelihoods
implements Cloneable {
    public static final double DEFAULT_PCR_ERROR_RATE = 1.0E-4;
    protected static final int FIXED_PLOIDY = 2;
    protected static final int MAX_PLOIDY = 3;
    protected static final double ploidyAdjustment = Math.log10(2.0);
    protected static final double log10_3 = Math.log10(3.0);
    protected boolean VERBOSE = false;
    protected double[] log10Likelihoods = null;
    protected double log10_PCR_error_3;
    protected double log10_1_minus_PCR_error;
    static DiploidSNPGenotypeLikelihoods[][][][][] CACHE = new DiploidSNPGenotypeLikelihoods[BaseUtils.BASES.length][94][BaseUtils.BASES.length + 1][94][3];
    private static final double[] genotypeZeros = new double[DiploidGenotype.values().length];
    private static final double[] baseZeros = new double[BaseUtils.BASES.length];

    public DiploidSNPGenotypeLikelihoods(double PCR_error_rate) {
        this.log10_PCR_error_3 = Math.log10(PCR_error_rate) - log10_3;
        this.log10_1_minus_PCR_error = Math.log10(1.0 - PCR_error_rate);
        this.setToZero();
    }

    protected Object clone() throws CloneNotSupportedException {
        DiploidSNPGenotypeLikelihoods c = (DiploidSNPGenotypeLikelihoods)super.clone();
        c.log10Likelihoods = (double[])this.log10Likelihoods.clone();
        return c;
    }

    protected void setToZero() {
        this.log10Likelihoods = (double[])genotypeZeros.clone();
    }

    public double[] getLikelihoods() {
        return this.log10Likelihoods;
    }

    public int add(ReadBackedPileup pileup, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        int n = 0;
        FragmentCollection<PileupElement> fpile = pileup.toFragments();
        for (PileupElement pileupElement : fpile.getSingletonReads()) {
            n += this.add(pileupElement, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual);
        }
        for (List list : fpile.getOverlappingPairs()) {
            n += this.add(list, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual);
        }
        return n;
    }

    public int add(PileupElement elt, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        byte obsBase = elt.getBase();
        byte qual = DiploidSNPGenotypeLikelihoods.qualToUse(elt, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual);
        if (qual == 0) {
            return 0;
        }
        if (elt.getRead().isReducedRead()) {
            if (BaseUtils.isRegularBase(obsBase)) {
                int representativeCount = elt.getRepresentativeCount();
                this.add(obsBase, qual, (byte)0, (byte)0, representativeCount);
                return representativeCount;
            }
            return 0;
        }
        return this.add(obsBase, qual, (byte)0, (byte)0, 1);
    }

    public int add(List<PileupElement> overlappingPair, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        PileupElement p1 = overlappingPair.get(0);
        PileupElement p2 = overlappingPair.get(1);
        byte observedBase1 = p1.getBase();
        byte qualityScore1 = DiploidSNPGenotypeLikelihoods.qualToUse(p1, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual);
        byte observedBase2 = p2.getBase();
        byte qualityScore2 = DiploidSNPGenotypeLikelihoods.qualToUse(p2, ignoreBadBases, capBaseQualsAtMappingQual, minBaseQual);
        if (qualityScore1 == 0) {
            if (qualityScore2 == 0) {
                return 0;
            }
            return this.add(observedBase2, qualityScore2, (byte)0, (byte)0);
        }
        return this.add(observedBase1, qualityScore1, observedBase2, qualityScore2);
    }

    private int add(byte obsBase1, byte qual1, byte obsBase2, byte qual2, int nObs) {
        DiploidSNPGenotypeLikelihoods gl = !this.inCache(obsBase1, qual1, obsBase2, qual2, 2) ? this.calculateCachedGenotypeLikelihoods(obsBase1, qual1, obsBase2, qual2, 2) : this.getCachedGenotypeLikelihoods(obsBase1, qual1, obsBase2, qual2, 2);
        if (gl == null) {
            return 0;
        }
        double[] likelihoods = gl.getLikelihoods();
        for (DiploidGenotype g : DiploidGenotype.values()) {
            double likelihood = likelihoods[g.ordinal()];
            int n = g.ordinal();
            this.log10Likelihoods[n] = this.log10Likelihoods[n] + likelihood * (double)nObs;
        }
        return 1;
    }

    private int add(byte obsBase1, byte qual1, byte obsBase2, byte qual2) {
        return this.add(obsBase1, qual1, obsBase2, qual2, 1);
    }

    protected boolean inCache(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy) {
        return this.getCache(CACHE, observedBase1, qualityScore1, observedBase2, qualityScore2, ploidy) != null;
    }

    protected DiploidSNPGenotypeLikelihoods getCachedGenotypeLikelihoods(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy) {
        DiploidSNPGenotypeLikelihoods gl = this.getCache(CACHE, observedBase1, qualityScore1, observedBase2, qualityScore2, ploidy);
        if (gl == null) {
            throw new RuntimeException(String.format("BUG: trying to fetch an unset cached genotype likelihood at base1=%c, qual1=%d, base2=%c, qual2=%d, ploidy=%d", observedBase1, qualityScore1, observedBase2, qualityScore2, ploidy));
        }
        return gl;
    }

    protected DiploidSNPGenotypeLikelihoods calculateCachedGenotypeLikelihoods(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy) {
        DiploidSNPGenotypeLikelihoods gl = this.calculateGenotypeLikelihoods(observedBase1, qualityScore1, observedBase2, qualityScore2);
        this.setCache(CACHE, observedBase1, qualityScore1, observedBase2, qualityScore2, ploidy, gl);
        return gl;
    }

    protected void setCache(DiploidSNPGenotypeLikelihoods[][][][][] cache, byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy, DiploidSNPGenotypeLikelihoods val) {
        int i = BaseUtils.simpleBaseToBaseIndex(observedBase1);
        byte j = qualityScore1;
        int k = qualityScore2 != 0 ? BaseUtils.simpleBaseToBaseIndex(observedBase2) : BaseUtils.BASES.length;
        byte l = qualityScore2;
        int m = ploidy;
        cache[i][j][k][l][m] = val;
    }

    protected DiploidSNPGenotypeLikelihoods getCache(DiploidSNPGenotypeLikelihoods[][][][][] cache, byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2, int ploidy) {
        int i = BaseUtils.simpleBaseToBaseIndex(observedBase1);
        byte j = qualityScore1;
        int k = qualityScore2 != 0 ? BaseUtils.simpleBaseToBaseIndex(observedBase2) : BaseUtils.BASES.length;
        byte l = qualityScore2;
        int m = ploidy;
        return cache[i][j][k][l][m];
    }

    protected DiploidSNPGenotypeLikelihoods calculateGenotypeLikelihoods(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2) {
        double[] log10FourBaseLikelihoods = this.computeLog10Likelihoods(observedBase1, qualityScore1, observedBase2, qualityScore2);
        try {
            DiploidSNPGenotypeLikelihoods gl = (DiploidSNPGenotypeLikelihoods)this.clone();
            gl.setToZero();
            for (DiploidGenotype g : DiploidGenotype.values()) {
                double p_base = 0.0;
                p_base += Math.pow(10.0, log10FourBaseLikelihoods[BaseUtils.simpleBaseToBaseIndex(g.base1)] - ploidyAdjustment);
                double likelihood = Math.log10(p_base += Math.pow(10.0, log10FourBaseLikelihoods[BaseUtils.simpleBaseToBaseIndex(g.base2)] - ploidyAdjustment));
                int n = g.ordinal();
                gl.log10Likelihoods[n] = gl.log10Likelihoods[n] + likelihood;
            }
            if (this.VERBOSE) {
                for (DiploidGenotype g : DiploidGenotype.values()) {
                    System.out.printf("%s\t", new Object[]{g});
                }
                System.out.println();
                for (DiploidGenotype g : DiploidGenotype.values()) {
                    System.out.printf("%.2f\t", gl.log10Likelihoods[g.ordinal()]);
                }
                System.out.println();
            }
            return gl;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected double[] computeLog10Likelihoods(byte observedBase1, byte qualityScore1, byte observedBase2, byte qualityScore2) {
        double[] log10FourBaseLikelihoods = (double[])baseZeros.clone();
        for (byte trueBase : BaseUtils.BASES) {
            double likelihood = 0.0;
            for (byte fragmentBase : BaseUtils.BASES) {
                double log10FragmentLikelihood;
                double d = log10FragmentLikelihood = trueBase == fragmentBase ? this.log10_1_minus_PCR_error : this.log10_PCR_error_3;
                if (qualityScore1 != 0) {
                    log10FragmentLikelihood += this.log10PofObservingBaseGivenChromosome(observedBase1, fragmentBase, qualityScore1);
                }
                if (qualityScore2 != 0) {
                    log10FragmentLikelihood += this.log10PofObservingBaseGivenChromosome(observedBase2, fragmentBase, qualityScore2);
                }
                likelihood += Math.pow(10.0, log10FragmentLikelihood);
            }
            log10FourBaseLikelihoods[BaseUtils.simpleBaseToBaseIndex((byte)trueBase)] = Math.log10(likelihood);
        }
        return log10FourBaseLikelihoods;
    }

    protected double log10PofObservingBaseGivenChromosome(byte observedBase, byte chromBase, byte qual) {
        double logP;
        if (observedBase == chromBase) {
            double e = Math.pow(10.0, (double)qual / -10.0);
            logP = Math.log10(1.0 - e);
        } else {
            logP = (double)qual / -10.0 + -log10_3;
        }
        return logP;
    }

    private static byte qualToUse(PileupElement p, boolean ignoreBadBases, boolean capBaseQualsAtMappingQual, int minBaseQual) {
        if (ignoreBadBases && !BaseUtils.isRegularBase(p.getBase())) {
            return 0;
        }
        byte qual = p.getQual();
        if (qual > 93) {
            throw new UserException.MalformedBAM(p.getRead(), String.format("the maximum allowed quality score is %d, but a quality of %d was observed in read %s.  Perhaps your BAM incorrectly encodes the quality scores in Sanger format; see http://en.wikipedia.org/wiki/FASTQ_format for more details", 93, qual, p.getRead().getReadName()));
        }
        if (capBaseQualsAtMappingQual) {
            qual = (byte)Math.min(qual, p.getMappingQual());
        }
        if (qual < minBaseQual) {
            qual = 0;
        }
        return qual;
    }

    public String toString() {
        double sum = 0.0;
        StringBuilder s = new StringBuilder();
        for (DiploidGenotype g : DiploidGenotype.values()) {
            s.append(String.format("%s %.10f ", new Object[]{g, this.log10Likelihoods[g.ordinal()]}));
            sum += Math.pow(10.0, this.log10Likelihoods[g.ordinal()]);
        }
        s.append(String.format(" %f", sum));
        return s.toString();
    }

    public boolean validate() {
        return this.validate(true);
    }

    public boolean validate(boolean throwException) {
        try {
            for (DiploidGenotype g : DiploidGenotype.values()) {
                String bad = null;
                int i = g.ordinal();
                if (!MathUtils.wellFormedDouble(this.log10Likelihoods[i]) || !MathUtils.isNegativeOrZero(this.log10Likelihoods[i])) {
                    bad = String.format("Likelihood %f is badly formed", this.log10Likelihoods[i]);
                }
                if (bad == null) continue;
                throw new IllegalStateException(String.format("At %s: %s", g.toString(), bad));
            }
        }
        catch (IllegalStateException e) {
            if (throwException) {
                throw new RuntimeException(e);
            }
            return false;
        }
        return true;
    }

    static {
        for (DiploidGenotype g : DiploidGenotype.values()) {
            DiploidSNPGenotypeLikelihoods.genotypeZeros[g.ordinal()] = 0.0;
        }
        for (byte base : BaseUtils.BASES) {
            DiploidSNPGenotypeLikelihoods.baseZeros[BaseUtils.simpleBaseToBaseIndex((byte)base)] = 0.0;
        }
    }
}

