/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class ReadPosRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("ReadPosRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ReadPosRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt vs. Ref read position bias"));
    }

    @Override
    protected void fillQualsFromPileup(byte ref, List<Byte> alts, ReadBackedPileup pileup, List<Double> refQuals, List<Double> altQuals) {
        for (PileupElement p : pileup) {
            int numAlignedBases;
            if (!ReadPosRankSumTest.isUsableBase(p)) continue;
            int readPos = AlignmentUtils.calcAlignmentByteArrayOffset(p.getRead().getCigar(), p, 0, 0);
            if (readPos > (numAlignedBases = AlignmentUtils.getNumAlignedBases(p.getRead())) / 2) {
                readPos = numAlignedBases - (readPos + 1);
            }
            if (p.getBase() == ref) {
                refQuals.add(Double.valueOf(readPos));
                continue;
            }
            if (!alts.contains(p.getBase())) continue;
            altQuals.add(Double.valueOf(readPos));
        }
    }

    @Override
    protected void fillQualsFromPileup(Allele ref, List<Allele> alts, int refLoc, Map<Allele, List<GATKSAMRecord>> stratifiedContext, List<Double> refQuals, List<Double> altQuals) {
        for (Map.Entry<Allele, List<GATKSAMRecord>> alleleBin : stratifiedContext.entrySet()) {
            boolean matchesRef = ref.equals(alleleBin.getKey());
            boolean matchesAlt = alts.contains(alleleBin.getKey());
            if (!matchesRef && !matchesAlt) continue;
            for (GATKSAMRecord read : alleleBin.getValue()) {
                int numAlignedBases;
                int offset = ReadUtils.getReadCoordinateForReferenceCoordinate(read.getSoftStart(), read.getCigar(), refLoc, ReadUtils.ClippingTail.RIGHT_TAIL, true);
                if (offset == -1) continue;
                int readPos = AlignmentUtils.calcAlignmentByteArrayOffset(read.getCigar(), offset, false, false, 0, 0);
                if (readPos > (numAlignedBases = AlignmentUtils.getNumAlignedBasesCountingSoftClips(read)) / 2) {
                    readPos = numAlignedBases - (readPos + 1);
                }
                if (matchesRef) {
                    refQuals.add(Double.valueOf(readPos));
                    continue;
                }
                altQuals.add(Double.valueOf(readPos));
            }
        }
    }

    @Override
    protected void fillIndelQualsFromPileup(ReadBackedPileup pileup, List<Double> refQuals, List<Double> altQuals) {
        HashMap<PileupElement, LinkedHashMap<Allele, Double>> indelLikelihoodMap = IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap();
        for (PileupElement p : pileup) {
            int numAlignedBases;
            if (!indelLikelihoodMap.containsKey(p)) continue;
            LinkedHashMap<Allele, Double> el = indelLikelihoodMap.get(p);
            double refLikelihood = 0.0;
            double altLikelihood = Double.NEGATIVE_INFINITY;
            for (Map.Entry<Allele, Double> a : el.entrySet()) {
                if (a.getKey().isReference()) {
                    refLikelihood = a.getValue();
                    continue;
                }
                double like = a.getValue();
                if (!(like >= altLikelihood)) continue;
                altLikelihood = like;
            }
            int readPos = this.getOffsetFromClippedReadStart(p.getRead(), p.getOffset());
            if (readPos > (numAlignedBases = this.getNumAlignedBases(p.getRead())) / 2) {
                readPos = numAlignedBases - (readPos + 1);
            }
            if (refLikelihood > altLikelihood + 0.1) {
                refQuals.add(Double.valueOf(readPos));
                continue;
            }
            if (!(altLikelihood > refLikelihood + 0.1)) continue;
            altQuals.add(Double.valueOf(readPos));
        }
    }

    int getNumClippedBasesAtStart(SAMRecord read) {
        Cigar c = read.getCigar();
        CigarElement first = c.getCigarElement(0);
        int numStartClippedBases = 0;
        if (first.getOperator() == CigarOperator.H) {
            numStartClippedBases = first.getLength();
        }
        byte[] unclippedReadBases = read.getReadBases();
        byte[] unclippedReadQuals = read.getBaseQualities();
        for (int i = numStartClippedBases; i < unclippedReadBases.length && unclippedReadQuals[i] < 20; ++i) {
            ++numStartClippedBases;
        }
        return numStartClippedBases;
    }

    int getNumAlignedBases(SAMRecord read) {
        return read.getReadLength() - this.getNumClippedBasesAtStart(read) - this.getNumClippedBasesAtEnd(read);
    }

    int getNumClippedBasesAtEnd(SAMRecord read) {
        Cigar c = read.getCigar();
        CigarElement last = c.getCigarElement(c.numCigarElements() - 1);
        int numEndClippedBases = 0;
        if (last.getOperator() == CigarOperator.H) {
            numEndClippedBases = last.getLength();
        }
        byte[] unclippedReadBases = read.getReadBases();
        byte[] unclippedReadQuals = read.getBaseQualities();
        for (int i = unclippedReadBases.length - numEndClippedBases - 1; i >= 0 && unclippedReadQuals[i] < 20; --i) {
            ++numEndClippedBases;
        }
        return numEndClippedBases;
    }

    int getOffsetFromClippedReadStart(SAMRecord read, int offset) {
        return offset - this.getNumClippedBasesAtStart(read);
    }
}

