/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.annotator.RankSumTest;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class ClippingRankSumTest
extends RankSumTest {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("ClippingRankSum");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("ClippingRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref number of hard clipped bases"));
    }

    @Override
    protected void fillQualsFromPileup(byte ref, List<Byte> alts, ReadBackedPileup pileup, List<Double> refQuals, List<Double> altQuals) {
    }

    @Override
    protected void fillQualsFromPileup(Allele ref, List<Allele> alts, int refLoc, Map<Allele, List<GATKSAMRecord>> stratifiedContext, List<Double> refQuals, List<Double> altQuals) {
        for (Map.Entry<Allele, List<GATKSAMRecord>> alleleBin : stratifiedContext.entrySet()) {
            boolean matchesRef = ref.equals(alleleBin.getKey());
            boolean matchesAlt = alts.contains(alleleBin.getKey());
            if (!matchesRef && !matchesAlt) continue;
            for (GATKSAMRecord read : alleleBin.getValue()) {
                if (matchesRef) {
                    refQuals.add(Double.valueOf(AlignmentUtils.getNumHardClippedBases(read)));
                    continue;
                }
                altQuals.add(Double.valueOf(AlignmentUtils.getNumHardClippedBases(read)));
            }
        }
    }

    @Override
    protected void fillIndelQualsFromPileup(ReadBackedPileup pileup, List<Double> refQuals, List<Double> altQuals) {
    }
}

