/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class Bases
implements Iterable<Byte> {
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    public static final Bases instance = new Bases();
    private static final List<Byte> allBases;
    private static final Map<Integer, Byte> basesByPack;

    private Bases() {
    }

    public static Collection<Byte> allOf() {
        return allBases;
    }

    public static int size() {
        return allBases.size();
    }

    @Override
    public Iterator<Byte> iterator() {
        return basesByPack.values().iterator();
    }

    public static byte fromPack(int pack) {
        return basesByPack.get(pack);
    }

    public static int toPack(byte ascii) {
        for (Map.Entry<Integer, Byte> entry : basesByPack.entrySet()) {
            if (!entry.getValue().equals(ascii)) continue;
            return entry.getKey();
        }
        throw new ReviewedStingException(String.format("Base %c is an invalid base to pack", Character.valueOf((char)ascii)));
    }

    public static Byte fromASCII(byte base) {
        Byte found = null;
        for (Byte normalized : allBases) {
            if (!normalized.equals(base)) continue;
            found = normalized;
            break;
        }
        return found;
    }

    static {
        basesByPack = new HashMap<Integer, Byte>();
        ArrayList<Byte> bases = new ArrayList<Byte>();
        bases.add((byte)65);
        bases.add((byte)67);
        bases.add((byte)71);
        bases.add((byte)84);
        allBases = Collections.unmodifiableList(bases);
        for (int i = 0; i < allBases.size(); ++i) {
            basesByPack.put(i, allBases.get(i));
        }
    }
}

