<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- 
  This file is automatically built from meme.xsl.in at MAKE time.

  This stylesheet transforms the XML output of MEME into HTML closely matching
  the appearance of the HTML generated by previous versions of MEME.
-->

  <xsl:output method="html" indent="yes" 
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
  />

  <!-- Stylesheet processing starts here -->
  <xsl:template match="/MEME">
    <html>
      <xsl:call-template name="html-head"/>
      <body bgcolor='#D5F0FF'>
        <form 
          enctype="application/x-www-form-urlencoded"
          method = "post"
          target = "_new"
          action = "http://meme.nbcr.net/meme/cgi-bin/process_request.cgi"
        >
        <!-- Create the various sub-sections of the document -->
        <xsl:call-template name="top-buttons"/>
        <xsl:call-template name="meme-version"/>
        <xsl:call-template name="reference"/>
        <xsl:call-template name="training-set"/>
        <xsl:call-template name="model"/>
        <xsl:call-template name="motifs"/>
        <xsl:call-template name="scanned_site_summary"/>
        <xsl:call-template name="explanation"/>
      </form>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="html-head">
    <!-- This template prints the HTML head block, including the document level CSS. -->
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
      <title>MEME</title>
      <style type="text/css">
        td.left {text-align: left;}
        td.right {text-align: right; padding-right: 1cm;}
      </style>
    </head>
  </xsl:template>

  <xsl:template name="top-buttons">
    <!-- The template prints the HTML for the buttons at the top of the document. -->
    <a name='top_buttons'/>
    <hr/>
    <table summary='buttons' align="left" cellspacing="0">
      <!-- These anchors navigate to the different sections of the document. -->
      <tr>
        <td bgcolor='#DDDDFF'><a href="#command"><b>Command line</b></a></td>
        <td bgcolor='#00FFFF'><a href="#sequences"><b>Training Set</b></a></td>
        <td bgcolor='#DDFFDD'><a href="#summary1"><b>First Motif</b></a></td>
        <td bgcolor='#FFDDFF'><a href="#motif-summary"><b>Summary of Motifs</b></a></td>
        <td bgcolor='#00FF00'><a href="#stopped"><b>Termination</b></a></td>
        <td bgcolor='#FFFF00'><a href="#explanation"><b>Explanation</b></a></td>
      </tr>
    </table>
    <br clear="left"/>
    <b>
      <br/>
      <!-- These buttons post the document form to other web sites for further analysis. -->
      <input type="submit" name="action" value="MAST"/>
      Search sequence databases for the best combined matches with these motifs using
      <a href="http://meme.nbcr.net/meme/mast-intro.html">MAST.</a>
      <!--
      <br/>
      <input type="submit" name="action" value="MetaMEME"/>
      Build and use a motif-based hidden Markov model (HMM) using 
      <a href="http://meme.nbcr.net/meme/">Meta-MEME.</a>
      -->
      <br/>
      <input type="submit" name="action" value="FIMO"/>
      Search sequence databases for all matches with these motifs using
      <a href="http://meme.nbcr.net/meme/fimo-intro.html">FIMO</a>.
      <xsl:choose> 
        <xsl:when test="/MEME/training_set/alphabet/@id='nucleotide'">
	      <br />
	      <input type="submit" name="action" value="GOMO"/>
	      Find Genome Ontology terms associated
	      with upstream sequences matching these motifs using 
	      <a href="http://meme.nbcr.net/meme/gomo-intro.html">GOMO</a>.
	</xsl:when>
      </xsl:choose> 
      <br/>
      <input type="submit" name="action" value="BLOCKS"/>
      Submit these motifs to 
      <a href="http://blocks.fhcrc.org/blocks/process_blocks.html">
        BLOCKS multiple alignment processor.
      </a>
      <br/>
    </b>
    <br clear="left"/>
  </xsl:template>

  <xsl:template name="reference">
    <!-- This template prints the instructions for citing MEME. -->
    <hr/>
    <center>
      <a name="reference"/>
      <big><b><a href="#reference_doc">REFERENCE</a></b></big>
    </center>
    <hr/>
    <p>
    If you use this program in your research, please cite:
    </p>
    <h4>
    Timothy L. Bailey and Charles Elkan,
    "Fitting a mixture model by expectation maximization to discover
    motifs in biopolymers", Proceedings of the Second International
    Conference on Intelligent Systems for Molecular Biology, pp. 28-36,
    AAAI Press, Menlo Park, California, 1994.
    </h4>
  </xsl:template>

  <xsl:template name="meme-version">
    <!-- This template prints the HTML describing the version of MEME that generated this document. -->
    <hr/>
    <center>
      <a name="version"/>
      <big><b><a href="#version_doc">MEME - Motif discovery tool</a></b></big>
     </center>
     <hr/>
     <p>
     <!-- Don't change the next line. It is used as a landmark for parsing by meme-io.c -->
MEME version <xsl:value-of select="@version"/> (Release date: <xsl:value-of select="@release"/>)
     </p>
     <p>
     For further information on how to interpret these results or to get
     a copy of the MEME software please access 
     <a href="http://meme.sdsc.edu">http://meme.sdsc.edu</a>.
     </p>
     <p>
     This file may be used as input to the MAST algorithm for searching
     sequence databases for matches to groups of motifs.  MAST is available
     for interactive use and downloading at 
     <a href="http://meme.sdsc.edu">http://meme.sdsc.edu</a>.
     </p>
  </xsl:template>

  <xsl:template name="training-set">
    <!-- 
      This template prints the HTML descibing the input sequences
      that were used to generate this document.
     -->
    <hr/>
    <xsl:variable name="alphabet">
      <xsl:call-template name="alphabet"/>
    </xsl:variable>
    <hr/>
    <center>
      <big>
        <b><a name="sequences"/><a href="#sequences_doc">TRAINING SET</a></b>
      </big>
    </center>
    <hr/>
    <table style="line-height: 1em; font-family: monospace;">
    <thead>
    <tr><td>DATAFILE= <xsl:value-of select="/MEME/training_set/@datafile"/></td></tr>
    <tr><td>
     <!-- Don't change the next line. It is used as a landmark for parsing by meme-io.c -->
ALPHABET= <xsl:value-of select="$alphabet"/>
<xsl:text>&#10;</xsl:text>
    </td></tr>
    <!-- Print the HTML describing the input sequences in two columns, in document order. -->
    <tr>
    <td style="padding-right: 2em; border-bottom: dashed thin black;">Sequence name</td>
    <td style="padding-right: 2em; border-bottom: dashed thin black;">Weight</td>
    <td align="right" style="border-bottom: dashed thin black;">Length</td>
    <td style="padding-left: 5em; padding-right: 2em; border-bottom: dashed thin black;">Sequence name</td>
    <td style="padding-right: 2em; border-bottom: dashed thin black;">Weight</td>
    <td align="right" style="border-bottom: dashed thin black;">Length</td>
    </tr>
    </thead>
    <tbody>
    <!-- The following template does the pairwise printing of the sequence data.  -->
    <xsl:apply-templates select="/MEME/training_set/sequence[position() mod 2 = 1]"/>
    </tbody>
    </table>
    <xsl:text>&#10;</xsl:text>
    <!-- Print hidden fields that are used to POST the MEME results to a web server. -->
    <input type="hidden" name="name" value="{/MEME/training_set/@datafile}"/>
    <xsl:text>&#10;</xsl:text>
    <input type="hidden" name="alphabet" value="{$alphabet}"/>
    <xsl:text>&#10;</xsl:text>
    <input type="hidden" name="url" value="http://meme.nbcr.net/meme"/>
    <xsl:text>&#10;</xsl:text>
    <input type="hidden" name="version" value="MEME version {/MEME/@version}"/>
    <xsl:text>&#10;</xsl:text>
    <xsl:choose>
        <xsl:when test="/MEME/model/strands='both'">
          <input type="hidden" name="version" value="strands: + -"/>
        </xsl:when>
        <xsl:when test="/MEME/model/strands='forward'">
          <input type="hidden" name="version" value="strands: +"/>
        </xsl:when>
      </xsl:choose>
      <xsl:variable name="bg_freq"><xsl:call-template name="bg_freq"/></xsl:variable>
      <xsl:text>&#10;</xsl:text>
      <input type="hidden" name="bgfreq" value="{$bg_freq}"/>
  </xsl:template>

  <xsl:template match="sequence">
    <!-- This template prints the individual sequences in 2 columns -->
    <tr>
      <td style="padding-right: 2em"><xsl:value-of select="@name"/></td>
      <td style="padding-right: 2em"><xsl:value-of select="format-number(@weight, '0.0000')"/></td>
      <td align="right"><xsl:value-of select="@length"/></td>
      <xsl:choose>
      <xsl:when test="count(following-sibling::*[name()=name(current())])">
        <td style="padding-left: 5em; padding-right: 2em"><xsl:value-of select="following-sibling::*/@name"/></td>
        <td style="padding-right: 2em"><xsl:value-of select="format-number(following-sibling::*/@weight, '0.0000')"/></td>
        <td align="right"><xsl:value-of select="following-sibling::*/@length"/></td>
      </xsl:when>
      <xsl:otherwise>
        <td style="padding-left: 5em; padding-right: 2em"></td>
        <td style="padding-right: 2em"></td>
        <td align="right"></td>
      </xsl:otherwise>
      </xsl:choose>
    </tr>
  </xsl:template>

  <xsl:template name="model">
    <!-- This template print the HTML describing the MEME input parameters. -->
    <hr/>
    <center>
      <a name="command"/>
      <big><b><a href="#command_doc">COMMAND LINE SUMMARY</a></b></big>
    </center>
    <hr/>
    <pre>
This information can also be useful in the event you wish to report a
problem with the MEME software.

command: <xsl:value-of select="/MEME/model/command_line"/>
    </pre>
    <table style="line-height: 1em; font-family: monospace;">
      <tr>
        <td class="left">model:</td>
        <td class="left">mod=</td>
        <td class="right"><xsl:value-of select="/MEME/model/type"/></td>
        <td class="left">nmotifs=</td>
        <td class="right"><xsl:value-of select="/MEME/model/nmotifs"/></td>
        <td class="left">evt=</td>
        <td class="right"><xsl:value-of select="/MEME/model/evalue_threshold"/></td>
      </tr>
      <tr>
       <td class="left" colspan="4">object function= <xsl:value-of select="/MEME/model/object_function"/></td>
       <td class="left"></td>
       <td class="right"></td>
       <td class="left"></td>
       <td class="right"></td>
       <td class="left"></td>
       <td class="right"></td>
      </tr>
      <tr>
        <td class="left">width:</td>
        <td class="left">minw=</td>
        <td class="right"><xsl:value-of select="/MEME/model/min_width"/></td>
        <td class="left">maxw=</td>
        <td class="right"><xsl:value-of select="/MEME/model/max_width"/></td>
        <td class="left">minic=</td>
        <td class="right"><xsl:value-of select="/MEME/model/minic"/></td>
      </tr>
      <tr>
        <td class="left">width:</td>
        <td class="left">wg=</td>
        <td class="right"><xsl:value-of select="/MEME/model/wg"/></td>
        <td class="left">ws=</td>
        <td class="right"><xsl:value-of select="/MEME/model/ws"/></td>
        <td class="left">endgaps=</td>
        <td class="right"><xsl:value-of select="/MEME/model/endgaps"/></td>
      </tr>
      <tr>
        <td class="left">nsites:</td>
        <td class="left">minsites=</td>
        <td class="right"><xsl:value-of select="/MEME/model/minsites"/></td>
        <td class="left">maxsites=</td>
        <td class="right"><xsl:value-of select="/MEME/model/maxsites"/></td>
        <td class="left">wnsites=</td>
        <td class="right"><xsl:value-of select="/MEME/model/wnsites"/></td>
      </tr>
      <tr>
        <td class="left">theta:</td>
        <td class="left">prob=</td>
        <td class="right"><xsl:value-of select="/MEME/model/prob"/></td>
        <td class="left">spmap=</td>
        <td class="right"><xsl:value-of select="/MEME/model/spmap"/></td>
        <td class="left">spfuzz=</td>
        <td class="right"><xsl:value-of select="/MEME/model/spfuzz"/></td>
      </tr>
      <tr>
        <td class="left">em:</td>
        <td class="left">prior=</td>
        <td class="right"><xsl:value-of select="/MEME/model/prior"/></td>
        <td class="left">b=</td>
        <td class="right"><xsl:value-of select="/MEME/model/beta"/></td>
        <td class="left">maxiter=</td>
        <td class="right"><xsl:value-of select="/MEME/model/maxiter"/></td>
      </tr>
      <tr>
        <td class="left"></td>
        <td class="left">distance=</td>
        <td class="right"><xsl:value-of select="/MEME/model/distance"/></td>
      </tr>
      <tr>
        <td class="left">data:</td>
        <td class="left">n=</td>
        <td class="right"><xsl:value-of select="/MEME/model/num_positions"/></td>
        <td class="left">N=</td>
        <td class="right"><xsl:value-of select="/MEME/model/num_sequences"/></td>
      </tr>
      <xsl:choose>
        <xsl:when test="/MEME/model/strands='both'">
          <tr><td><xsl:text>&#10;strands: + -&#10;</xsl:text></td></tr>
        </xsl:when>
        <xsl:when test="/MEME/model/strands='forward'">
          <tr><td><xsl:text>&#10;strands: +&#10;</xsl:text></td></tr>
        </xsl:when>
      </xsl:choose>
      <tr>
        <td class="left">sample:</td>
        <td class="left">seed=</td>
        <td class="right"><xsl:value-of select="/MEME/model/seed"/></td>
        <td class="left">seqfrac=</td>
        <td class="right"><xsl:value-of select="/MEME/model/seqfrac"/></td>
      </tr>
      <xsl:if test="string-length(/MEME/model/@priors_file)">
        <tr><td colspan="4">
          Dirichlet mixture priors file: <xsl:value-of select="/MEME/model/@priors_file"/>
        </td></tr>
      </xsl:if>
      <xsl:variable name="letter_freq"><xsl:call-template name="letter_freq"/></xsl:variable>
      <xsl:variable name="bg_freq"><xsl:call-template name="bg_freq"/></xsl:variable>
      <tr><td colspan="4">Letter frequencies in dataset:</td></tr>
      <tr><td colspan="4"><xsl:value-of select="$letter_freq"/></td></tr>
      <tr><td colspan="4">
      <!-- Don't change the next line. It is used as a landmark for parsing by meme-io.c -->
      Background letter frequencies (from <xsl:value-of select="/MEME/model/background_frequencies/@source"/>):<br/>
      <xsl:text>&#10;</xsl:text>
      <xsl:value-of select="$bg_freq"/>
      <!-- Don't change the next 3 lines. They are used as a landmark for parsing by meme-io.c -->
      <xsl:text>&#10;</xsl:text>
      <input type="hidden" name="bgfreq" value="{$bg_freq}"/>
      <xsl:text>&#10;</xsl:text></td></tr>
    </table>
  </xsl:template>

  <xsl:template name="motifs">
    <xsl:for-each select="/MEME/motifs/motif">
      <xsl:call-template name="motif"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="motif">
      <xsl:variable name="motif_index" select="position()" />
      <xsl:variable name="motif_width" select="@width" />
      <xsl:variable name="motif_id" select="@id" />
      <hr/>
      <center>
      <a name='summary{$motif_index}'/>
      <table summary='buttons' align='left' cellspacing='0'>
        <tr>
          <xsl:choose>
            <xsl:when test="position()=1">
              <td bgcolor="#00FFFF"><a href="#motif-summary"><b>P</b></a></td>
            </xsl:when>
            <xsl:otherwise>
              <td bgcolor="#00FFFF"><a href="#summary{$motif_index - 1}"><b>P</b></a></td>
            </xsl:otherwise>
          </xsl:choose>
          <td bgcolor="#FFFF00"><a href="#summary{$motif_index + 1}"><b>N</b></a></td>
        </tr>
      </table> 
      <big><b>
      <a href="#summary_doc">MOTIF <xsl:value-of select="@name"/></a>  
      width = <xsl:value-of select="@width"/>
      sites = <xsl:value-of select="@sites"/>
      llr = <xsl:value-of select="@llr"/>
      E-value = <xsl:value-of select="@e_value"/>
      <br clear='left'/>
      </b></big>
      </center>
      <hr/>
      <table>
        <tr>
          <th>
          <a name='logo{$motif_index}'/><a href="#logo_doc">SEQUENCE LOGO</a>
          </th>
          <td rowspan="4">
            <img src='logo{$motif_index}.png' alt='PNG LOGOS require CONVERT from ImageMagick; see MEME installation guide'/>
          </td>
        </tr>
        <tr> 
          <td align="center"> 
            <table>
	      <tr><th>
		<a href="#ic_doc">Information Content</a> 
	      </th></tr>
	      <tr><td align="center">
		 <b><xsl:value-of select="@ic"/> (bits) </b> 
	      </td></tr>
            </table>
          </td> 
        </tr> 
        <tr> 
          <td align="center"> 
            <table>
	      <tr><th>
		<a href="#re_doc">Relative Entropy</a> 
	      </th></tr>
	      <tr><td align="center">
		 <b><xsl:value-of select="@re"/> (bits) </b> 
	      </td></tr>
            </table>
          </td> 
        </tr> 

        <tr> 
          <td align="center"> 
            <table>
	      <tr>
                <th>
	  	  <a href="#download"> Download LOGO</a>
	        </th>
              </tr>
	      <tr>
                <td>
	    	  <b>Without SSC:</b> 
		  <a href="logo{$motif_index}.eps">[EPS]</a>
		  <a href="logo{$motif_index}.png">[PNG]</a>
		</td>
              </tr>
	      <tr>
                <td>
		  <b>With SSC:</b> 
		   <a href="logo_ssc{$motif_index}.eps">[EPS]</a>
		   <a href="logo_ssc{$motif_index}.png">[PNG]</a>
		</td>
              </tr>
            </table>
          </td> 
        </tr> 

      </table>
      <xsl:call-template name="contributing_site_table">
        <xsl:with-param name="motif_width" select="$motif_width"/>
      </xsl:call-template>
      <hr/>
      <center>
        <big><b>
          <a name="diagrams{$motif_index}"></a>
          <a href="#diagrams_doc">Motif <xsl:value-of select="$motif_index"/> block diagrams</a> 
        </b></big>
      </center>
      <hr/>
      <xsl:call-template name="contributing_site_diagram">
        <xsl:with-param name="motif_index" select="$motif_index"/>
        <xsl:with-param name="motif_width" select="$motif_width"/>
      </xsl:call-template>
      <hr/>
      <center>
        <big><b>
          <a name="blocks{$motif_index}"/>
          <a href="#BLOCKS_doc">Motif <xsl:value-of select="$motif_index"/> in BLOCKS format</a> 
        </b></big>
      </center>
      <hr/>
<xsl:variable name="blocks">
<xsl:text>
BL   MOTIF </xsl:text><xsl:value-of select="$motif_index"/> width=<xsl:value-of select="@width"/> seqs=<xsl:value-of select="@sites"/><xsl:text>
</xsl:text>
<xsl:for-each select="contributing_sites/contributing_site"><xsl:value-of select="id(@sequence_id)/@name"/>  ( <xsl:value-of select="@position"/>) <xsl:for-each
select="site/letter_ref"><xsl:value-of select="id(@letter_id)/@symbol"/></xsl:for-each> 1 
</xsl:for-each>//

</xsl:variable>
<input type="hidden" name="BLOCKS{$motif_index}" value="{$blocks}"/>
<xsl:text>&#10;</xsl:text>
<input type="submit" name="action" value="View BLOCK {$motif_index}"/>
<xsl:text>&#10;</xsl:text>
<input type ="submit" name="action" value="View FASTA {$motif_index}"/>
<xsl:text>&#10;</xsl:text>
<input type ="submit" name="action" value="View RAW {$motif_index}"/>
<xsl:text>&#10;</xsl:text>
<br/><input type="submit" name="action" value="Submit BLOCK {$motif_index}"/>
      <xsl:text>&#10;</xsl:text>
      <b> to <a href="http://blocks.fhcrc.org/blocks/process_blocks.html">BLOCKS multiple alignment processor.</a></b>
      <xsl:call-template name="pssm">
        <xsl:with-param name="motif_index" select="$motif_index"/>
      </xsl:call-template>
      <input type="submit" name="action" value ="View PSSM {$motif_index}"/>
      <xsl:text>&#10;</xsl:text>
      <br/>
      <input type ="submit" name="action" value="MAST PSSM {$motif_index}"/>
          <b> Scan sequence databases for the best match in each sequence using <a href="http://meme.nbcr.net/meme/cgi-bin/mast.cgi">MAST</a>.</b>
<xsl:text>&#10;</xsl:text>
      <xsl:text>&#10;</xsl:text>
      <xsl:call-template name="pspm">
        <xsl:with-param name="motif_index" select="$motif_index"/>
      </xsl:call-template>
      <input type="submit" name="action" value ="View PSPM {$motif_index}"/>
      <xsl:text>&#10;</xsl:text>
      <br/>
      <input type = 'submit' name = 'action' value = 'FIMO PSPM {$motif_index}'/>
      <b> Scan sequence databases for all matches with this motif using <a href="http://meme.nbcr.net/meme/cgi-bin/fimo.cgi">FIMO</a>.</b>
      <xsl:choose> 
        <xsl:when test="/MEME/training_set/alphabet/@id='nucleotide'">
          <br/>
          <input type = 'submit' name = 'action' value = 'TOMTOM PSPM {$motif_index}'/>
          <b> Compare to known motifs in motif databases using 
              <a href="http://meme.nbcr.net/meme/cgi-bin/tomtom.cgi">Tomtom</a>.</b>
	  <br/>
	  <input type = 'submit' name = 'action' value = 'GOMO PSPM {$motif_index}'/>
          <b> Find Genome Ontology terms associated with 
              upstream regions matching this motif using 
              <a href="http://meme.nbcr.net/meme/cgi-bin/gomo.cgi">GOMO</a>.</b>
        </xsl:when>
      </xsl:choose>
      <hr/>
      <center>
        <big><b>
          <a name="regular_expression{$motif_index}"/>
          <a href="#regular_expression_doc">Motif <xsl:value-of select="$motif_index"/> regular-expression</a> 
        </b></big>
      </center>
      <hr/>
      <b>
      <xsl:value-of select="./regular_expression"/>
      </b>
      <br/>
      <hr/>
      <tt>
      Time <xsl:value-of select="format-number(@elapsed_time, '0.00')"/> secs.
      </tt>
      <br/>
  </xsl:template>

  <xsl:template name="scanned_site_summary">
    <xsl:variable name="num_motifs" select="count(motifs/motif)"/>
    <hr/>
    <table summary="buttons" align="left" cellspacing="0">
      <tr>
        <td bgcolor='#OOFFFF'><a href="#summary{$num_motifs}"><b>P</b></a></td>
        <td bgcolor='#FFFFOO'><a href="#summary1"><b>N</b></a></td>
      </tr>
    </table> 
    <center><big><b>
      <a name="summary{$num_motifs+1}"/>
      <a name="motif-summary"/>
      <a href="#motif-summary_doc">SUMMARY OF MOTIFS</a>
    </b></big></center>
    <hr/>
    <hr/>
    <center><big><b>
    Combined block diagrams: non-overlapping sites with p-value &lt;
    <xsl:value-of select="scanned_sites_summary/@p_thresh"/></b></big></center>
    <hr/>
    <xsl:call-template name="scanned_site_diagram"/>
    <xsl:call-template name="machine_readable_scanned_site_summary"/>
    <xsl:text>
    </xsl:text>
    <input type="hidden" name="nmotifs" value="3"/>
    <br/>
    <input type="submit" name="action" value="View motif summary"/>
    <b>Motif summary in machine readable format.</b>
    <hr/>
    <center><big><b>
      <a name="stopped"/>
      <a href="#stopped_doc">Stopped</a>  
      because <xsl:value-of select="/MEME/model/reason_for_stopping"/>.
    </b></big></center>
    <hr/>
    <tt>
    <br/>
    <br/>
    CPU:  <xsl:value-of select="/MEME/model/host"/>
    <br/>
    <br/>
    </tt>
  </xsl:template>

  <xsl:template name="alphabet">
    <!-- This template concatenates the symbols of the alphabet into a single string. -->
    <xsl:for-each select="/MEME/training_set/alphabet/letter">
      <xsl:value-of select="@symbol"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="site">
    <!-- This template prints the HTML for color-coded alphabet symbols for a motif site. -->
    <xsl:for-each select="./letter_ref">
      <xsl:call-template name="letter_ref"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="letter_ref">
    <!-- This template prints the HTML for a color-coded symbol alphabet symbold. -->
    <xsl:choose> 
      <xsl:when test="/MEME/training_set/alphabet/@id='amino-acid'">
        <!-- Amino Acid Alphabet -->
        <xsl:call-template name="amino_acid">
          <xsl:with-param name="residue"><xsl:value-of select="id(@letter_id)/@symbol"/></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <!-- DNA Alphabet -->
        <xsl:call-template name="nucleotide">
          <xsl:with-param name="residue"><xsl:value-of select="id(@letter_id)/@symbol"/></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="amino_acid">
    <!-- This template prints a color coded amino acid symbol. -->
    <xsl:param name="residue"/>
    <xsl:variable name="color">
      <xsl:choose> 
        <xsl:when test="$residue='A'">blue</xsl:when>
        <xsl:when test="$residue='C'">blue</xsl:when>
        <xsl:when test="$residue='F'">blue</xsl:when>
        <xsl:when test="$residue='I'">blue</xsl:when>
        <xsl:when test="$residue='L'">blue</xsl:when>
        <xsl:when test="$residue='V'">blue</xsl:when>
        <xsl:when test="$residue='W'">blue</xsl:when>
        <xsl:when test="$residue='M'">blue</xsl:when>
        <xsl:when test="$residue='N'">green</xsl:when>
        <xsl:when test="$residue='Q'">green</xsl:when>
        <xsl:when test="$residue='S'">green</xsl:when>
        <xsl:when test="$residue='T'">green</xsl:when>
        <xsl:when test="$residue='D'">magenta</xsl:when>
        <xsl:when test="$residue='E'">magenta</xsl:when>
        <xsl:when test="$residue='K'">red</xsl:when>
        <xsl:when test="$residue='R'">red</xsl:when>
        <xsl:when test="$residue='H'">pink</xsl:when>
        <xsl:when test="$residue='G'">orange</xsl:when>
        <xsl:when test="$residue='P'">yellow</xsl:when>
        <xsl:when test="$residue='Y'">turquoise</xsl:when>
        <xsl:otherwise>black</xsl:otherwise>
      </xsl:choose> 
    </xsl:variable>
    <font color="{$color}"><xsl:value-of select="$residue"/></font>
  </xsl:template>

  <xsl:template name="nucleotide">
    <!-- This template prints a color coded nucleotide symbol.-->
    <xsl:param name="residue"/>
    <xsl:variable name="color">
      <xsl:choose> 
        <xsl:when test="$residue='A'">red</xsl:when>
        <xsl:when test="$residue='C'">blue</xsl:when>
        <xsl:when test="$residue='G'">orange</xsl:when>
        <xsl:when test="$residue='T'">green</xsl:when>
        <xsl:otherwise>black</xsl:otherwise>
      </xsl:choose> 
    </xsl:variable>
    <font color="{$color}"><xsl:value-of select="$residue"/></font>
  </xsl:template>

  <xsl:template name="bg_freq">
    <!-- This template prints the HTML listing the background frequencies for each symbol in the alphabet. -->
    <xsl:text>&#10;</xsl:text>
    <xsl:for-each select="/MEME/model/background_frequencies/alphabet_array/value">
      <xsl:value-of select="id(@letter_id)/@symbol"/><xsl:text> </xsl:text><xsl:value-of select="format-number(., '0.000')"/><xsl:text> </xsl:text>
      <!-- For amino acids insert a line break very 9 characters. -->
      <xsl:variable name="letter_index" select="position()" />
      <xsl:if test="$letter_index mod 9 = 0">
        <xsl:text>&#10;</xsl:text>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="letter_freq">
    <!-- This template prints the HTML listing the observed letter frequencies for each symbol in the alphabet. -->
    <xsl:text>
    </xsl:text>
    <xsl:for-each select="/MEME/training_set/letter_frequencies/alphabet_array/value">
      <xsl:value-of select="id(@letter_id)/@symbol"/><xsl:text> </xsl:text><xsl:value-of select="format-number(., '0.000')"/><xsl:text> </xsl:text>
      <xsl:variable name="letter_index" select="position()" />
      <!-- Insert line break for amino acids -->
      <xsl:if test="$letter_index mod 9 = 0"><br/>
        <xsl:text>
        </xsl:text>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="explanation">
    <!-- This template prints the boilerplate HTML describinb the MEME output document -->
    <a name="explanation"/>
    <center>
      <hr/>
      <h3>
        EXPLANATION OF MEME RESULTS
      </h3>
      <hr/>
    </center>
    <h4>The MEME results consist of:</h4>
    <ul>
      <li>
        <a name="version_doc"/>
        The <a href="#version"><b>version</b></a>
         of MEME and the date it was released.
      </li>
      <li>
        <a name="reference_doc"/>
        The <a href="#reference"><b>reference</b></a>
        to cite if you use MEME in your research.
      </li>
      <li>
        <a name="sequences_doc"/>
        A description of the
        <a href="#sequences"><b>sequences</b></a>
        you submitted (the "training set") showing the name,
        "weight" and length of each sequence.
      </li>
      <li>
        <a name="command_doc"/>
        The <a href="#command"><b>command line summary</b></a> 
        detailing the parameters with which you ran MEME.
      </li>
      <li>
        <a name="motifs_doc"/>
        Information on each of the <a href="#motifs"><b>motifs</b></a> 
        MEME discovered, including:
        <ol>
          <li>
            A <a name="summary_doc" href="#summary_doc2">summary line</a>
            showing the width, number of occurrences, log likelihood ratio
            and statistical significance of the motif.
          </li>
          <li>
            A <a name="logo_doc" href="#logo_doc2"> sequence LOGO</a>. 
          </li>
          <li>
            The <a name="ic_doc" href="#ic_doc2"> information content</a> 
	    of the motif.
          </li>
          <li>
            The <a name="re_doc" href="#re_doc2"> relative entropy</a> 
            of the motif.
          </li>
          <li>
            <a name="download" href="#download2"> Downloadable LOGO files</a> 
	    suitable for publication.
          </li>
          <li>
            The
            <a name="sites_doc" href="#sites_doc2">occurrences of the motif</a>
            sorted by <i>p</i>-value and aligned with each other.
          </li>
          <li>
            <a name="diagrams_doc" href="#diagrams_doc2">Block diagrams</a> 
            of the occurrences of the motif within each sequence in the 
            training set.
          </li>
          <li>
            The motif in 
            <a name="BLOCKS_doc" href="#BLOCKS_doc2">BLOCKS or FASTA format</a>.
          </li>
          <li>
            A <a name="pssm_doc" href="#pssm_doc2">
            position-specific scoring matrix (PSSM)</a> 
            for use by the <a href="meme.nbcr.net/meme/mast-intro.html">MAST</a>
            database search program.
          </li>
          <li>
            The <a name="pspm_doc" href="#pspm_doc2">
            position specific probability matrix (PSPM)</a> 
            describing the motif.
          </li>
          <li>
            A <a name="regular_expression_doc" href="#regular_expression_doc2">
            regular expression</a> describing the motif.
          </li>
        </ol>
      </li>
      <li>
        <a name="motif-summary-doc"/>
         A <a href="#motif-summary"><b>summary of motifs</b></a>
         showing an optimized (non-overlapping) 
         <a href="#motif-summary-doc2">tiling</a> 
         of all of the motifs onto each of the sequences in the training set.
         <a name="stopped_doc"/>
      </li>
      <li>
        The reason why MEME <a href="#stopped">stopped</a>
        and the name of the CPU on which it ran.
        <a name="explanation_doc"/>
      </li>
      <li>
        This <b>explanation</b> of how to interpret MEME results.
      </li>
    </ul>
    <p>
    <a href="#summary1" name="motifs">MOTIFS</a>
    </p>
    <p>
    For each motif that it discovers in the training set,
    MEME prints the following information:
    </p>
    <ul>
      <li>
        <h4><a name="summary_doc2" href="#summary1">Summary Line</a></h4>
        This line gives the width (<b>'width'</b>), 
        number of occurrences in the training set (<b>'sites'</b>), 
        log likelihood ratio (<b>'llr'</b>) and 
        <b>'<i>E</i>-value'</b> of the motif.
        Each motif describes a pattern of a fixed width--no gaps are 
        allowed in MEME motifs.
        MEME numbers the motifs consecutively from one as it finds them. 
        MEME usually finds the most statistically significant
        (low <i>E</i>-value) motifs first.
        The statistical significance of a motif is based on its log 
        likelihood ratio, its width and number of occurrences, the 
        background letter frequencies (given in the 
        <a href="#command_doc">command line summary</a>
        ), and the size of the training set.  The <i>E</i>-value is an
        estimate of the expected number of motifs with the given log 
        likelihood ratio (or higher), and with the same width and number of 
        occurrences, that one would find in a similarly sized set of random 
        sequences. 
        (In random sequences each position is independent with letters chosen
        according to the background letter frequencies.)  The log likelihood
        ratio is the logarithm of the ratio of the probability of the 
        occurrences of the motif given the motif model (likelihood given the 
        motif) versus their probability given the background model 
        (likelihood given the null model).  
        (Normally the background model is a 0-order Markov model
        using the background letter frequencies, but higher order Markov 
        models may be specified via the <b>-bfile</b> option to MEME.)
        Clicking on the <b>buttons</b> to the left of the motif summary line 
        takes you to the previous motif (P) or next motif (N).
      </li>
      <li>
        <h4>
          <a name="logo_doc2" href="#logo1">Sequence LOGO</a>
        </h4>
        MEME motifs are represented by position-specific probability matrices 
        that specify the probability of each possible letter appearing at each
        possible position in an occurrence of the motif.  These are displayed
	as "sequence LOGOS", containing stacks of letters at each position
	in the motif.  The total height of the stack is the "information
        content" of that position in the motif in bits.  The height of the 
        individual letters in a stack is the probability of the letter at that 
	position multiplied by the total information content of the stack.
        <p>
        <a name="download2" href="#logo1">Note:</a>
	The MEME LOGO differs from those produced by the 
        <a href="http://weblogo.berkeley.edu">Weblogo</a> program
	because a <b>small-sample correction is NOT applied</b>.  
        However, MEME LOGOs in PNG and encapsulated postscript (EPS) formats 
	<b>with small-sample correction (SSC)</b> are available by clicking 
	on one of the links named "With SSC" (EPS or PNG) under 
        <a href="#download">Download LOGO</a>.
        The MEME LOGOs without small sample correction are similarly available.
	Error bars are included in the LOGOs with small-sample correction.
        </p>
        The information content of each motif position is computed
 	as described in the paper by Schneider and Stephens, 
	"Sequence Logos: A New Way to Display Consensus Sequences" but
	<b>the small-sample correction, <tt>e(n)</tt>,
        is set to zero for the LOGO displayed in the MEME output.</b>
	The corrected information content of position <tt>i</tt> is given by
         <pre>
           R(i) for amino acids   = log2(20) - (H(i) + e(n))   (1a) 
           R(i) for nucleic acids =    2    - (H(i) + e(n))    (1b)
         </pre>
         where H(i) is the entropy of position <tt>i</tt>,
         <pre>
           H(l) = - (Sum f(a,i) * log2[ f(a,i) ]).             (2)
         </pre>
         Here, f(a,i) is the frequency of base or amino acid <tt>a</tt> 
         at position <tt>i</tt>, and <tt>e(n)</tt> is the 
         small-sample correction for an alignment of <tt>n</tt> letters.
         The height of letter <tt>a</tt> in column <tt>i</tt> is given by
         <pre>
           height = f(a,i) * R(i)                              (3)
         </pre>
         The approximation for the small-sample correction, <tt>e(n)</tt>, 
         is given by:
         <pre>
           e(n) = (s-1) / (2 * ln(2) * n),                     (4)
         </pre>
         where <tt>s</tt> is 4 for nucleotides, 20 for amino acids, and 
         <tt>n</tt> is the number of sequences in the alignment.
         <p>
           The letters in the logos are colored as follows.
	   For DNA sequences, the letter categories contain one letter
	   each.  For proteins,  the categories are based on the biochemical properties
	   of the various amino acids.  The categories and their colors are:
         </p>
	   <center>

	     <table border="1">
        <thead>
	      <tr><th>NUCLEIC ACIDS</th><th align="left">COLOR</th></tr>
        </thead>
	      <tr> 
          <td>A</td> 
          <td><font color="red">RED</font></td>
        </tr>
	      <tr> 
         <td>C</td> 
         <td><font color="blue">BLUE</font></td>
        </tr>
	      <tr> 
          <td>G</td> 
          <td><font color="orange">ORANGE</font></td>
        </tr>
	      <tr> 
		      <td>T</td> 
		      <td><font color="green">GREEN</font></td>
        </tr>
	    </table>
	    <table border="1">
        <thead>
	      <tr> 
          <th>AMINO ACIDS</th> 
          <th align="left">COLOR</th> 
		      <th align="left">PROPERTIES</th> 
        </tr>
        </thead>
        <tr>
          <td>A, C, F, I, L, V, W and M</td>
          <td><font color="blue">BLUE</font></td>
          <td>Most hydrophobic[Kyte and Doolittle, 1982]</td>
	      </tr>
	      <tr>
          <td>NQST</td>
          <td><font color="green">GREEN</font></td>
          <td>Polar, non-charged, non-aliphatic residues</td>
	      </tr>
	      <tr>
          <td>DE</td>
          <td><font color="magenta">MAGENTA</font></td>
          <td>Acidic</td>
	      </tr>
	      <tr>
          <td>KR</td>
          <td><font color="red">RED</font></td>
          <td>Positively charged</td>
	      </tr>
	      <tr>
          <td>H</td>
          <td><font color="pink">PINK</font></td> 
        </tr>
	      <tr>
          <td>G</td>
          <td><font color="orange">ORANGE</font></td> 
        </tr>
        <tr>
          <td>P</td>
          <td><font color="yellow">YELLOW</font></td> 
        </tr>
	      <tr>
	        <td>Y</td>
	        <td><font color="turquoise">TURQUOISE</font></td> 
        </tr>
	     </table>
	  </center>
	 <p>
	   J. Kyte and R. Doolittle, 1982.
	   "A Simple Method for Displaying the Hydropathic Character of a Protein",
	   J. Mol Biol. 157, 105-132.
         </p>
	 <p>
	   <b>Note:</b> the "text" output format of 
	   MEME preserves the historical MEME format where LOGOS 
	   are replaced by a simplified probability matrix, 
	   a relative entropy plot, and a multi-level
	   consensus sequence.
	 </p>
      </li>
      <li>
        <h4>
          <a name="ic_doc2" href="#logo1">Information Content</a>
        </h4>
        This is the information content of the motif in bits.
	    It is equal to the sum of the <b>uncorrected</b> 
            information content, <tt>R()</tt>, 
	    in the columns of the <a href="#logo_doc2">LOGO</a>.
	    This is equal relative entropy of the motif relative to a 
            uniform background frequency model.  
      </li>
      <li>
        <h4>
          <a name="re_doc2" href="#logo1">Relative Entropy</a>
        </h4>
            This is the relative entropy of the motif, 
            computed in bits and relative to the background 
            letter frequencies given in the
	    <a href="#command">command line summary</a>.  It is equal to
	    the <a href="#summary_doc2">log-likelihood ratio (llr)</a> 
            divided by the number of 
            <a href="#summary_doc2">occurrences (sites)</a> 
            of the motif times <tt>1/ln(2)</tt>,
	    <pre>
               re = llr / (sites * ln(2)).
	    </pre>
      </li>
      <li> 
        <h4>
          <a name="sites_doc2" href="#sites1">Occurrences of the Motif</a>
        </h4>
        MEME displays the occurrences (sites) of the motif in the
        training set.  
        The sites are shown aligned with each other, and the ten sequence
        positions preceding and following each site are also shown.
        Each site is identified by the name of the sequence where it occurs,
        the strand (if both strands of DNA sequences are being used), and the
        position in the sequence where the site begins.  When the DNA strand
        is specified, '+' means the sequence in the training set,
        and '-' means the reverse complement of the training set sequence.
        (For '-' strands, the 'start' position is actually the position on the
        <b>positive</b> strand where the site ends.)
        The sites are listed in order of increasing statistical significance
        (<i>p</i>-value).  The <i>p</i>-value of a site is computed from the 
        the match score of the site with the 
        <a href="#pssm_doc2">position specific scoring matrix</a> 
        for the motif.
        The <i>p</i>-value gives the probability of a random string
        (generated from the background letter frequencies) having the
        same match score or higher.
        (This is referred to as the <b>position <i>p</i>-value</b>
        by the MAST algorithm.)
      </li>
      <li>
        <h4>
          <a name="diagrams_doc2" href="#diagrams1">Block Diagrams of Motif Occurrences</a>
        </h4>
        The occurrences of the motif in the training set sequences are 
        shown with MAST-style block diagrams.  One diagram is printed for each
        sequence showing all the occurrences of the motif in that sequence.
        The sequences are sorted by the <b>lowest</b> <xsl:text> </xsl:text> <i>p</i>-value among
        all occurrences of the motif in a given sequence.
        (The <i>p</i>-value of an occurrence is the probability of a single
        random subsequence the length of the motif,
        generated according to the 0-order background model, having a score
        at least as high as the score of the occurrence.)
        When the DNA strand is specified, '+' means the motif appears from
        left to right on the sequence, and '-' means the motif appears
        from right to left on the complementary strand.
        A sequence position scale is shown at the end of each table of block
        diagrams.
        Very long sequences are shown with thick lines connecting the
        motifs and are <b>not</b> drawn to scale.
      </li>
      <li>
        <h4>
          <a name="BLOCKS_doc2" href="#blocks1">Motif in BLOCKS format or FASTA format></a>
        </h4>
        For use with
        <a href="http://blocks.fhcrc.org/blocks">BLOCKS tools</a>,
        MEME prints the occurrences of the motif in BLOCKS format.
        <p>
        You can convert these blocks to 
        PSSMs (position-specific scoring matrices),
        LOGOS (color representations of the motifs),
        phylogeny trees and search them against a database of other
        blocks by pasting everything from the "BL" line to the "//"
        line (inclusive) into the
        <a href="http://blocks.fhcrc.org/blocks/process_blocks.html">
          Multiple Alignment Processor.
        </a> 
        </p>
        If you include the
        <b>-print_fasta</b>
        switch on the command line, MEME prints
        the motif sites in FASTA format instead of BLOCKS format.
      </li>
      <li>
        <h4>
          <a name="pssm_doc2" href="#pssm1">Position-Specific Scoring Matrix</a>
        </h4>
        The position-specific scoring matrix corresponding to the motif 
        is printed for use by database search programs such as MAST.
        This matrix is a log-odds matrix calculated by taking 100 times
        the log (base 2) of the ratio <i>p/f</i> at each position in
        the motif where <i>p</i> is the probability of a particular letter
        at that position in the motif, and <i>f</i> is the background 
        frequency of the letter (given in the 
        <a href="#command_doc">command line summary</a>
        section.)
        This is the same matrix that is used above in computing the
        <i>p</i>-values of the occurrences of the motif in the
        <a href="#sites_doc2">Occurrences of the Motif</a>
        and
        <a href="#diagrams_doc2">Block Diagrams of Motif Occurrences</a>
        sections.  
        The scoring matrix is printed "sideways"--columns
        correspond to the letters in the alphabet (in the same order as 
        shown in the simplified motif) and rows corresponding to the 
        positions of the motif, position one first.
        The scoring matrix is preceded by a line starting with
        "log-odds matrix:" and containing the length of the alphabet, width
        of the motif, number of characters in the training set, the scoring 
        threshold (obsolete) and the motif <i>E</i>-value.
        <p>
        <b>Note:</b> The probability <i>p</i> used to compute the PSSM
        is <i>not</i> exactly the same as the corresponding value in the 
        Position Specific Probability Matrix (PSPM).  
        The values of <i>p</i> used to compute the PSSM take
        into account the motif prior, whereas the values in the PSPM are just
        the <i>observed</i> frequencies of letters in the motif sites.
        </p>
      </li>
      <li> 
        <h4>
          <a name="pspm_doc2" href="#pspm1">Position-Specific Probability Matrix</a>
        </h4>
        The motif itself is a position-specific probability matrix giving,
        for each position in the pattern, the observed frequency 
        ("probability") of each possible letter.  
        The probability matrix is printed "sideways"--columns
        correspond to the letters in the alphabet (in the same order as 
        shown in the simplified motif) and rows corresponding to the 
        positions of the motif, position one first.
        The motif is preceded by a line starting with
        "letter-probability matrix:" and containing the length of the 
        alphabet, width of the motif, number of occurrences of the motif,
        and the <i>E</i>-value of the motif.
        <p>
        <b>Note:</b> Earlier versions
        of MEME gave the posterior probabilities--the probability after 
        applying a prior on letter frequencies--rather than the observed 
        frequencies.
        These versions of MEME also gave the number of <i>possible</i>
        positions for the motif rather than the actual number of occurrences.
        The output from these earlier versions of MEME can be distinguished
        by "n=" rather than "nsites=" in the line preceding the matrix.
        </p>
      </li>
      <li>
        <h4>
          <a name="regular_expression_doc2" href="#regular_expression1">Regular Expression</a>
        </h4>
        This is a regular expression (RE) describing the motif.  In each column,
        all letters with observed frequencies greater than 0.2 are shown;
        less-frequent letters are not included in the RE.
        MEME regular expressions are interpreted as follows: 
        single letters match that letter; groups of letters in square brackets 
        match any of the letters in the group.
        Regular expressions can be used for searching for the motif in
        sequences (using, for example,
        <a href="http://nar.oxfordjournals.org/cgi/content/full/33/suppl_2/W262">
         PatMatch
        </a>
        ) but the search accuracy will usually be better with the PSSM (using,
        for example
        <a href="http://meme.nbcr.net/meme/mast-intro.html">MAST</a>.)
      </li>
      <li>
        <h4>
          <a name="motif-summary-doc2" href="#motif-summary">Motif Summary Tiling</a>
        </h4>
        The motif summary tiling is done using the same algorithm as used by 
        <a href="http://meme.nbcr.net/meme/mast-intro.html">MAST</a>.
        The motif occurrences shown in the motif summary
        <b>may not be exactly the same as those reported in each motif section</b>
        because only motifs with a position <em>p</em>-value of 0.0001 that
        don't overlap other, more significant motif occurrences are shown.
        The format of the machine readable motif-summary is:
        <pre>
        [sequence_name combined_<em>p</em>-value number_of_motif_occurrences [motif_number start_of_motif position_<em>p</em>-value]+]+
        </pre>
        See the documentation for 
        <a href="http://meme.nbcr.net/meme/mast-output.html">MAST output</a>
        for the definition of position and
        combined <em>p</em>-values.
      </li>
    </ul>
  </xsl:template>

  <xsl:template name="ticks">
      <xsl:param name="count" select="1"/>
      <xsl:param name="limit" select="1"/>
      <xsl:if test="$count &lt; $limit">
        <td style="width: 50px;" align="left"><font color="blue">|</font></td>
        <xsl:call-template name="ticks">
          <xsl:with-param name="count" select="$count + 24"/>
          <xsl:with-param name="limit" select="$limit"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>

  <xsl:template name="scale">
      <xsl:param name="count" select="1"/>
      <xsl:param name="limit" select="1"/>
      <xsl:if test="$count &lt; $limit">
        <td style="width: 50px;" align="left"><font color="blue"><xsl:value-of select="$count"/></font></td>
        <xsl:if test="$count = 1">
          <xsl:call-template name="scale">
            <xsl:with-param name="limit" select="$limit"/>
            <xsl:with-param name="count" select="$count + 24"/>
          </xsl:call-template>
        </xsl:if>
        <xsl:if test="$count > 1">
          <xsl:call-template name="scale">
            <xsl:with-param name="limit" select="$limit"/>
            <xsl:with-param name="count" select="$count + 25"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
  </xsl:template>

  <xsl:template name="pick_color">
    <xsl:param name="index" select="1"/>
    <xsl:choose>
      <xsl:when test="($index mod 16) = 1">aqua</xsl:when>
      <xsl:when test="($index mod 16) = 2">blue</xsl:when>
      <xsl:when test="($index mod 16) = 3">red</xsl:when>
      <xsl:when test="($index mod 16) = 4">fuchsia</xsl:when>
      <xsl:when test="($index mod 16) = 5">yellow</xsl:when>
      <xsl:when test="($index mod 16) = 6">lime</xsl:when>
      <xsl:when test="($index mod 16) = 7">teal</xsl:when>
      <xsl:when test="($index mod 16) = 8">#444444</xsl:when>
      <xsl:when test="($index mod 16) = 9">green</xsl:when>
      <xsl:when test="($index mod 16) = 10">silver</xsl:when>
      <xsl:when test="($index mod 16) = 11">purple</xsl:when>
      <xsl:when test="($index mod 16) = 12">olive</xsl:when>
      <xsl:when test="($index mod 16) = 13">navy</xsl:when>
      <xsl:when test="($index mod 16) = 14">maroon</xsl:when>
      <xsl:when test="($index mod 16) = 15">black</xsl:when>
      <xsl:when test="($index mod 16) = 0">white</xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="pick_font_color">
    <xsl:param name="index" select="1"/>
    <xsl:choose>
      <xsl:when test="($index mod 16) = 1">black</xsl:when>
      <xsl:when test="($index mod 16) = 2">white</xsl:when>
      <xsl:when test="($index mod 16) = 3">black</xsl:when>
      <xsl:when test="($index mod 16) = 4">black</xsl:when>
      <xsl:when test="($index mod 16) = 5">black</xsl:when>
      <xsl:when test="($index mod 16) = 6">black</xsl:when>
      <xsl:when test="($index mod 16) = 7">white</xsl:when>
      <xsl:when test="($index mod 16) = 8">white</xsl:when>
      <xsl:when test="($index mod 16) = 9">black</xsl:when>
      <xsl:when test="($index mod 16) = 10">black</xsl:when>
      <xsl:when test="($index mod 16) = 11">white</xsl:when>
      <xsl:when test="($index mod 16) = 12">white</xsl:when>
      <xsl:when test="($index mod 16) = 13">white</xsl:when>
      <xsl:when test="($index mod 16) = 14">white</xsl:when>
      <xsl:when test="($index mod 16) = 15">white</xsl:when>
      <xsl:when test="($index mod 16) = 0">black</xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="contributing_site_table">
    <!-- This template print out the table of contributing sites for a motif -->
    <xsl:param name="motif_width"/>
    <xsl:variable name="motif_index" select="position()" />
    <table cellpadding="0.5cm">
      <thead>
      <tr>
        <th align="left" style="padding-right: 1cm">NAME
         <a name="sites{$motif_index}"/>
         </th>
         <xsl:if test="/MEME/model/strands='both'">
          <th align="left" style="padding-right: 1cm">STRAND</th>
        </xsl:if>
        <th align="left" style="padding-right: 1cm">START</th>
        <th align="left" style="padding-right: 2cm">P-VALUE</th>
        <th align="center"><a href="#sites_doc">SITES</a></th>
      </tr>
      </thead>
      <tbody>
        <xsl:for-each select="contributing_sites/contributing_site">
          <xsl:sort select="@pvalue" data-type="number"/>
          <xsl:variable name="sequence_id" select="@sequence_id" />
          <tr>
            <td>
              <xsl:value-of select="/MEME/training_set/sequence[@id=$sequence_id]/@name"/>
            </td>
            <xsl:if test="/MEME/model/strands='both'">
              <td align="center" style="padding-right: 1cm"><xsl:if test="@strand='plus'">+</xsl:if><xsl:if test="@strand='minus'">-</xsl:if></td>
            </xsl:if>
            <td align="right" style="padding-right: 1cm"><xsl:value-of select="@position"/></td>
            <td align="right" style="padding-right: 2cm"><xsl:value-of select="@pvalue"/></td>
            <td align="right" style="padding-right: 2mm"><tt><big><font color="grey"><xsl:value-of select="left_flank"/></font></big></tt></td>
            <td><tt><big><b>
              <xsl:apply-templates select="site"/>
            </b></big></tt></td>
            <td align="left" style="padding-left: 2mm"><tt><big><font color="grey"><xsl:value-of select="right_flank"/></font></big></tt></td>
          </tr>
        </xsl:for-each>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template name="contributing_site_diagram">
    <!-- This template prints the bead-on-string diagrams for a given motif -->
    <xsl:param name="motif_index"/>
    <xsl:param name="motif_width"/>
    <table border="1">
      <thead>
        <tr>
          <th align="left"><br/>Name</th>
          <th align="left">Lowest<br/>p-value</th>
          <th align="center">Motifs</th>
        </tr>
      </thead>
      <tbody>
       <!-- Look at all contributing sites for this motif. -->
        <xsl:for-each select="/MEME/motifs/motif[$motif_index]/contributing_sites/contributing_site">
          <xsl:sort data-type="number" select="@pvalue" order="ascending"/>
          <xsl:variable name="is_site_with_lowest_pvalue_for_seq">
            <xsl:call-template name="is_site_with_lowest_pvalue_for_seq">
              <xsl:with-param name="site" select="." />
              <xsl:with-param name="motif_index" select="$motif_index" />
            </xsl:call-template>
          </xsl:variable>
          <!-- Print only one row per sequence containing a site for this motif -->
          <xsl:if test="$is_site_with_lowest_pvalue_for_seq = 'true'">
          <tr>
            <td><xsl:value-of select="id(@sequence_id)/@name"/></td>
            <!-- This will be the site with the smallest p-value -->
            <td><xsl:value-of select="@pvalue"/></td>
            <td>
              <xsl:call-template name="draw_motif_positions_for_seq">
                <xsl:with-param name="sequence_id" select="@sequence_id" />
                <xsl:with-param name="motif_index" select="$motif_index" />
                <xsl:with-param name="motif_width" select="$motif_width" />
              </xsl:call-template>
            </td>
          </tr>
          </xsl:if>
        </xsl:for-each>
        <tr>
          <th rowspan="2" colspan="2" style="color: blue;">SCALE</th>
          <td>
            <table style="border-collapse: collapse;">
              <tr>
                <xsl:call-template name="ticks">
                  <xsl:with-param name="count" select="1"/>
                  <xsl:with-param name="limit">
                    <xsl:for-each select="id(/MEME/motifs/motif[$motif_index]/contributing_sites/contributing_site/@sequence_id)">
                      <xsl:sort select="@length" data-type="number" order="descending"/>
                      <xsl:if test="position()=1"><xsl:value-of select="@length"/></xsl:if>
                    </xsl:for-each>
                  </xsl:with-param>
                </xsl:call-template>
              </tr>
              <tr>
                <xsl:call-template name="scale">
                  <xsl:with-param name="count" select="1"/>
                  <xsl:with-param name="limit">
                    <xsl:for-each select="id(/MEME/motifs/motif[$motif_index]/contributing_sites/contributing_site/@sequence_id)">
                      <xsl:sort select="@length" data-type="number" order="descending"/>
                      <xsl:if test="position()=1"><xsl:value-of select="@length"/></xsl:if>
                    </xsl:for-each>
                  </xsl:with-param>
                  </xsl:call-template>
                </tr>
              </table>
            </td>
          </tr>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template name="is_site_with_lowest_pvalue_for_seq">
    <!-- 
      This template determines whether a given motif site has the lowest p-value of all such 
      motif sites for a particular sequence. It evaluates to the string 'true' if so, and
      evaluates to the empty string if not.
    -->
    <xsl:param name="site"/>
    <xsl:param name="motif_index"/>
    <xsl:for-each select="/MEME/motifs/motif[$motif_index]/contributing_sites/contributing_site[@sequence_id = $site/@sequence_id]">
      <xsl:sort data-type="number" select="@pvalue" order="ascending"/>
        <xsl:if test="position() = 1 and @position = $site/@position">true</xsl:if>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="draw_motif_positions_for_seq">
    <!-- 
      This template prints the bead-on-string diagram for a given motif and sequence 
    -->
    <xsl:param name="sequence_id"/>
    <xsl:param name="motif_index"/>
    <xsl:param name="motif_width"/>
    <table style="border-collapse: collapse;">
    <tr>
      <xsl:variable name="motif_color">
        <xsl:call-template name="pick_color">
          <xsl:with-param name="motif_index" select="$motif_index"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="font_color">
        <xsl:call-template name="pick_font_color">
          <xsl:with-param name="motif_index" select="$motif_index"/>
        </xsl:call-template>
      </xsl:variable>
      <!-- Loop over all sites for this motif in this sequence -->
      <xsl:for-each select="/MEME/motifs/motif[$motif_index]/contributing_sites/contributing_site[@sequence_id = $sequence_id]">
        <xsl:sort data-type="number" select="@position" order="ascending"/> 
        <!-- Record the position of the current motif site -->
        <xsl:variable name="current_position">
          <xsl:value-of select="@position"/>
        </xsl:variable>
        <!-- Calculate and record the position of the previous motif site -->
        <xsl:variable name="previous_position">
          <xsl:for-each select="/MEME/motifs/motif[$motif_index]/contributing_sites/contributing_site[@sequence_id = $sequence_id and @position &lt; $current_position]">
            <xsl:sort data-type="number" select="@position" order="ascending"/> 
            <xsl:if test="position() = last()"><xsl:value-of select="@position"/></xsl:if>
          </xsl:for-each>
        </xsl:variable>
        <!-- Record the strand for the current motif site -->
        <xsl:variable name="strand">
          <xsl:choose>
            <xsl:when test="@strand='plus'">
              <xsl:text>+</xsl:text>
            </xsl:when>
            <xsl:when test="@strand='minus'">
              <xsl:text>-</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:variable>
        <!-- Is this the first site for this motif in this sequence? -->
        <xsl:choose>
          <xsl:when test="string-length($previous_position)=0">
            <!-- Yes. Draw a line from the sequence start to the position of the motif -->
            <td style="width: {2 * $current_position}px;"><hr size="4" noshade="noshade"/></td>
          </xsl:when>
          <xsl:otherwise>
            <!-- No. Draw a line from the end of the previous motif site to the position of the current motif site -->
            <td style="width: {2 * ($current_position - $previous_position - $motif_width)}px;"><hr size="4" noshade="noshade"/></td>
          </xsl:otherwise>
        </xsl:choose>
        <!-- Draw the motif site -->
        <td style="width: {2 * $motif_width}px; background: {$motif_color}; color: {$font_color}; text-align: center;">
          <xsl:value-of select="$strand"/><xsl:value-of select="$motif_index"/>
        </td>
        <!-- 
          If this is the last site for this motif in this sequence,
          draw a line from the end of the last motif site to the sequence end.
        -->
        <xsl:if test="position()=last()">
          <xsl:variable name="sequence_length">
            <xsl:value-of select="id(@sequence_id)/@length"/>
          </xsl:variable>
          <td style="width: {2 * ($sequence_length - $current_position - $motif_width)}px;"><hr size="4" noshade="noshade"/></td>
        </xsl:if>
      </xsl:for-each>
    </tr>
    </table>
  </xsl:template>

  <xsl:template name="scanned_site_diagram">
    <table border="1">
      <thead>
      <tr>
        <th align="left"><br/>Name</th>
        <th align="left">Combined<br/>p-value</th>
        <th align="left"><br/>Motifs</th>
      </tr>
      </thead>
      <tbody>
        <xsl:for-each select="scanned_sites_summary/scanned_sites">
          <!-- Don't print a row if there are no scanned sites for this sequence -->
          <xsl:if test="count(./scanned_site) &gt; 0">
            <xsl:variable name="sequence_width" select="id(@sequence_id)/@length"/>
            <tr>
              <td><xsl:value-of select="id(@sequence_id)/@name"/></td>
              <td><xsl:value-of select="@pvalue"/></td>
              <td colspan="4">
                <table style="border-collapse: collapse;">
                  <tr>
                    <xsl:for-each select="./scanned_site">
                      <xsl:sort select="position" data-type="number" order="ascending"/>
                      <xsl:variable name="motif_index" select="id(@motif_id)/@name"/>
                      <xsl:variable name="motif_width" select="id(@motif_id)/@width"/>
                      <xsl:variable name="motif_color">
                        <xsl:call-template name="pick_color">
                          <xsl:with-param name="index" select="$motif_index"/>
                        </xsl:call-template>
                      </xsl:variable>
                      <xsl:variable name="font_color">
                        <xsl:call-template name="pick_font_color">
                          <xsl:with-param name="index" select="$motif_index"/>
                        </xsl:call-template>
                      </xsl:variable>
                      <xsl:variable name="strand">
                        <xsl:choose>
                          <xsl:when test="@strand='plus'">
                            <xsl:text>+</xsl:text>
                          </xsl:when>
                          <xsl:when test="@strand='minus'">
                            <xsl:text>-</xsl:text>
                          </xsl:when>
                        </xsl:choose>
                      </xsl:variable>
                      <xsl:variable name="previous_position" select="preceding-sibling::*[1]/@position"/>
                      <xsl:variable name="previous_motif_id" select="preceding-sibling::*[1]/@motif_id"/>
                      <xsl:variable name="previous_motif_width" select="id($previous_motif_id)/@width"/>
                      <xsl:choose>
                        <xsl:when test="string-length($previous_position)=0">
                          <td style="width: {2 * @position}px;"><hr size="4" noshade="noshade"/></td>
                        </xsl:when>
                        <xsl:otherwise>
                          <td style="width: {2 * (@position - $previous_position - $previous_motif_width)}px;"><hr size="4" noshade="noshade"/></td>
                        </xsl:otherwise>
                      </xsl:choose>
                      <td style="width: {2 * $motif_width}px; background: {$motif_color}; color: {$font_color}; text-align: center;">
                        <xsl:value-of select="$strand"/><xsl:value-of select="$motif_index"/>
                      </td>
                      <xsl:if test="position()=last()">
                        <td style="width: {2 * ($sequence_width - @position - $motif_width)}px;"><hr size="4" noshade="noshade"/></td>
                      </xsl:if>
                    </xsl:for-each>
                  </tr>
                </table>
              </td>
            </tr>
          </xsl:if>
        </xsl:for-each>
        <tr>
          <th rowspan="2" colspan="2" style="color: blue;">SCALE</th>
          <td>
            <table>
              <tr>
                <xsl:call-template name="ticks">
                  <xsl:with-param name="count" select="1"/>
                  <xsl:with-param name="limit">
                    <xsl:for-each select="/MEME/training_set/sequence/@length">
                      <xsl:sort data-type="number" order="descending"/>
                      <xsl:if test="position()=1"><xsl:value-of select="."/></xsl:if>
                    </xsl:for-each>
                  </xsl:with-param>
                </xsl:call-template>
              </tr>
              <tr>
                <xsl:call-template name="scale">
                  <xsl:with-param name="count" select="1"/>
                  <xsl:with-param name="limit">
                    <xsl:for-each select="/MEME/training_set/sequence/@length">
                      <xsl:sort data-type="number" order="descending"/>
                      <xsl:if test="position()=1"><xsl:value-of select="."/></xsl:if>
                    </xsl:for-each>
                  </xsl:with-param>
                  </xsl:call-template>
                </tr>
              </table>
            </td>
          </tr>
      </tbody>
    </table>
  </xsl:template>

<xsl:template name="machine_readable_scanned_site_summary">
<xsl:variable name="scanned_sites_summary">
<xsl:text>
</xsl:text>
<xsl:for-each select="scanned_sites_summary/scanned_sites">
<xsl:sort select="position" data-type="number" order="ascending"/>
<xsl:value-of select="id(@sequence_id)/@name"/><xsl:text> </xsl:text>
<xsl:value-of select="@pvalue"/><xsl:text> </xsl:text>
<xsl:value-of select="@num_sites"/><xsl:text> </xsl:text>
<xsl:value-of select="id(@sequence_id)/@length"/><xsl:text> </xsl:text>
<xsl:for-each select="./scanned_site">
<xsl:choose>
<xsl:when test="@strand='plus'">
<xsl:text>+</xsl:text><xsl:value-of select="id(@motif_id)/@name"/><xsl:text> </xsl:text>
</xsl:when>
<xsl:when test="@strand='minus'">
<xsl:text>-</xsl:text><xsl:value-of select="id(@motif_id)/@name"/><xsl:text> </xsl:text>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="id(@motif_id)/@name"/><xsl:text> </xsl:text>
</xsl:otherwise>
</xsl:choose>
<xsl:value-of select="@position"/><xsl:text> </xsl:text>
<xsl:value-of select="@pvalue"/><xsl:text> </xsl:text>
</xsl:for-each>
<xsl:text>
</xsl:text>
</xsl:for-each>
</xsl:variable>
<input type="hidden" name="motif-summary" value="
{$scanned_sites_summary}
"/>
</xsl:template>

<xsl:template name="pspm">
  <xsl:param name="motif_index"/>
  <xsl:text>&#10;</xsl:text>
  <hr/><center><a name="pspm{$motif_index}"/>
    <xsl:text>&#10;</xsl:text>
    <big><b><a href="#pspm_doc">Motif <xsl:value-of select="$motif_index"/> position-specific probability matrix</a> 
    <xsl:text>&#10;</xsl:text>
    </b></big></center><hr/>
    <xsl:variable name="pspm">
letter-probability matrix: alength= <xsl:value-of
select="/MEME/training_set/alphabet/@length"/> w= <xsl:value-of select="@width"/> nsites= <xsl:value-of select="@sites"/> E= <xsl:value-of select="@e_value"/> <xsl:text>&#10;</xsl:text>
      <xsl:for-each select="/MEME/motifs/motif[$motif_index]/probabilities/alphabet_matrix/alphabet_array">
        <xsl:for-each select="value">
          <xsl:value-of select="."/><xsl:text> </xsl:text>
        </xsl:for-each>
      <xsl:text>&#10;</xsl:text>
      </xsl:for-each>
    </xsl:variable>
    <xsl:text>&#10;</xsl:text>
    <input type="hidden" name="pspm{$motif_index}" value="{$pspm} "/>
    <xsl:text>&#10;</xsl:text>
</xsl:template>

<xsl:template name="pssm">
  <xsl:param name="motif_index"/>
  <xsl:text>&#10;</xsl:text>
  <hr/><center><a name="pssm{$motif_index}"/>
  <big><b><a href="#pssm_doc">Motif <xsl:value-of select="$motif_index"/> position-specific scoring matrix</a> 
  </b></big></center><hr/>
    <xsl:variable name="pssm">
log-odds matrix: alength= <xsl:value-of select="/MEME/training_set/alphabet/@length"/> w= <xsl:value-of select="@width"/> n= <xsl:value-of select="@sites"/> bayes= <xsl:value-of select="@bayes_threshold"/> E= <xsl:value-of select="@e_value"/>
      <xsl:text>&#10;</xsl:text>
      <xsl:for-each select="/MEME/motifs/motif[$motif_index]/scores/alphabet_matrix/alphabet_array">
        <xsl:for-each select="value">
          <xsl:value-of select="."/><xsl:text> </xsl:text>
        </xsl:for-each>
        <xsl:text>&#10;</xsl:text>
      </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="motifblock">
BL   MOTIF <xsl:value-of select="@name"/> width=<xsl:value-of select="@width"/> seqs=<xsl:value-of select="@sites"/> 
    </xsl:variable>
    <xsl:text>&#10;</xsl:text>
<!-- motif Block entry -->    
    <input type="hidden" name="motifblock{$motif_index}" value="
{$motifblock}
"/>
<!-- don't change the next 3 lines or make_logodds breaks -->
    <input type="hidden" name="pssm{$motif_index}" value="
{$pssm}
"/>
    <xsl:text>&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>
