#!/bin/csh

# This file is processed by "make" to create the file
# executed by the MEME web service.

set dir = `pwd`
set jobid  = `basename $dir`

# get log file
set logfile = /opt/chipster/tools/meme_4.2.0/LOGS/meme-log

# get the background
set bkg = /opt/chipster/tools/meme_4.2.0/etc/bkg.jpg
if -e $bkg cp $bkg .

#
# Create an empty index file
#
cat > index.html << HERE
<html>
<head>
<title>MEME Output</title>
</head>
<body background="bkg.jpg">

<hr>
<h2>MEME Job $jobid</h2>
HERE

# Get start time for log
set t1 = `date -u '+%d/%m/%y %H:%M:%S'`

# Run MEME
echo "<ul><li>/opt/chipster/tools/meme_4.2.0/bin/meme $* </li></ul><hr>" >> index.html
/opt/chipster/tools/meme_4.2.0/bin/meme $* -oc . -nostatus
set exe_status = $status

# Run MAST on output of MEME and the input sequences
set bfile = ""
if (-s uploaded_bfile) set bfile = " -bfile uploaded_bfile"
if ($exe_status == 0) /opt/chipster/tools/meme_4.2.0/bin/mast ./meme.html $1 $bfile -nostatus -stdout > mast.html

# Get finish time for log
set t2 = `date -u '+%d/%m/%y %H:%M:%S'`

# Log the job
touch $logfile
set host = `hostname`
set submit = `cat submit_time_file`
set email = `cat address_file`
echo "$host $jobid submit: $submit start: $t1 end: $t2 $* $email" >> $logfile

cp /opt/chipster/tools/meme_4.2.0/etc/meme.xsl .

#
# finish the index file
#
# Results section
if (-s meme.xml || -s meme.html || -s meme.txt || -s mast.html) then
  echo "<h2>Results</h2><blockquote><ul>" >> index.html
  if (-s meme.html) echo "<li> <a href='meme.html'>MEME output as HTML</a> </li>" >> index.html
  if (-s meme.txt) echo "<li> <a href='meme.txt'>MEME output as plain text</a> </li>" >> index.html
  if (-s meme.xml) echo "<li> <a href='meme.xml'>MEME output as XML</a> </li>" >> index.html
  if (-s meme.xsl) echo "<li> <a href='meme.xsl'>XSLT Stylsheet for converting MEME XML to HTML.</a> </li>" >> index.html
  if (-s mast.html) echo "<li> <a href='mast.html'>MAST output as HTML</a> </li>" >> index.html
  if (-s sequences) echo "<li> <a href='sequences'>input sequences</a> </li>" >> index.html
  if (-s uploaded_bfile) echo "<li> <a href='uploaded_bfile'>background Markov model</a> </li>" >> index.html
  echo "</ul></blockquote><hr>" >> index.html
endif 

# Messages section
if (-s stdout.txt || -s stderr.txt) then
  echo "<h2>Messages</h2><blockquote><ul>" >> index.html
  if (-s stdout.txt) echo "<li><a href='stdout.txt'>Processing Messages</a></li>" >> index.html
  if (-s stderr.txt) echo "<li><a href='stderr.txt'>Error Messages</a></li>" >> index.html
  echo "</ul></blockquote><hr>" >> index.html
endif

# End section
echo "</body></html>" >> index.html
