#!/bin/csh

# This file is processed by "make" to create the file
# executed by the GOMO web service.

set dir = `pwd`
set jobid  = `basename $dir`

# get log file
set logfile = /opt/chipster/tools/meme_4.2.0/LOGS/gomo-log

# get the background
set bkg = /opt/chipster/tools/meme_4.2.0/etc/bkg.jpg
if -e $bkg cp $bkg .

#
# Create an empty index file
#
cat > index.html << HERE
<html>
<head>
<title>GOMO Output</title>
</head>
<body background="bkg.jpg">

<hr>
<h2>GOMO Job $jobid</h2>
HERE

set motifs = $1; shift
set db = $1; shift
set score_function = $1; shift

echo "<h2>Input</h2><blockquote><ul>" >> index.html
echo "<li> <a href='motifs'>Motifs</a> (input file)</li>" >> index.html
echo "<li> database : $db </li></ul></blockquote><hr>" >> index.html

echo "<h2>Command</h2><blockquote>" >> index.html

# append local databases
set db = /opt/chipster/tools/meme_4.2.0/db/gomo_databases/$db

# set up the background file and number of sequences in 
# the db file switches if those local files exist
#
set bfile = $db.bfile

# set up go term to sequence mapping
set gomap = $db.csv

# Get start time for log
set t1 = `date -u '+%d/%m/%y %H:%M:%S'`

# Run AMA
echo "Scoring database sequences with given motifs using AMA <br>" >> index.html
echo "<ul><li>/opt/chipster/tools/meme_4.2.0/bin/ama --nostatus --verbosity 0 --scoring $score_function $motifs $db $bfile > ama.cisml</li></ul>" >> index.html
/opt/chipster/tools/meme_4.2.0/bin/ama --nostatus --verbosity 0 --scoring $score_function $motifs $db $bfile > ama.cisml
set exe_status = $status

if ($exe_status == 0)  gzip -c9 ama.cisml > ama.cisml.gz

echo "Associating GO-terms using GOMO <br>" >> index.html
echo "<ul><li>/opt/chipster/tools/meme_4.2.0/bin/gomo $* --nostatus --oc ./ ama.cisml $gomap</li></ul></blockquote><hr>" >> index.html
# Run GOMO on output of AMA and the go terms for the corresponding organism
if ($exe_status == 0) /opt/chipster/tools/meme_4.2.0/bin/gomo $* --verbosity 0 --nostatus --oc ./ ama.cisml $gomap

if ($exe_status == 0) rm ama.cisml

# Get finish time for log
set t2 = `date -u '+%d/%m/%y %H:%M:%S'`

# Log the job
touch $logfile
set host = `hostname`
set submit = `cat submit_time_file`
set email = `cat address_file`
echo "$host $jobid submit: $submit start: $t1 end: $t2 $* $email" >> $logfile

cp /opt/chipster/tools/meme_4.2.0/etc/gomo.xsl .
#
# finish the index file
#
# Results section
if (-s gomo.xml || -s gomo.html || -s gomo_species0.txt || -s ama.cisml) then
  echo "<h2>Results</h2><blockquote><ul>" >> index.html
  if (-s gomo.html) echo "<li> <a href='gomo.html'>GOMO output as HTML</a> </li>" >> index.html
  if (-s gomo_species0.txt) echo "<li> <a href='gomo_species0.txt'>GOMO output as plain text</a> </li>" >> index.html
  if (-s gomo.xml) echo "<li> <a href='gomo.xml'>GOMO output as XML</a> </li>" >> index.html
  if (-s gomo.xsl) echo "<li> <a href='gomo.xsl'>XSLT Stylsheet for converting GOMO XML to HTML.</a> </li>" >> index.html
  if (-s ama.cisml.gz) echo "<li> <a href='ama.cisml.gz'>AMA output as XML (gzip compressed)</a> </li>" >> index.html
  if (-s sequences) echo "<li> <a href='sequences'>input sequences</a> </li>" >> index.html
  echo "</ul></blockquote><hr>" >> index.html
endif 

# Messages section
if (-s stdout.txt || -s stderr.txt) then
  echo "<h2>Messages</h2><blockquote><ul>" >> index.html
#  if (-s stdout.txt) echo "<li><a href='stdout.txt'>Processing Messages</a></li>" >> index.html
  if (-s stderr.txt) echo "<li><a href='stderr.txt'>Processing Messages</a></li>" >> index.html
  echo "</ul></blockquote><hr>" >> index.html
endif

# End section
echo "</body></html>" >> index.html
