#!/usr/bin/perl
##
## .pm made from .pm.in by make
##

################################################################################
#
# read_background_file()
#
# Read a background file in fasta-get-markov format.
# If $bg_file is not defined, sets background to uniform.
#
################################################################################
sub read_background_file {
  my ($alphabet, $bg_file) = @_;

  # get the letters in the alphabet 
  my @letters = split(//, $alphabet); 
  my $alph_length = scalar @letters;
  my (%bg, $a, $f);

  # initialize the background to uniform if no file given
  if (! defined $bg_file) {
    foreach $a (@letters) {
      $bg{$a} = 1.0/$alph_length;
    }
    return(%bg);
  }
  
  # read the background file
  open(BG_FILE, $bg_file) || die("Can't open $bg_file.\n");
  my $total_bg = 0;
  while (<BG_FILE>) {
    next if (/^#/);      		# skip comments
    ($a, $f) = split;
    next unless (length($a) == 1);	# skip higher order model
    $a =~ y/a-z/A-Z/;
    $bg{$a} = $f;
    $total_bg += $f;
  }
  close BG_FILE;

  # make sure they sum to 1 by normalizing
  foreach my $key (@letters) {
    die ("The letter '$key' was not given a value in the background file: $bg_file\n")
      unless (defined $bg{$key});
    $bg{$key} /= $total_bg;
  }

  return(%bg);
}  # background file

1;
