/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.emboss.jemboss.gui.form.TextFieldSink;

public class TextFieldFloat
extends TextFieldSink {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat decimalFormatter = NumberFormat.getNumberInstance(Locale.UK);

    public double getValue() {
        double retVal = 0.0;
        try {
            retVal = this.decimalFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            this.toolkit.beep();
        }
        return retVal;
    }

    public void setValue(double value) {
        this.setText(this.decimalFormatter.format(value));
    }

    protected Document createDefaultModel() {
        return new DecimalNumberDocument();
    }

    protected class DecimalNumberDocument
    extends PlainDocument {
        protected DecimalNumberDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i]) || source[i] == '.' || source[i] == '-') {
                    result[j++] = source[i];
                    continue;
                }
                if (source[i] == ',') continue;
                TextFieldFloat.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

