/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 3.2 $";
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/tektohdf.c,v 3.2 1991/10/22 17:56:10 dilg beta $

$Log: tektohdf.c,v $
 * Revision 3.2  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.1  1990/07/02  10:11:04  clow
 * some cosmetic modifications
 *
*/

/* This code will take Tek images from stdin and create a  HDF file.    */
/* Written by Mike Krogh, NCSA, Nov 4, 1988                             */
/* Last modified by Mike Krogh, NCSA, Mar 22, 1989                      */
/*      bug fix for the crays, change 'char c,c2' to 'int c,c2' and     */
/*      modified 'add' accordingly.                                     */

#include <stdio.h>
#include "df.h"

#define MAXBUF 4096
#define TAG 603

DF *DFP;
int CURCHR;
char BUFFER[MAXBUF];

#if defined __STDC__ || defined PC
int main(int, char **);
int add(int);
int tflush(void);
#else
int main();
int add();
int tflush();
#endif /* __STDC__ || PC */

#if defined __STDC__ || defined PC
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif /* __STDC__ || PC */
{

  int refno;
  int c,c2;

  if (argc < 2) {
     printf("%s,  version: 1.0   date: December 1, 1988\n",argv[0]);
     printf("Tektronix to HDF\n");
     printf("This utility will take Tek images from stdin and create ");
     printf("a HDF file.\n");
     printf("\n");
     printf("Usage: %s <hdffile>\n",argv[0]);
     printf("\n");
     exit(1);
  }

  DFP = DFopen(argv[1], DFACC_CREATE,128);
  if (!DFP) {
     fprintf(stderr,"Error opening %s (%d)\n",argv[1],DFerror);
     exit(1);
  }

  refno = 1;
  CURCHR = 0;

  if ((DFaccess(DFP, TAG, refno, "w")) == -1) {
     fprintf(stderr,"can't start HDF file, ref no. %d\n",refno);
     exit(1);
  }

  while ((c = getchar()) != EOF) {
    if (c == '\033') {
       if ((c2 = getchar()) == '\014') {
          tflush();
          refno += 1;
          if ((DFaccess(DFP, TAG, refno, "w")) == -1) {
             fprintf(stderr,"can't start HDF file, ref no. %d\n",refno);
             exit(1);
          }
        } else {
          add(c);
          if (c2 != EOF) 
             add(c2);
        }
     }
     else add(c);
  }

  tflush();
  if ((DFclose(DFP)) == -1)
     fprintf(stderr,"can't close the HDF file\n");
 
} 


#if defined __STDC__ || defined PC
add(int c)
#else
add(c)
int c;
#endif /* __STDC__ || PC */
{
  if (CURCHR >= MAXBUF) 
     tflush();
  BUFFER[CURCHR] = (char)c;
  CURCHR++;
}


#if defined __STDC__ || defined PC
tflush(void)
#else
tflush()
#endif /* __STDC__ || PC */
{
  if ((DFwrite(DFP,BUFFER,CURCHR)) != CURCHR) {
      fprintf(stderr,"error writing to HDF file\n");
      exit(1);
  }
  CURCHR = 0;
}
