/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#) $Revision: 3.2 $"
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/paltohdf.c,v 3.2 1991/10/22 17:56:10 dilg beta $

$Log: paltohdf.c,v $
 * Revision 3.2  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.1  1990/07/02  10:58:31  clow
 * some cosmetic modifications
 *
*/
/*
*  paltohdf.c
*       Version: 1.0   date: August 1, 1989
*       This utility converts a raw palette to hdf format 
*       The incoming palette is assumed to have 768 bytes:
*          256 red values, 256 greens, and 256 blues.
*          The palette in the HDF file will have the RGB values
*          interlaced: RGB RGB ... (This is standard HDF format.)
*
*  by Mike Folk
*  first version of paltohdf:   8/01/89
*
*  This program is in the public domain
*/

#include <stdio.h>
#include "df.h"
#include "dfp.h"

unsigned char palspace[1024],
			reds[256],
			greens[256],
			blues[256];


#if defined __STDC__ || defined PC
int main(int, char **);
int palconv(char *, char *);
#else
int main();
int palconv();
#endif /* __STDC__ || PC */

#if defined __STDC__ || defined PC
main(int argc, char *argv[]) 
#else
main(argc,argv) 
int argc;
char *argv[];
#endif /* __STDC__ || PC */
{
	if (argc < 3) { 
		puts("Usage:");
		printf("   %s rawpalfile hdffile \n\n", argv[0]);
        printf("%s,  version: 1.0   date: August 1, 1989\n\n",argv[0]);
    	printf("   This utility converts a raw palette to hdf format \n\n");
    	printf("   The incoming palette is assumed to have 768 bytes:\n");
    	printf("   256 red values, 256 greens, and 256 blues.\n\n");
    	printf("   The palette in the HDF file will have the RGB values\n");
    	printf("   interlaced: RGB RGB ... (This is standard HDF format.\n\n");
		exit(1);
	}

	palconv( argv[1], argv[2]);
}

/*
 *	palconv(palfile, outfile) sets the palette
 */

#if defined __STDC__ || defined PC
palconv(char *palfile, char *outfile)
#else
palconv( palfile,outfile)
char *palfile, *outfile;
#endif /* __STDC__ || PC */
{
	unsigned char *p;
	FILE *fp;
	int j,ret;

	fp = fopen(palfile,"r");
	if (fp==NULL) {
		printf(" Error opening palette file %s\n", palfile);
		exit(1);
	}
	fread(reds,1,256,fp);
	fread(greens,1,256,fp);
	fread(blues,1,256,fp);
	fclose(fp);

	p = palspace;
	for (j=0; j<256; j++) {
		*p++ = reds[j];
		*p++ = greens[j];
		*p++ = blues[j];
	}

	ret = DFPaddpal(outfile, palspace);
	if (ret < 0) {
		printf(" Error: %d, in writing palette %s\n",ret, palfile);
		exit(1);
	}
	return(0);
}

