/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfsd.h,v 3.2 1991/10/22 17:56:10 dilg beta $

$Log: dfsd.h,v $
 * Revision 3.2  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.1  1990/07/02  10:11:52  clow
 * some cosmetic modifications
 *
*/
/*-----------------------------------------------------------------------------
 * File:    dfsd.h
 * Purpose: header file for the Scientific Data set
 * Invokes: dfrig.h
 * Contents: 
 *  Structure definitions: DFSsdg
 *  Constant definitions: DFS_MAXLEN
 * Remarks: This is included with user programs which use SDG
 *          Currently defined to be 2-D.  Will later be increased to
 *          multiple dimensions
 *---------------------------------------------------------------------------*/


#ifndef DFSDG                       /* avoid re-inclusion */
#define DFSDG

#include "df.h"

#define DFS_MAXLEN 255		/*  Max length of label/unit/format strings */

/* structure to hold SDG info */
typedef struct DFSsdg {
    DFdi    data;		/* tag/ref of data in file */
    int16   rank;		/* number of dimensions */
    int32   *dimsizes;		/* dimensions of data */
    char    *coordsys;
    char    *dataluf[3];	/* label/unit/format of data */
    char    **dimluf[3];	/* label/unit/format for each dim */
    float32 **dimscales;	/* scales for each dimension */
    float32 max_data, min_data;	/* max, min values of data */
} DFSsdg;

#if 0 /* testing... */
#ifndef PC
#ifndef VMS
DF* DFSDIopen();
#else /*VMS*/
DF* _DFSDIopen();
#endif
#endif /* !PC */
#endif /* testing... */

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfsd.c */

extern int DFSDgetdims(char huge *filename, int huge *prank, int32 huge *sizes,
                       int maxrank);
extern int DFSDgetdatastrs(char huge *label, char huge *unit, char huge *format,
                           char huge *coordsys);
extern int DFSDgetdimstrs(int dim, char huge *label, char huge *unit,
                          char huge *format);
extern int DFSDgetdatalen(int huge *llabel, int huge *lunit, int huge *lformat,
                          int huge *lcoordsys);
extern int DFSDgetdimlen(int dim, int huge *llabel, int huge *lunit,
                         int huge *lformat);
extern int DFSDgetdimscale(int dim, int32 maxsize, float32 huge *scale);
extern int DFSDgetmaxmin(float32 huge *pmax, float32 huge *pmin);
extern int DFSDgetdata(char huge *filename, int rank, int32 huge *maxsizes,
                       float32 huge *data);
extern int DFSDsetlengths(int maxlen_label, int maxlen_unit, int maxlen_format,
                          int maxlen_coordsys);
extern int DFSDsetdims(int rank, int32 huge *dimsizes);
extern int DFSDsetdatastrs(char huge *label, char huge *unit, char huge *format,
                           char huge *coordsys);
extern int DFSDsetdimstrs(int dim, char huge *label, char huge *unit,
                          char huge *format);
extern int DFSDsetdimscale(int dim, int32 dimsize, float32 huge *scale);
extern int DFSDsetmaxmin(float32 maxi, float32 mini);
extern int DFSDputdata(char huge *filename, int16 rank, int32 huge *dimsizes,
                       float32 huge *data);
extern int DFSDadddata(char huge *filename, int16 rank, int32 huge *dimsizes,
                       float32 huge *data);
extern int DFSDrestart(void);
extern int DFSDnumber(char huge *filename);
extern int DFSDclear(void);
extern int DFSDlastref(void);
extern int DFSDreadref(char huge *filename, uint16 ref);
extern int DFSDgetslice(char huge *filename, int32 huge *winst,
                        int32 huge *windims, float32 huge *data,
                        int32 huge *dims);
extern int DFSDstartslice(char huge *filename);
extern int DFSDputslice(int32 huge *winend, float32 huge *data,
                        int32 huge *dims);
extern int DFSDendslice(void);
extern int DFSDsettype(int datatype, int machinetype, int numbertype,
                       int arrayorder);
extern int DFSDgetsdg(DF huge *dfile, uint16 ref, DFSsdg huge *sdg);
extern int DFSDputsdg(DF huge *dfile, uint16 ref, DFSsdg huge *sdg);
extern DF huge *DFSDIopen(char huge *filename, int access);
extern int DFSDIsdginfo(DF huge *dfile);
extern int DFSDIclear(DFSsdg huge *sdg);
extern int DFSDIgetdata(char huge *filename, int rank, int32 huge *maxsizes,
                        float32 huge *data, int isfortran);
extern int DFSDIputdata(char huge *filename, int16 rank, int32 huge *dimsizes,
                        float32 huge *data, int accmode, int isfortran);
extern int DFSDIgetslice(char huge *filename, int32 huge *winst,
                         int32 huge *windims, float32 huge *data,
                         int32 huge *dims, int isfortran);
extern int DFSDIputslice(int32 huge *windims, float32 huge *data,
                         int32 huge *dims, int isfortran);
extern int DFSDIendslice(int isfortran);


/* prototypes for dfsdF.c */

extern int dsisdas_(char huge *flabel, char huge *funit, char huge *fformat,
                    char huge *fcoordsys, int huge *isfortran, int huge *llabel,
                    int huge *lunit, int huge *lformat, int huge *lcoordsys);
extern int dsisdis_(int huge *dim, char huge *flabel, char huge *funit,
                    char huge *fformat, int huge *isfortran, int huge *llabel,
                    int huge *lunit, int huge *lformat);
extern int dsgdast_(char huge *label, char huge * huge *unit,
                    char huge * huge *format, char huge * huge *coordsys);
extern int dsgdist_(int huge *dim, char huge *label, char huge * huge *unit,
                    char huge * huge *format);
extern int dsgdisc_(int huge *dim, int huge *maxsize, float32 huge *scale);
extern int dsgmaxm_(float32 huge *pmax, float32 huge *pmin);
extern int dssdims_(int huge *rank, int huge *dimsizes);
extern int dssdisc_(int huge *dim, int huge *dimsize, float32 huge *scale);
extern int dssmaxm_(float32 huge *max, float32 huge *min);
extern int dsclear_(void);
extern int dsslens_(int huge *maxlen_label, int huge *maxlen_unit,
                    int huge *maxlen_format, int huge *maxlen_coordsys);
extern int dsgdiln_(int huge *dim, int huge *llabel, int huge *lunit,
                    int huge *lformat);
extern int dsgdaln_(int huge *llabel, int huge *lunit, int huge *lformat,
                    int huge *lcoordsys);
extern int dsfirst_(void);
extern int dspslc_(int32 huge *windims, float32 huge *data, int32 huge *dims);
extern int dseslc_(void);
extern int dsstype_(int huge *datatype, int huge *mctype, int huge *numtype,
                    int huge *arrayorder);
extern int dsigdim_(char huge *filename, int huge *prank, int huge *sizes,
                    int huge *maxrank, int huge *lenfn);
extern int dsigdat_(char huge *filename, int huge *rank, int huge *maxsizes,
                    float32 huge *data, int huge *fnlen);
extern int dsipdat_(char huge *filename, int huge *rank, int huge *dimsizes,
                    float32 huge *data, int huge *fnlen);
extern int dsiadat_(char huge *filename, int huge *rank, int huge *dimsizes,
                    float32 huge *data, int huge *fnlen);
extern int dsigslc_(char huge *filename, int32 huge *winst, int32 huge *windims,
                    float32 huge *data, int32 huge *dims, int huge *fnlen);
extern int dsisslc_(char huge *filename, int huge *fnlen);
extern int dsirref_(char huge *filename, int huge *ref, int huge *fnlen);
extern int dslref_(void);
extern int dfsdgetdatastrs_(char huge *label, char huge *unit,
                            char huge *format, char huge *coordsys);
extern int dfsdgetdimstrs_(int huge *dim, char huge *label, char huge *unit,
                           char huge *format);
extern int dfsdgetdimscale_(int huge *dim, int huge *maxsize,
                            float32 huge *scale);
extern int dfsdgetmaxmin_(float32 huge *pmax, float32 huge *pmin);
extern int dfsdsetdims_(int huge *rank, int huge *dimsizes);
extern int dfsdsetdimscale_(int huge *dim, int huge *dimsize,
                            float32 huge *scale);
extern int dfsdsetmaxmin_(float32 huge *max, float32 huge *min);
extern int dfsdclear_(void);
extern int dfsdsetlengths_(int huge *maxlen_label, int huge *maxlen_unit,
                           int huge *maxlen_format, int huge *maxlen_coordsys);
extern int dfsdgetdimlen_(int huge *dim, int huge *llabel, int huge *lunit,
                          int huge *lformat);
extern int dfsdgetdatalen_(int huge *llabel, int huge *lunit, int huge *lformat,
                           int huge *lcoordsys);
extern int dfsdrestart_(void);
extern int dfsdputslice_(int32 huge *windims, float32 huge *data,
                         int32 huge *dims);
extern int dfsdendslice_(void);
extern int dfsdsettype_(int huge *datatype, int huge *mctype, int huge *numtype,
                        int huge *arrayorder);
extern int dfsdlastref_(void);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfsd.c */

extern int DFSDgetdims(char *filename, int *prank, int32 sizes[], int maxrank);
extern int DFSDgetdatastrs(char *label, char *unit, char *format,
                           char *coordsys);
extern int DFSDgetdimstrs(int dim, char *label, char *unit, char *format);
extern int DFSDgetdatalen(int *llabel, int *lunit, int *lformat,
                          int *lcoordsys);
extern int DFSDgetdimlen(int dim, int *llabel, int *lunit, int *lformat);
extern int DFSDgetdimscale(int dim, int32 maxsize, float32 scale[]);
extern int DFSDgetmaxmin(float32 *pmax, float32 *pmin);
extern int DFSDgetdata(char *filename, int rank, int32 maxsizes[],
                       float32 data[]);
extern int DFSDsetlengths(int maxlen_label, int maxlen_unit, int maxlen_format,
                          int maxlen_coordsys);
extern int DFSDsetdims(int16 rank, int32 dimsizes[]);
extern int DFSDsetdatastrs(char *label, char *unit, char *format,
                           char *coordsys);
extern int DFSDsetdimstrs(int dim, char *label, char *unit, char *format);
extern int DFSDsetdimscale(int dim, int32 dimsize, float32 scale[]);
extern int DFSDsetmaxmin(float32 maxi, float32 mini);
extern int DFSDputdata(char *filename, int16 rank, int32 dimsizes[],
                       float32 *data);
extern int DFSDadddata(char *filename, int16 rank, int32 dimsizes[],
                       float32 *data);
extern int DFSDrestart(void);
extern int DFSDnumber(char *filename);
extern int DFSDclear(void);
extern int DFSDlastref(void);
extern int DFSDreadref(char *filename, uint16 ref);
extern int DFSDgetslice(char *filename, int32 winst[], int32 windims[],
                        float32 data[], int32 dims[]);
extern int DFSDstartslice(char *filename);
extern int DFSDputslice(int32 winend[], float32 data[], int32 dims[]);
extern int DFSDendslice(void);
extern int DFSDsettype(int datatype, int machinetype, int numbertype,
                       int arrayorder);
extern int DFSDgetsdg(DF *dfile, uint16 ref, DFSsdg *sdg);
extern int DFSDputsdg(DF *dfile, uint16 ref, DFSsdg *sdg);
extern DF *DFSDIopen(char *filename, int access);
extern int DFSDIsdginfo(DF *dfile);
extern int DFSDIclear(DFSsdg *sdg);
extern int DFSDIgetdata(char *filename, int rank, int32 maxsizes[],
                        float32 data[], int isfortran);
extern int DFSDIputdata(char *filename, int16 rank, int32 *dimsizes,
                        float32 *data, int accmode, int isfortran);
extern int DFSDIgetslice(char *filename, int32 winst[], int32 windims[],
                         float32 data[], int32 dims[], int isfortran);
extern int DFSDIputslice(int32 windims[], float32 data[], int32 dims[],
                         int isfortran);
extern int DFSDIendslice(int isfortran);


/* prototypes for dfsdF.c */

extern int dsisdas_(char *flabel, char *funit, char *fformat, char *fcoordsys,
                    int *isfortran, int *llabel, int *lunit, int *lformat,
                    int *lcoordsys);
extern int dsisdis_(int *dim, char *flabel, char *funit, char *fformat,
                    int *isfortran, int *llabel, int *lunit, int *lformat);
extern int dsgdast_(char *label, char **unit, char **format, char **coordsys);
extern int dsgdist_(int *dim, char *label, char **unit, char **format);
extern int dsgdisc_(int *dim, int *maxsize, float32 scale[]);
extern int dsgmaxm_(float32 *pmax, float32 *pmin);
extern int dssdims_(int *rank, int dimsizes[]);
extern int dssdisc_(int *dim, int *dimsize, float32 scale[]);
extern int dssmaxm_(float32 *max, float32 *min);
extern int dsclear_(void);
extern int dsslens_(int *maxlen_label, int *maxlen_unit, int *maxlen_format,
                    int *maxlen_coordsys);
extern int dsgdiln_(int *dim, int *llabel, int *lunit, int *lformat);
extern int dsgdaln_(int *llabel, int *lunit, int *lformat, int *lcoordsys);
extern int dsfirst_(void);
extern int dspslc_(int32 windims[], float32 data[], int32 dims[]);
extern int dseslc_(void);
extern int dsstype_(int *datatype, int *mctype, int *numtype, int *arrayorder);
extern int dsigdim_(char *filename, int *prank, int sizes[], int *maxrank,
                    int *lenfn);
extern int dsigdat_(char *filename, int *rank, int maxsizes[], float32 data[],
                    int *fnlen);
extern int dsipdat_(char *filename, int *rank, int dimsizes[], float32 *data,
                    int *fnlen);
extern int dsiadat_(char *filename, int *rank, int dimsizes[], float32 *data,
                    int *fnlen);
extern int dsigslc_(char *filename, int32 winst[], int32 windims[],
                    float32 data[], int32 dims[], int *fnlen);
extern int dsisslc_(char *filename, int *fnlen);
extern int dsirref_(char *filename, int *ref, int *fnlen);
extern int dslref_(void);
extern int dfsdgetdatastrs_(char *label, char *unit, char *format,
                            char *coordsys);
extern int dfsdgetdimstrs_(int *dim, char *label, char *unit, char *format);
extern int dfsdgetdimscale_(int *dim, int *maxsize, float32 scale[]);
extern int dfsdgetmaxmin_(float32 *pmax, float32 *pmin);
extern int dfsdsetdims_(int *rank, int dimsizes[]);
extern int dfsdsetdimscale_(int *dim, int *dimsize, float32 scale[]);
extern int dfsdsetmaxmin_(float32 *max, float32 *min);
extern int dfsdclear_(void);
extern int dfsdsetlengths_(int *maxlen_label, int *maxlen_unit,
                           int *maxlen_format, int *maxlen_coordsys);
extern int dfsdgetdimlen_(int *dim, int *llabel, int *lunit, int *lformat);
extern int dfsdgetdatalen_(int *llabel, int *lunit, int *lformat,
                           int *lcoordsys);
extern int dfsdrestart_(void);
extern int dfsdputslice_(int32 windims[], float32 data[], int32 dims[]);
extern int dfsdendslice_(void);
extern int dfsdsettype_(int *datatype, int *mctype, int *numtype,
                        int *arrayorder);
extern int dfsdlastref_(void);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfsd.c */

extern int DFSDgetdims();
extern int DFSDgetdatastrs();
extern int DFSDgetdimstrs();
extern int DFSDgetdatalen();
extern int DFSDgetdimlen();
extern int DFSDgetdimscale();
extern int DFSDgetmaxmin();
extern int DFSDgetdata();
extern int DFSDsetlengths();
extern int DFSDsetdims();
extern int DFSDsetdatastrs();
extern int DFSDsetdimstrs();
extern int DFSDsetdimscale();
extern int DFSDsetmaxmin();
extern int DFSDputdata();
extern int DFSDadddata();
extern int DFSDrestart();
extern int DFSDnumber();
extern int DFSDclear();
extern int DFSDlastref();
extern int DFSDreadref();
extern int DFSDgetslice();
extern int DFSDstartslice();
extern int DFSDputslice();
extern int DFSDendslice();
extern int DFSDsettype();
extern int DFSDgetsdg();
extern int DFSDputsdg();
extern DF *DFSDIopen();
extern int DFSDIsdginfo();
extern int DFSDIclear();
extern int DFSDIgetdata();
extern int DFSDIputdata();
extern int DFSDIgetslice();
extern int DFSDIputslice();
extern int DFSDIendslice();


/* prototypes for dfsdF.c */

extern int dsisdas_();
extern int dsisdis_();
extern int dsgdast_();
extern int dsgdist_();
extern int dsgdisc_();
extern int dsgmaxm_();
extern int dssdims_();
extern int dssdisc_();
extern int dssmaxm_();
extern int dsclear_();
extern int dsslens_();
extern int dsgdiln_();
extern int dsgdaln_();
extern int dsfirst_();
extern int dspslc_();
extern int dseslc_();
extern int dsstype_();
extern int dsigdim_();
extern int dsigdat_();
extern int dsipdat_();
extern int dsiadat_();
extern int dsigslc_();
extern int dsisslc_();
extern int dsirref_();
extern int dslref_();
extern int dfsdgetdatastrs_();
extern int dfsdgetdimstrs_();
extern int dfsdgetdimscale_();
extern int dfsdgetmaxmin_();
extern int dfsdsetdims_();
extern int dfsdsetdimscale_();
extern int dfsdsetmaxmin_();
extern int dfsdclear_();
extern int dfsdsetlengths_();
extern int dfsdgetdimlen_();
extern int dfsdgetdatalen_();
extern int dfsdrestart_();
extern int dfsdputslice_();
extern int dfsdendslice_();
extern int dfsdsettype_();
extern int dfsdlastref_();

#endif /* __STDC__ */

#endif /*DFSDG*/
