/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfgroup.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: dfgroup.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DFGROUP /* avoid re-inclusion */

#define DFGROUP
#include "df.h"

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfgroup.c */

extern int DFdiread(DF huge *dfile, uint16 tag, uint16 ref);
extern int DFdiget(DFdi huge *di);
extern int DFdisetup(int maxsize);
extern int DFdiput(uint16 tag, uint16 ref);
extern int DFdiwrite(DF huge *dfile, uint16 tag, uint16 ref);
extern int DFDIgetgroup(char huge *filename, DFdi huge *diarray, int maxdis,
			DFdi huge *groupdi);
extern int DFDIputgroup(char huge *filename, DFdi huge *diarray, int ndis,
			DFdi huge *groupdi);


#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfgroup.c */

extern int DFdiread(DF *dfile, uint16 tag, uint16 ref);
extern int DFdiget(DFdi *di);
extern int DFdisetup(int maxsize);
extern int DFdiput(uint16 tag, uint16 ref);
extern int DFdiwrite(DF *dfile, uint16 tag, uint16 ref);
extern int DFDIgetgroup(char *filename, DFdi diarray[], int maxdis,
			DFdi *groupdi);
extern int DFDIputgroup(char *filename, DFdi diarray[], int ndis,
			DFdi *groupdi);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfgroup.c */

extern int DFdiread();
extern int DFdiget();
extern int DFdisetup();
extern int DFdiput();
extern int DFdiwrite();
extern int DFDIgetgroup();
extern int DFDIputgroup();

#endif /* __STDC__ */

#endif /* DFGROUP */
