/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 3.8 $";
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/df24.c,v 3.8 1991/10/22 17:56:10 dilg beta $

$Log: df24.c,v $
 * Revision 3.8  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.7  1990/11/01  14:27:43  clow
 * added DF24putimage so we can start from new file if needed
 *
 * Revision 3.6  90/07/06  09:27:14  mfolk
 * No change. (Mike Folk)
 * 
 * Revision 3.5  90/06/19  12:35:03  clow
 * Implemented DF24readref to call DFGRreadref to set next rig to read.
 * 
 * Revision 3.5  90/06/19  11:20:17  clow
 * Implemented DF24readref to call DFGRreadref to set next rig to read.
 * 
 * Revision 3.4  90/06/07  15:55:43  clow
 * fix minor syntax error
 * 
 * Revision 3.3  90/06/07  15:38:07  clow
 * redid DF24setdims with the correct args
 * 
 * Revision 3.2  90/05/11  12:55:43  clow
 * added DF24restart
 * 
 * Revision 3.1  90/04/18  10:47:17  clow
 * Changed interface to be consistent with documentation
 * -- Added DF24setil
 * -- Changed arg list of DFGRIsetdims
 * 
 * Revision 3.0  90/02/02  20:27:02  clow
 * *** empty log message ***
 * 
*/

/*-----------------------------------------------------------------------------
 * File:    df24.c
 * Purpose: read and write 24-bit raster images
 * Invokes: dfgr.c
 * Contents: 
 *  DF24getdims: get dimensions of image
 *  DF24reqil: use this interlace when returning image
 *  DF24getimage: read in image
 *  DF24setdims: set dimensions of image
 *  DF24addimage: write out image
 *
 * Remarks: A RIG specifies attributes associated with an image- lookup table, 
 *          dimension, compression, color compensation etc.
 *---------------------------------------------------------------------------*/


#include "dfgr.h"
#include "df24.h"

static int Newdata = 0;		/* does Readrig contain fresh data? */
static int dimsset = 0;		/* have dimensions been set? */

#define LUT     0
#define IMAGE   1


/*-----------------------------------------------------------------------------
 * Name:    DF24getdims
 * Purpose: get dimensions of next image RIG
 * Inputs:  filename: name of HDF file
 *          pxdim, pydim: pointer to locations for returning x,y dimensions
 *          pil: location for returning interlace of image in file
 * Returns: 0 on success, -1 on failure with DFerror set
 *          *pxdim, *pydim, *pil set on success
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIgetdims
 * Remarks: none
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24getdims(char *filename, int32 *pxdim, int32 *pydim, int *pil)
#else
int DF24getdims(filename, pxdim, pydim, pil)
char *filename;
int32 *pxdim, *pydim;
int *pil;
#endif /* __STDC__ || PC */
{
    int ncomps;

    do {
        if (DFGRIgetdims(filename, pxdim, pydim, &ncomps, pil, IMAGE)<0)
            return(-1);
    } while (ncomps!=3);

    Newdata = 1;
    return(0);
}

/*-----------------------------------------------------------------------------
 * Name:    DF24reqil
 * Purpose: get next image with specified interlace
 * Inputs:  il: interlace to get next image with
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIreqil
 * Remarks: none
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24reqil(int il)
#else
int DF24reqil(il)
int il;
#endif /* __STDC__ || PC */
{
    return(DFGRIreqil(il, IMAGE));
}

/*-----------------------------------------------------------------------------
 * Name:    DF24getimage
 * Purpose: get image from next RIG
 * Inputs:  filename: name of HDF file
 *          image: pointer to space to return image
 *          xdim, ydim: dimensions of space to return lut
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIgetimlut
 * Remarks: space is assumed to be xdim * ydim * 3 bytes
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24getimage(char *filename, uint8 *image, int32 xdim, int32 ydim)
#else
int DF24getimage(filename, image, xdim, ydim)
char *filename;
uint8 *image;
int32 xdim, ydim;
#endif /* __STDC__ || PC */
{
    int ret, il;
    int32 tx, ty;

    if (!Newdata)
        if (DF24getdims(filename, &tx, &ty, &il)<0) return(-1);
    ret = DFGRIgetimlut(filename, image, xdim, ydim, IMAGE, 0);
    Newdata = 0;
    return(ret);
}

/*-----------------------------------------------------------------------------
 * Name:    DF24setdims
 * Purpose: set dimensions of image to write next
 * Inputs:  xdim, ydim: dimensions of image
 *          il: interlace of image
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIsetdims
 * Remarks: none
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24setdims(int32 xdim, int32 ydim)
#else
int DF24setdims(xdim, ydim)
int32 xdim, ydim;
#endif /* __STDC__ || PC */
{
    dimsset = 1;
    return(DFGRIsetdims(xdim, ydim, 3, IMAGE));
}

/*-----------------------------------------------------------------------------
 * Name:    DF24setil
 * Purpose: set interlace of image to write next
 * Inputs:  il: interlace of image
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIsetil
 * Remarks: none
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24setil(int il)
#else
int DF24setil(il)
int il;
#endif /* __STDC__ || PC */
{
    return(DFGRIsetil(il, IMAGE));
}

/*-----------------------------------------------------------------------------
 * Name:    DF24restart
 * Purpose: restart file
 * Inputs:  
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIrestart
 * Remarks: none
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24restart(void)
#else
int DF24restart()
#endif /* __STDC__ || PC */
{
    return DFGRIrestart();
}

/*-----------------------------------------------------------------------------
 * Name:    DF24addimage
 * Purpose: Write out image
 * Inputs:  filename: name of HDF file
 *          image: image to write
 *          xdim, ydim: dimensions of array image
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   HDF HLL (high-level library) users, utilities, other routines
 * Invokes: DFGRIaddimlut
 * Remarks: array image is assumed to be xdim * ydim * 3 bytes
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24addimage(char *filename, uint8 *image, int32 xdim, int32 ydim)
#else
int DF24addimage(filename, image, xdim, ydim)
char *filename;
uint8 *image;
int32 xdim, ydim;
#endif /* __STDC__ || PC */
{
    /* 0 == C */
    if (!dimsset)
        if (DFGRIsetdims(xdim, ydim, 3, IMAGE)<0) return(-1);
    dimsset = 1;

    return(DFGRIaddimlut(filename, image, xdim, ydim, IMAGE, 0, 0));
}

#if defined __STDC__ || defined PC
int DF24putimage(char *filename, uint8 *image, int32 xdim, int32 ydim)
#else
int DF24putimage(filename, image, xdim, ydim)
char *filename;
uint8 *image;
int32 xdim, ydim;
#endif /* __STDC__ || PC */
{
    /* 0 == C */
    if (!dimsset)
        if (DFGRIsetdims(xdim, ydim, 3, IMAGE)<0) return(-1);
    dimsset = 1;

    return(DFGRIaddimlut(filename, image, xdim, ydim, IMAGE, 0, 1));
}


/*-----------------------------------------------------------------------------
 * Name:    DF24readref
 * Purpose: Set ref of 24-rig to get next
 * Inputs:  filename: file to which this applies
 *          ref: reference number of next get
 * Returns: 0 on success, -1 on failure
 * Users:   HDF programmers, other routines and utilities
 * Invokes: DFGRreadref
 * Remarks: checks if 24-rig with this ref exists
 *---------------------------------------------------------------------------*/

#if defined __STDC__ || defined PC
int DF24readref(char *filename, uint16 ref)
#else
int DF24readref(filename, ref)
char *filename;
uint16 ref;
#endif /* __STDC__ || PC */
{
    return (DFGRreadref(filename, ref));
}
