/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfufp2im.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: dfufp2im.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DFUFP2IM /* avoid re-inclusion */

#define DFUFP2IM
#include "df.h"

/*
* definitions of structs used by routines: Input & Output
*/

struct Input {
    int32
        hdim, vdim;     /* horizontal and vertical dimensions of input data */
    int
        is_pal,         /* flag to tell whether there is a palette */
        is_vscale,      /* flags telling whether scales were included  */
        is_hscale,
        ct_method;      /* color transform method: EXPAND or INTERP */
    float32
        max, min,        /* max and min values of the data */
        *hscale,*vscale, /* horizontal and vertical scales */
        *data;           /* floating point data */
};

struct Output {
    int32
        hres,vres;  /* horizontal and vertical resolution of image */
    int compress;   /* compression scheme */
    char
        outfile[32]; /* output file name */
    uint8
        *image;     
    uint8
        *palette;   
};

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfufp2im.c */

extern int duif2i_(int huge *hdim, int huge *vdim, float32 huge *max,
		   float32 huge *min, float32 huge *hscale,
		   float32 huge *vscale, float32 huge *data,
		   uint8 huge *palette, char huge *outfile, int huge *ct_method,
		   int huge *hres, int huge *vres, int huge *compress,
		   int huge *lenfn);
extern int DFUfptoimage(int32 hdim, int32 vdim, float32 max, float32 min,
                        float32 huge *hscale, float32 huge *vscale,
                        float32 huge *data, uint8 huge *palette,
                        char huge *outfile, int ct_method, int32 hres,
                        int32 vres, int compress);
extern int process(struct Input huge *in, struct Output huge *out);
extern int generate_scale(int32 dim, float32 huge *scale);
extern int convert_interp(struct Input huge *in, struct Output huge *out);
extern int pixrep_scaled(struct Input huge *in, struct Output huge *out);
extern int compute_offsets(float32 huge *scale, int32 dim, int32 huge *offsets,
                           int32 res);
extern int pixrep_simple(struct Input huge *in, struct Output huge *out);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfufp2im.c */

extern int duif2i_(int *hdim, int *vdim, float32 *max, float32 *min,
		   float32 hscale[], float32 vscale[], float32 data[],
		   uint8 *palette, _fcd outfile, int *ct_method, int *hres,
		   int *vres, int *compress, int *lenfn);
extern int DFUfptoimage(int32 hdim, int32 vdim, float32 max, float32 min,
                        float32 *hscale, float32 *vscale, float32 *data,
                        uint8 *palette, char *outfile, int ct_method,
                        int32 hres, int32 vres, int compress);
extern int process(struct Input *in, struct Output *out);
extern int generate_scale(int32 dim, float32 *scale);
extern int convert_interp(struct Input *in, struct Output *out);
extern int pixrep_scaled(struct Input *in, struct Output *out);
extern int compute_offsets(float32 *scale, int32 dim, int32 *offsets,
                           int32 res);
extern int pixrep_simple(struct Input *in, struct Output *out);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfufp2im.c */

extern int duif2i_();
extern int DFUfptoimage();
extern int process();
extern int generate_scale();
extern int convert_interp();
extern int pixrep_scaled();
extern int compute_offsets();
extern int pixrep_simple();

#endif /* __STDC__ */

#endif /* DFUFP2IM */
