/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfgr.h,v 3.1 1991/10/22 17:56:10 dilg beta $

$Log: dfgr.h,v $
 * Revision 3.1  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.0  1990/02/02  20:34:28  clow
 * *** empty log message ***
 *
*/

/*-----------------------------------------------------------------------------
 * File:    dfgr.h
 * Purpose: header file for the Raster Image set
 * Invokes: df.h
 * Contents: 
 *  Structure definitions: DFGRdr, DFGRrig
 * Remarks: This is included with user programs which use general raster
 *---------------------------------------------------------------------------*/


#ifndef DFGR                        /* avoid re-inclusion */
#define DFGR

#include "df.h"

/* description record: used to describe image data, palette data etc. */
typedef struct DFGRdr {
    int32 xdim, ydim;               /* dimensions of data */
    DFdi nt;                        /* number type of data */
    int16 ncomponents, interlace;   /* data ordering: chunky / planar etc */
    DFdi compr;                     /* compression */
        /* ### Note: compression is currently uniquely described with a tag.
            No data is attached to this tag/ref.  But this capability is
            provided for future expansion, when this tag/ref might point to
            some data needed for decompression, such as the actual encodings */
} DFGRdr;

/* structure to hold RIG info */
typedef struct DFGRrig {
    DFdi data[3];                   /* image/lut/mattechannel */
    DFGRdr datadesc[3];             /* description of image/lut/mattechannel */
    int32 xpos, ypos;               /* X-Y position of image on screen */
    float32 aspectratio;            /* ratio of pixel height to width */
    float32 ccngamma,               /* color correction parameters */
        ccnred[3], ccngrren[3], ccnblue[3], ccnwhite[3];
    char *cf;                       /* color format */
} DFGRrig;


/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfgr.c */

extern int DFGRgetlutdims(char huge *filename, int32 huge *pxdim,
			  int32 huge *pydim, int huge *pncomps, int huge *pil);
extern int DFGRreqlutil(int il);
extern int DFGRgetlut(char huge *filename, uint8 huge *lut, int32 xdim,
		      int32 ydim);
extern int DFGRgetimdims(char huge *filename, int32 huge *pxdim,
			 int32 huge *pydim, int huge *pncomps, int huge *pil);
extern int DFGRreqimil(int il);
extern int DFGRgetimage(char huge *filename, uint8 huge *image, int32 xdim,
			int32 ydim);
extern int DFGRsetcompress(int scheme);
extern int DFGRsetlutdims(int32 xdim, int32 ydim, int ncomps, int il);
extern int DFGRsetlut(uint8 huge *lut, int32 xdim, int32 ydim);
extern int DFGRaddlut(char huge *filename, uint8 huge *lut, int32 xdim,
		      int32 ydim);
extern int DFGRsetimdims(int32 xdim, int32 ydim, int ncomps, int il);
extern int DFGRaddimage(char huge *filename, uint8 huge *image, int32 xdim,
			int32 ydim);
extern int DFGRputimage(char huge *filename, uint8 huge *image, int32 xdim,
			int32 ydim);
extern int DFGRreadref(char huge *filename, uint16 ref);
extern int DFGRgetrig(DF huge *dfile, uint16 ref, DFGRrig huge *rig);
extern int DFGRaddrig(DF huge *dfile, uint16 ref, DFGRrig huge *rig);
extern DF huge *DFGRIopen(char huge *filename, int access);
extern int DFGRIriginfo(DF huge *dfile);
extern int DFGRIgetdims(char huge *filename, int32 huge *pxdim,
			int32 huge *pydim, int huge *pncomps, int huge *pil,
			int type);
extern int DFGRIreqil(int il, int type);
extern int DFGRIgetimlut(char huge *filename, uint8 huge *imlut, int32 xdim,
			 int32 ydim, int type, int isfortran);
extern int DFGRIsetdims(int32 xdim, int32 ydim, int ncomps, int type);
extern int DFGRIsetil(int il, int type);
extern int DFGRIrestart(void);
extern int DFGRIaddimlut(char huge *filename, uint8 huge *imlut, int32 xdim,
			 int32 ydim, int type, int isfortran, int newfile);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfgr.c */

extern int DFGRgetlutdims(char *filename, int32 *pxdim, int32 *pydim,
			  int *pncomps, int *pil);
extern int DFGRreqlutil(int il);
extern int DFGRgetlut(char *filename, uint8 *lut, int32 xdim, int32 ydim);
extern int DFGRgetimdims(char *filename, int32 *pxdim, int32 *pydim,
			 int *pncomps, int *pil);
extern int DFGRreqimil(int il);
extern int DFGRgetimage(char *filename, uint8 *image, int32 xdim, int32 ydim);
extern int DFGRsetcompress(int scheme);
extern int DFGRsetlutdims(int32 xdim, int32 ydim, int ncomps, int il);
extern int DFGRsetlut(uint8 *lut, int32 xdim, int32 ydim);
extern int DFGRaddlut(char *filename, uint8 *lut, int32 xdim, int32 ydim);
extern int DFGRsetimdims(int32 xdim, int32 ydim, int ncomps, int il);
extern int DFGRaddimage(char *filename, uint8 *image, int32 xdim, int32 ydim);
extern int DFGRputimage(char *filename, uint8 *image, int32 xdim, int32 ydim);
extern int DFGRreadref(char *filename, uint16 ref);
extern int DFGRgetrig(DF *dfile, uint16 ref, DFGRrig *rig);
extern int DFGRaddrig(DF *dfile, uint16 ref, DFGRrig *rig);
extern DF *DFGRIopen(char *filename, int access);
extern int DFGRIriginfo(DF *dfile);
extern int DFGRIgetdims(char *filename, int32 *pxdim, int32 *pydim,
			int *pncomps, int *pil, int type);
extern int DFGRIreqil(int il, int type);
extern int DFGRIgetimlut(char *filename, uint8 *imlut, int32 xdim, int32 ydim,
			 int type, int isfortran);
extern int DFGRIsetdims(int32 xdim, int32 ydim, int ncomps, int type);
extern int DFGRIsetil(int il, int type);
extern int DFGRIrestart(void);
extern int DFGRIaddimlut(char *filename, uint8 *imlut, int32 xdim, int32 ydim,
			 int type, int isfortran, int newfile);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfgr.c */

extern int DFGRgetlutdims();
extern int DFGRreqlutil();
extern int DFGRgetlut();
extern int DFGRgetimdims();
extern int DFGRreqimil();
extern int DFGRgetimage();
extern int DFGRsetcompress();
extern int DFGRsetlutdims();
extern int DFGRsetlut();
extern int DFGRaddlut();
extern int DFGRsetimdims();
extern int DFGRaddimage();
extern int DFGRputimage();
extern int DFGRreadref();
extern int DFGRgetrig();
extern int DFGRaddrig();
extern DF *DFGRIopen();
extern int DFGRIriginfo();
extern int DFGRIgetdims();
extern int DFGRIreqil();
extern int DFGRIgetimlut();
extern int DFGRIsetdims();
extern int DFGRIsetil();
extern int DFGRIrestart();
extern int DFGRIaddimlut();

#endif /* __STDC__ */

#endif /*DFGR*/
