/*
 * This file is part of tela the Tensor Language.
 * Copyright (c) 1994 Pekka Janhunen
 */

#ifdef __GNUC__
#  pragma interface
#endif
// Common definitions for Tela kernel

#ifndef COMMON_H

struct global {
	static int nops;		// Accumulates number of operations involved when executing current instruction
	static int lineno;		// Keeps track of source line number when parsing
	static int NTprg;		// Total number of Tprg objects in the system
	static int NTobject;	// Total number of Tobject's in the system
	static int interrupted;	// Nonzero after Control-C hit by user
	static char *argv0;		// Name of the program (argv[0] from main())
    static ostream* ctfile;	// Points to output C-tela file when compiling (usually null)
#if !HAVE_RUSAGE && HAVE_SYS_PROCFS_H
	static int procfd;				// File descriptor to open /proc/$$ file (used in CPUSeconds())
#endif
};

struct flags {		// Various flags controlled from command line
	static int verbose;
	static int echo;
	static int batch;
	static int silent;
	static int checkRO;		// nonzero if check agains modification of input arguments is done
};

extern void SetHardInterruptHandler();	// from tela.C
extern void SetSoftInterruptHandler();	// from tela.C

/* Wrap very time consuming calls with CATCH_INTERRUPTS, for example
   the Level-3 BLAS routines so they can be interrupted by the user
   by hitting Control-C. Code wrapped with CATHC_INTERRUPTS should
   not have any new/delete/malloc/free calls. It should only contain
   straightforward code that can be interrupted at any point. */
#define CATCH_INTERRUPTS(code)\
    SetHardInterruptHandler();\
	code;\
	SetSoftInterruptHandler()

#define COMMON_H

#endif
