/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#define true 1
#define false 0

#define NCOLS 500
/*
 * EXP1: Raw data are scaled to -2^EXP1, +2^EXP1
 * EXP2: Trigonometric coefficients are scaled up by 2^EXP2 to do
 *       integer math.
 * PRECISION: 2^EXP2
*/
#define EXP1 15
#define EXP2 14
#define PRECISION1 32768
#define PRECISION2 16384
/*
 * Used in grand tour code.
*/
#define PP_REPLOT_FREQ 15
#define MAXINT 2147483647
#define PI 3.1415926535897932
#define TWOPI 6.2831853071795864
#define MAXTHETA 6.3831853071795864
#define MAXHIST 100    /* maximum number of backtracks */
/* for use in reset_var_labels() */
#define PRINCCOMP_ON 0
#define PRINCCOMP_OFF 1
/* backtrack defines */
#define FORWARD 1
#define BACKWARD -1
/* local scan defines */
#define OUT 1
#define IN 0

/* So that some toggle widgets can be set up to be
 * "0 of many" and some can be forced to be "1 of many". */
#define ANY_OF_MANY 0
#define ONE_OF_MANY 1

/* Default size of varselect circles.  */
#define RADIUS 15
/* Initial rotation angle */
#define THETA0 0.015
/* Initial tour step */
#define TOURSTEP0 0.003

/* margin to use in defining extended brush for plot_bins() */
/* I think this should be half the size of the biggest glyph,
   which is presently the circle with diameter 15
*/
#define BRUSH_MARGIN 8

/* glyph types and sizes */
#define NGLYPHTYPES 7
#define NGLYPHSIZES 5
/* number of brushing glyphs and colors */
/*#define NGLYPHS (NGLYPHTYPES*NGLYPHSIZES)*/
#define NGLYPHS ((NGLYPHTYPES-1)*NGLYPHSIZES + 1)
#define NCOLORS 10

#define PLUS_GLYPH 1
#define X_GLYPH 2
#define OPEN_RECTANGLE_GLYPH 3
#define FILLED_RECTANGLE_GLYPH 4
#define OPEN_CIRCLE_GLYPH 5
#define FILLED_CIRCLE_GLYPH 6
#define POINT_GLYPH 7

#define TINY 1
#define SMALL 2
#define MEDIUM 3
#define LARGE 4
#define JUMBO 5

/*
 * fraction of plot window used for default scaling
*/
#define DEF_SCALE 0.65
#define SCALE_MIN 0.02
#define SCALE0 0.01
#define SQUARE_PLOT 1

#define COLLABLEN 25
#define ROWLABLEN 50

#ifndef MIN
#define MIN(x,y) ((x)<(y)?(x):(y))
#endif
#ifndef MAX
#define MAX(x,y) ((x)>(y)?(x):(y))
#endif

#define SIGN(a, b) ((b) >= 0.0 ? fabs(a) : -fabs(a))
#define BETWEEN(a,b,x) ( ((a)<=(x) && (x)<=(b)) || ((a)>=(x) && (x)>=(b)) )
#define INT(x) ((int)(x))
#define DOUBLE(x) ((double)(x))
#define FLOAT(x) ((float)(x))
#define SHORT(x) ((short)(x))
#define FONTHEIGHT(f) ((f)->max_bounds.ascent + (f)->max_bounds.descent)
#define FONTWIDTH(f) ((f)->max_bounds.width)

/*
 * number of bins to use in dividing the screen into regions
 * for speed in brushing and identification
*/
#define NVBINS 30
#define NHBINS 30

 /*#define BUFSIZE 8192*/
#define BUFSIZE 24576

#define ASCII_TEXT_BORDER_WIDTH 2

#define SAVE_SPIN_COEFS          save_types[0]
#define SAVE_TOUR_COEFS          save_types[1]
#define SAVE_TOUR_HIST           save_types[2]
#define SAVE_POINT_COLORS_GLYPHS save_types[3]
#define READ_DATA                save_types[4]
#define READ_TOUR_HIST           save_types[5]
#define OPEN_BITMAP_FILE         save_types[6]
#define SAVE_LINES               save_types[7]
#define READ_LINES               save_types[8]
#define SAVE_RESOURCES           save_types[9]
#define SAVE_DATA                save_types[10]
#define SAVE_LINE_COLORS         save_types[11]

typedef struct {
	long x, y;
} lcoords;
typedef struct {
	int x, y;
} icoords;
typedef struct {
	float x, y;
} fcoords;
typedef struct {
	float min, max;
} lims;
typedef struct {
    int a, b;
} connect_lines;
typedef struct {
    int x1, y1, x2, y2;
} brush_coords;

typedef struct {
    Pixel fg, bg, border;
} WidgetColors;

/*
 * When changing this structure, don't forget to edit the resources[]
 * vector in xgobi_init.c
*/
typedef struct {
    unsigned long fg, bg, border;
	XFontStruct *font;
	XFontStruct *plotFont;
	XFontStruct *helpFont;
	String brushColor0, brushColor1, brushColor2, brushColor3;
	String brushColor4, brushColor5, brushColor6, brushColor7;
	String brushColor8, brushColor9;
    Boolean showAxes, showPoints, showLines;
    Boolean linkBrush, linkIdentify, linkTour; /* dfschange */
    Boolean jumpBrush, reshapeBrush;
    Boolean carryVars;
    int glyphType;
    int glyphSize;
	String pointerColor;
} AppData, *AppDataPtr;

typedef struct {
	Dimension width, height;
} WidgetSize;

/* glyph vectors */
typedef struct {
    int type;
    int size;
} glyphv;

/* grand tour history */
typedef struct hist_rec {
    struct hist_rec *prev, *next;
    float *hist[2];
} hist_rec;

/* axis plotting */
#define NTICKS 40
typedef struct {
	int nticks[NCOLS];
	float xticks[NTICKS];
	float yticks[NTICKS];
	lcoords plane[NTICKS];
	icoords screen[NTICKS];
} tickinfo;

#define ChooseX(w,r,x) XDrawLine(display, w, varpanel_xor_GC, \
                                 r, r, r+x, r)
#define ChooseY(w,r,x) XDrawLine(display, w, varpanel_xor_GC, \
                                 r, r, r, r-x)
#define ChooseVar(w,r,x,y) XDrawLine(display, w, varpanel_xor_GC, \
                                     r, r, r+x, r-y)
typedef struct {
 Boolean is_realized;

 char datafilename[120];
 Widget shell, form0, box0, box1, box2, workspace;
 Window plot_window;
 Drawable pixmap0;
 /* Vectors of min and max values.  lim0 contains the min_max limits */
 lims *lim0, *lim;
 lims *nicelim;
 float **raw_data;
 float **sphered_data;
 float **tform_data;
 long **world_data;
 lcoords *planar;
 icoords *screen;
 icoords max, mid;
 int minxy;
 lcoords is;
 int ncols, nrows;
 int ncols_used;
 char save_type[50];
 WidgetSize plotsize;

/* Carry variables between plotting modes? */
 Boolean carry_vars;

 /* Deleting the erased points */
 Boolean delete_erased_pts;
 int *rows_in_plot;
 int nrows_in_plot;

 /* axis plotting */
 Boolean is_axes;

/* Variable grouping */
 int *vgroup_ids;

/* standardization options */
 int std_type;  /* Can be 0, 1 or 2 */
 float std_width;

/* textured dot plotting */
 Boolean is_dotplotting;
 Boolean is_dotplot_cycle;
 struct {int x, y;} dotplot_vars;

/* xy plotting */
 Boolean is_xyplotting, is_xy_cycle;
 struct {int x, y;} xy_vars;

/* Axes */
 float *tickdelta;
 tickinfo ticks0, ticks;
 /* axis positions in screen coordinates */
 icoords screen_axes[3];
 int *deci;
 int maxwidth, minindex;

 /* for connecting points with segments */
 connect_lines *connecting_lines;
 Boolean connect_the_points;
 Boolean plot_the_points;
 int nlinks;
 Widget le_add_mouse, le_delete_mouse;
 Boolean is_line_editing;

/* case identification */
 Widget identify_mouse ;
 Boolean is_identify;
 int nearest_point;  /* -1 if outside the window; 0:nrows otherwise */
 Cardinal *sticky_ids;
 int nsticky_ids;
 char **rowlab;

/* case profile plots */
 Boolean is_cprof_plotting;

/* magnifying glass */
 Boolean is_magnify;

/* help */
 struct {int pb, menupb, sbar;} nhelpids;

/* variable selection */
 Widget var_panel;
 Widget *varboxw, *varlabw, *vardraww;
 Boolean *varchosen;
 char **collab;
 char **collab_tform;
 int radius;  /* change to var_radius ? */

/* brushing */
 Widget brush_mouse ;
 Boolean is_brushing;
 Boolean is_point_painting;
 unsigned short *under_new_brush, *erased;
 Boolean is_persistent, is_transient, is_undo, is_erase;
 Boolean brush_on ;
 Boolean is_glyph_painting;
 Boolean is_color_painting;
 /* if True, brush jumps to cursor; if False, cursor jumps to brush */
 Boolean jump_brush;
 /* if True, brush is reshaped between modes */
 Boolean reshape_brush;
 glyphv glyph_id, glyph_0;
 glyphv *glyph_ids, *glyph_now, *glyph_prev;
 unsigned long color_id;
 unsigned long *color_ids, *color_now, *color_prev;
/* line brushing */
 unsigned short *xed_by_new_brush;
 Boolean is_line_painting;
 unsigned long *line_color_ids, *line_color_now, *line_color_prev;

/* dfstour */
/* linking of brushing, identification, touring ... */
 Boolean linked_brushing;
 Boolean linked_identify;
 Boolean linked_touring;
 Boolean current_window;
 unsigned long *senddata;
 Boolean got_new_paint;
 int nevents;

/* for binning the plot window */
 int nhbins, nvbins;
 Cardinal ***binarray;
 Cardinal **bincounts;
/*
 * These are initialized so that the first merge_brushbins()
 * call will behave reasonably.
*/
 icoords bin0, bin1;

/* shifting and scaling */
 Boolean scale_type;
 Widget scale_mouse;
 fcoords scale;
 fcoords scale0;
 fcoords tour_scale;
 fcoords tour_scale0;
 icoords shift_scrn;
 int shift_scrn0;
 icoords shift_wrld;
 icoords shift_wrld0;
 Boolean is_scaling;
 Boolean run_shift_proc, run_scale_proc;
 int scaling_btn;
/*
 * scale_cntr = True: use data center for scaling
 * scale_cntr = False: use plot center
*/
 Boolean scale_cntr;
 icoords cntr;

/* Rotation */
 Widget spin_mouse ;
 Boolean is_spinning;
 Boolean is_spin_paused;
 struct {int x, y, z;} spin_vars;
 struct {Boolean yaxis, xaxis, oblique;} is_spin_type;
 float theta0;
 struct {float yaxis, xaxis, oblique;} theta;
/* Axis-based rotation */
 fcoords cost, sint;
 icoords icost, isint, ocost, osint;
/* Oblique rotation */
 icoords xax, yax, zax;
 float Rmat0[3][3];
 Boolean is_interp;
 Boolean is_rocking;
 Boolean run_spin_axis_proc;
 Boolean run_rock_proc;
 Boolean run_interp_proc;
 Boolean run_spin_oblique_proc;

/* grand tour */
 Widget tour_io_menu_cmd, tour_io_menu;
 Widget tour_io_menu_btn[3];
 /* just added -- dfs */
 Widget princ_comp_cmd, proj_pursuit_cmd, tour_section_cmd;
 /* bases */
 float **u0, **u1, **u, **uold;
 /* projections onto span of starting and ending plane */
 long  **xi0, **xi1;
 /* principle directions, with tv a scratch array */
 float **tv, **v0, **v1;

 /* angles of rotation from u to v */
 float s[2];
 /* cosines and sines of s */
 float coss[2], sins[2];
 /* ditto in integer */
 long  icoss[2], isins[2];
 /* principle angles incrementer*/
 float tinc[5];  /* Givens interpolation requires 5 here */
 /* principle angles */
 float tau[5];  /* Givens interpolation requires 5 here */
 /* scratch arrays */
 float *tnx;

 /* number of steps between bases */
 float step;
 /* step increment based on intrinsic L2-distance */
 float delta;
 /* "intrinsic L2-distance" */
 float dv;
 /* indicator for in grand tour mode */
 Boolean is_touring;
 /*number of variables on tour */
 int numvars_t;
 /*numbers of chosen variables */
 int *tour_vars;
 /* for backtracking */
 hist_rec *fl, *curr, *hfirst, *hend;
 int nhist_list, max_nhist_list, old_nhist_list;
 /* indicator for backtracking running */
 Boolean is_backtracking;
 /* indicator for in step mode */
 Boolean is_stepping;
 /* indicator for locally scanning U0-U1-U0-U2-..*/
 Boolean is_local_scan;
 int local_scan_dir;
 /* indicator for cycling backwards through history */
 int backtrack_dir;  /* Can be FORWARD or BACKWARD */
 /* indicator for switching between different actions in backtrack_proc() */
 int backtrack_action;  /* 0, 1 or 2 */
 /* tour axis labeling */
 XSegment *tour_axes;
 char **tour_lab;
 /* needs to be global to be passed into pack_data vector for linked touring */
 Boolean new_basis_ind;

 Boolean is_tour_paused;
 Boolean run_tour_proc;
 Boolean tour_receive;
 Boolean tour_hist_just_read;

 /* principal components and projection pursuit */
 Widget pp_plot_wksp;
 Boolean is_pp;
 Boolean is_pp_optimz;
 Boolean is_princ_comp;
 int pp_index_btn;
 Boolean recalc_max_min;
 int xaxis_indent;
 Boolean new_direction_flag;
 int pp_replot_freq;

/* For section tour */
 Boolean is_tour_section;
 glyphv *section_glyph_ids;
 unsigned long *section_color_ids;

} xgobidata;
