.BG
.FN xgobi
.TL
XGobi:  A Dynamic Graphics Program for Data Analysis
.CS
xgobi(matrx, collab=NULL, rowlab=NULL,
 std=``mmx'', dev=2.0, vgroups=NULL,
 colors=NULL, glyphs=NULL, erase=NULL, lines=NULL, resources=NULL,
 display=NULL, name=NULL, title=NULL, mach=NULL)
.AG matrx
Any numeric matrix
.AG collab
Optional character vector of column labels; the default is
dimnames(matrx)[[2]].  If no default exists, xgobi constructs its own
defaults.
.AG rowlab
Optional character vector of row labels; the default is
dimnames(matrx)[[1]].  If no default exists, xgobi constructs its own
defaults.
.AG std
Optional string; which standardization of view to use.  Default is
``mmx,'' minimum-maximum scaling, in which the view is centered at the
midpoint of the data, and all the data fits inside the plotting
window.  Alternatives are ``msd,'' in which the plot is centered at the
mean of the data and `dev' standard deviations fit inside the plotting
region, or ``mmd,'' in which the plot is centered at the median and `dev'
median absolute deviations are shown inside the plotting window.
.AG dev
Optional numeric scalar; the number of standard deviations (if ``msd''
is chosen) or median absolute deviations (if ``mmd'' is chosen) that will
be plotted inside the plotting window.  Default is 2.
.AG vgroups
Optional integer vector, used to assign columns to groups for 
transformation and axis scaling.  This vector must contain one integer
for each variable.  Columns to be grouped together should share the
same integer.  Default is the vector 1:(ncol(matrx)).
.AG colors
Optional character vector, used to supply colors to be used on
startup; the default is that all points are the same color.
.AG glyphs
Optional integer vector, used to supply glyphs to be used on
startup; the default is that all points are drawn with the same glyph.
.AG erase
Optional integer vector of length equal to the number of rows in the
data and composed of 1s and 0s.  A 1 in position i specifies that 
point i should be erased.  The default is a vector of 0s.
.AG lines
Optional integer matrix, n by 2, which specifies by row number
pairs of points to be connected by line segments.  The default
connecting line matrix connects each point to the one that follows
it in the data; that is, (1 2), (2 3), (3 4), ..., (n-1, n).
.AG resources
Optional character vector created by clicking on the "Save
Resources" button in XGobi (if this XGobi was initiated during
an S session).
.AG display
Optional character string, identifying the monitor on which to display
the xgobi window.  The default is ``machine:0.0'' where 'machine' is the
name of the user's workstation.  See documentation for xgobi or for X.
.AG name
Optional character string which defines the ``-name'' argument used by
X. The default is the name of the current matrix matrx.  See documentation
for xgobi, or for X.
.AG title
Optional character string which defines the ``-title'' argument used by
X. The default is the name of the current matrix matrx.  See documentation
for xgobi, or for X.
.AG mach
Optional characracter string identifying the machine architecture
in use.  This is useful on networked file systems as a way to indicate
where to find the xgobi executable.  Examples are ``sun4'' or ``dec3100;''
XGobi attempts to determine the correct architecture by looking for
certain system files.
.RT
The xgobi S function executes a call to the C program of the same name,
an interactive statistical graphics program which runs under the X
Window System, and returns control of the S shell to the user.
.PP
XGobi can be used to create vectors of brushing information and rotation
coefficients; see the documentation for XGobi for details.
.SH REFERENCE
"User's Manual for XGobi, a Dynamic Graphics Program for
Data Analysis Implemented in the X Window System (Release 2),"
Swayne, D. F., Cook, D., and Buja, A., Bellcore Technical Memorandum, 1992.

.SH CONTACT
D. F. Swayne
.EX
xgobi(x) 
xgobi(cbind(x,y,z), name=``laser'')
xgobi(x, collabels, rowlabels)
.KW dynamic, interactive, graphics, plotting, rotation, grand tour, identify
.WR

