#include <RpTypeCaster.h>
#include <assert.h>


RpTypeCaster::RpTypeCaster( RpInputImage *pImage, const RpImageArea& area, RpType dataType)
{
   setArea( area );
   setType( dataType );
   
   _pHost = pImage;
   if ( _pHost )
      _pHost->registerReference();
      
   return;
}



RpTypeCaster::RpTypeCaster( RpSampledImage *pImage, RpType dataType )
{
   setType( dataType );
   
   _pHost = (RpInputImage *) pImage;   
   if ( _pHost )
   {
      setArea( pImage->getArea() );
      _pHost->registerReference();
      
      setFillStrategy( pImage->getFillStrategy() );
      if ( getFillStrategy() )
         getFillStrategy()->registerReference();

   }
   
   return;
}



RpTypeCaster::~RpTypeCaster( void )
{
   if ( _pHost )
      _pHost->unregisterReference();
      
   return;
}


int
RpTypeCaster::fillTile( RpImageTile *pWriteHere )
{
   int		iRet = 0;

   if ( pWriteHere && _pHost )
   {
      iRet = pWriteHere->alloc( pWriteHere->getArea(), _pHost->getType() );
      
      if ( !iRet )
      {
         iRet = _pHost->fillTile( pWriteHere );         
         applyFillStrategy( pWriteHere );
         
         pWriteHere->typecast( getType() );

      } else
         iRet = -1;

   } else
      iRet = -1;

   return( iRet );
}

