#include <RpType.h>

#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
float const label##Black = (float) black;	\
float const label##White = (float) white;	\
float const label##Min   = (float) low;	\
float const label##Max   = (float) high
#include <RpType.m>





unsigned bytesize( RpType type )
{
   unsigned uRet;
   
   switch ( type )
   {

#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
      case( label ): uRet = sizeof ( type ); break
#include <RpType.m>   
   
      default:
         uRet = 0;
         break;
   };
   return ( uRet );
}


unsigned
precedence( RpType type )
{
   unsigned uRet;
   
   switch ( type )
   {

#define RpTYPEMACRO( label, type, low, high, black, white, prec, func )   case( label ): uRet=prec; break
#include <RpType.m>   
   
      default:
         uRet = 0;
         break;
   };
   return ( uRet );
}

// ************************************************************************

void
typecast_Float( 
   register unsigned long ulLoop, 
   register float *pDest,
   void *vpSource,
   RpType srcType 
   
   )
{
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func )	\
   type 		*  label##srcptr
#include <RpType.m>   
   float		rFactor;

   switch( srcType ) {
   
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
case( label ):   rFactor = 1.0 / (float) ( white - black ) ; \
                label##srcptr = ( type * ) vpSource;      \
                while ( ulLoop-- ) {			\
                 *pDest = ((float) *(label##srcptr++) - black ) * rFactor; \
                 pDest++; 				\
                 } break
#include <RpType.m>					
   };
   
   return;
}

// ------------------------------------------------------------------------

void
typecast_Film (
   register unsigned long	ulLoop,
   register unsigned short	*pDest,
   void				*vpSource,
   RpType			srcType
)
{
   register float		target;
   
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
   type 		*  label##srcptr
#include <RpType.m>   
   
   switch( srcType ) {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
case( label ):   label##srcptr = ( type * ) vpSource;   		\
                 while ( ulLoop-- ) {					\
                 target = (float) ( * label##srcptr );                  \
                 target -= (float) black;                               \
                 target *= (RpFilmWhite - RpFilmBlack) / (float) ( white - black );    \
                 target += RpFilmBlack;                                                \
                 *pDest = ( target > (float) 0xFFFF ) ? ( 0xFFFF ) :		       \
                 	  ( ( target < 0.0 ) ? ( 0x00 ) : ((unsigned short) target) ); \
                 label##srcptr++;						       \
                 pDest++; 							       \
                 } break
#include <RpType.m>
   };
   
   return;
}



// ------------------------------------------------------------------------


void
typecast_UShort (
   register unsigned long 	ulLoop,
   register unsigned short 	*pDest,
   void 			*vpSource,
   RpType 			srcType 
)
{   
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
   type 		*  label##srcptr ;				\
   type			label##srcPixel
#include <RpType.m>   
   
   switch( srcType ) {
   
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
case( label ):   label##srcptr = ( type * ) vpSource;   \
                 while ( ulLoop-- ) {			\
                 label##srcPixel = ( (*(label##srcptr)) > white )?( white ):(*(label##srcptr)); \
                 label##srcPixel = ( label##srcPixel < black )?( black ):( *(label##srcptr));     \
                 *pDest = (unsigned short) ((( label##srcPixel - black ) * 0x0FFFF) / ( white - black )); \
                 label##srcptr++;			\
                 pDest++; 				\
                 } break
#include <RpType.m>					
   };
   
   return;
}

// ------------------------------------------------------------------------
void
typecast_UChar (
   register unsigned long	ulLoop,
   register unsigned char 	*pDest,
   void 			*vpSource,
   RpType 			srcType 
)
{
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func )	\
   type 		*  label##srcptr ;				\
   type			label##srcPixel
#include <RpType.m>   
   
   switch( srcType ) {
   
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func )	\
case( label ):   label##srcptr = ( type * ) vpSource;   \
                while ( ulLoop-- ) {			\
                 label##srcPixel = ( (*(label##srcptr)) > white )?( white ):(*(label##srcptr)); \
                 label##srcPixel = ( label##srcPixel < black )?( black ):( label##srcPixel );   \
                 *pDest = (unsigned char)((( label##srcPixel - black ) * 0x0FF ) / ( white - black )); \
                 label##srcptr++;			\
                 pDest++; 				\
                 } break
#include <RpType.m>					
   };
   
   return;
}
