#include <RpImageTile.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>


unsigned RpImageTile::_memmgr_uCount = 0;
RpImageTile * RpImageTile::_memmgr_ppStore[ __TILE_MEMMGR_SIZE ];


RpImageTile *
RpImageTile::newTile( const RpImageArea& setArea, RpType setType )
{
   RpImageTile		*pRet;
   
   if ( _memmgr_uCount )
   {
      _memmgr_uCount--;
      pRet = _memmgr_ppStore[ _memmgr_uCount ];
      assert( pRet );
      assert( pRet->countReferences() == 1 );
      
      pRet->alloc( setArea, setType );
   } else
      pRet = new RpImageTile( setArea, setType );
   
   return ( pRet );
}


void
RpImageTile::deleteTile( void )
{
   if ( ( _memmgr_uCount < __TILE_MEMMGR_SIZE ) && ( countReferences() == 1 ))
   {
       _memmgr_ppStore[ _memmgr_uCount ] = this;
       _memmgr_uCount++;
       
       _buffer.useBytes( 0 );
       _buffer.compact();
       
   } else
      RpReferenced::unregisterReference();
      
   return;
}


// ------------------------------------------------------------------------

RpImageTile::RpImageTile( const RpImageTile& source )
{
   void *vp1;
   const void *vp2;
   
   alloc( source.getArea(), source.getType() );
   vp1 = getBuffer();
   vp2 = source.getBuffer();

   if ( vp1 && vp2 )
      memcpy( vp1, vp2, source.getRAMSize() );

   return;
}


RpImageTile::RpImageTile( const RpImageArea& setArea, RpType setType )
{   
   alloc( setArea, setType );
   return;
}


int
RpImageTile::alloc( const RpImageArea& setArea, RpType setType )
{
   _maArea = setArea;
   _mtType = setType;
   return ( 0 );
}


//
// returns NULL on error.
//
const void *
RpImageTile::getBufferAt( signed iColumn, signed iRow ) const
{
   const unsigned char *	cpBuffer = 0;
   unsigned 			uIndex = 0;
   
   cpBuffer = (const unsigned char *) getBuffer();   
   if( cpBuffer )
      if (( iColumn >= _maArea.x ) && ((iColumn - _maArea.x )< (signed)_maArea.width ))
      {
         assert( iColumn >= _maArea.x );
	 uIndex = iColumn - _maArea.x;

	 if ((iRow >= _maArea.y ) && ((iRow - _maArea.y)< (signed)_maArea.height ))
	 {
	    uIndex += _maArea.width * ( iRow - _maArea.y );
	    cpBuffer += bytesize( _mtType ) * uIndex;
	 }
      }
   
   return ( (const void *) cpBuffer );
}


void *
RpImageTile::getBufferAt( signed iColumn, signed iRow )
{
   unsigned char *	cpBuffer = 0;
   unsigned 		uIndex = 0;

   cpBuffer = (unsigned char *) getBuffer();   
   if ( cpBuffer )
      if (( iColumn >= _maArea.x ) && ((iColumn - _maArea.x )< (signed)_maArea.width ))
      {
         assert( iColumn >= _maArea.x );
	 uIndex = iColumn - _maArea.x;

	 if ((iRow >= _maArea.y ) && ((iRow - _maArea.y)< (signed)_maArea.height ))
	 {
	    uIndex += _maArea.width * ( iRow - _maArea.y );


	    cpBuffer += bytesize( _mtType ) * uIndex;
	 }
      }
   
   return ( (void *) cpBuffer );
}


const void *
RpImageTile::getBuffer( void ) const
{
   assert( _buffer.getBuffer() );
   return ( _buffer.getBuffer() );
}



void *
RpImageTile::getBuffer( void )
{
   forceInstantiation();
   return( _buffer.getBuffer() );
}


int
RpImageTile::typecast( RpType setType )
{
   int 			iRet;
   RpBinaryBuffer	tempBuffer;
   unsigned long 	ulLoop;

   iRet = 0;
   
   if ( _mtType != setType )
   {
      if ( tempBuffer.useBytes( getRAMSize(), 0 ) )
      {
         memcpy( tempBuffer.getBuffer(), getBuffer(), getRAMSize() );

         if ( _buffer.useBytes(  _maArea.width * _maArea.height * bytesize(setType), 0 ) )
         {
            ulLoop = _maArea.width * _maArea.height;
            switch( setType )
            {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
               case( label ): \
               func ( ulLoop, ( type * ) getBuffer(),tempBuffer.getBuffer(),_mtType); \
               break
#include <RpType.m>
               default:
                  iRet = -1;
                  break;
            };

	    _mtType = setType;

	 } else
            iRet = -1;
      } else
         iRet = -1;
   }
         
   return ( iRet );
}


int
RpImageTile::floodFill( float rValue )
{
   int 			iRet = 0;
   unsigned long 	ulLoop;
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
   type * label##ptr ; \
   type   label##value = (type) label##Black + (type) (( label##White - label##Black ) * rValue )
#include <RpType.m>   
   
   ulLoop = _maArea.width * _maArea.height;

   switch( _mtType )
   {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
         case( label ): \
            label##ptr = ( type * ) getBuffer(); \
            while( ulLoop ) { \
               ulLoop--; \
               *( label##ptr ) = label##value; \
               label##ptr++; \
            } break
#include <RpType.m>
   };
        
   return ( iRet );
}

// ------------------------------------------------------------------------

void
RpImageTile::forceInstantiation( void )
{
   unsigned long uRAMDemand;
   
   uRAMDemand = getRAMSize();
   
   if ( uRAMDemand > _buffer.usingBytes() )
      _buffer.useBytes( uRAMDemand, 0 );
   
   return;
}

// ------------------------------------------------------------------------
void
tilecpy( RpImageTile& dest, const RpImageTile& src, const RpImageArea& area )
{
   RpImageArea	intersectArea;
   signed	iRowLoop;
   unsigned	uRowSize;
   const void 	*vp1;
   void		*vp2;
   
   if ( dest.getType() == src.getType() )
   {
      intersectArea = 
	 intersect( intersect( dest.getArea(), src.getArea() ), area );

      if( intersectArea.width && intersectArea.height )
      {
         uRowSize = bytesize( dest.getType() ) * intersectArea.width;
         iRowLoop = intersectArea.y + intersectArea.height;

         while ( iRowLoop > intersectArea.y )
         {
            iRowLoop--;
            vp1 = src.getBufferAt( intersectArea.x, iRowLoop );
            vp2 = dest.getBufferAt( intersectArea.x, iRowLoop );            
            if ( vp1 && vp2 )
               memcpy( vp2, vp1, uRowSize );

         }
      }
   }    
   return;
}
