#include <RpFillConstant.h>
#include <RpSampledImage.h>
#include <assert.h>

RpFillConstant::RpFillConstant( float rBrightness )
{

#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) \
typename##brightness =  (type) \
   (( rBrightness * ((float) white )) + \
   ( (1.0 - rBrightness ) * (( float ) black ) ))
#include <RpType.m>

   return;
}


int
RpFillConstant::fillTile( RpSampledImage *pHost, RpImageTile *pWriteHere )
{
   RpImageArea		imageArea;
   RpImageArea		areas[8];
   int			iRet = 0;
   unsigned		uLoop;
   
   if ( pHost && pWriteHere )
   {
      imageArea = pHost->getArea();
      imageArea.c = pWriteHere->getArea().c;
      imageArea.z = pWriteHere->getArea().z;
      difference( areas, pWriteHere->getArea(), imageArea );
      
      //
      // fill in x and y
      //
      uLoop = 8;
      while ( uLoop )
      {
         --uLoop;
         //
         // this conditional is an optimization:
         //
         if( areas[uLoop].width && areas[uLoop].height )
            iRet |= fillConstant( pWriteHere, areas[ uLoop ] );
      }
      
      //
      // fill in z and c
      //
      if (
            ( pWriteHere->getArea().c >= pHost->getArea().c ) ||
            ( pWriteHere->getArea().c < 0 ) ||
            ( pWriteHere->getArea().z >= pHost->getArea().z ) ||
            ( pWriteHere->getArea().z < 0 )
         )
         {            
            iRet |= fillConstant( pWriteHere, imageArea );
         }

   }
     
   return( iRet );
}



int
RpFillConstant::fillConstant( RpImageTile *pTile, const RpImageArea& area )
{
   int 		iRet = 0;
   signed	iY;
   unsigned	iWidth;
   
#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) \
type * typename##buffer
#include <RpType.m>   
   
   assert( pTile );
   
   //
   // assert (area) is a subarea of pTile->getArea()
   //
   
   switch( pTile->getType() )
   {
            
#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) 		\
   case( typename ) :							\
      iY = area.y + (signed) area.height; 				\
      while ( iY > area.y ) {						\
         iY--;								\
         typename##buffer = ( type *) pTile->getBufferAt(area.x, iY);	\
         if ( typename##buffer ) { 					\
            iWidth = area.width;					\
            while( iWidth )						\
            { --iWidth;							\
               *( typename##buffer ) = typename##brightness;		\
               typename##buffer ++;					\
            }								\
         } 								\
      } break
#include <RpType.m>
            
   };
  
   return ( iRet );
}
