#include <RpCompositer.h>
#include <RpType.h>
#include <assert.h>

RpCompositer::RpCompositer
( 
   RpInputImage *pForeground, 
   RpInputImage *pBackground, 
   RpInputImage *pMatte, 
   unsigned uChannelIndex, 
   unsigned uChannelCount
)
{
    RpType thisType = RpUChar;
   
   _uChannelIndex = uChannelIndex;
   _uChannelCount = uChannelCount;
   
   _pForeground = pForeground;
   _pBackground = pBackground;
   _pMatte = pMatte;
   
   if ( pForeground )
   {
      thisType = pForeground->getType();
      pForeground->registerReference();
   }

   if ( pBackground )
   {
      pBackground->registerReference();
      thisType = 
	 ( precedence( thisType ) > precedence( pBackground->getType() ) ) ?
	 ( thisType ) :
	 ( pBackground->getType() );
   }
      
   if ( pMatte )
      pMatte->registerReference();
   
   setType( thisType );
   return;
}


RpCompositer::~RpCompositer( void )
{
   if ( _pForeground )
      _pForeground->unregisterReference();
      
   if ( _pBackground )
      _pBackground->unregisterReference();
      
   if ( _pMatte )
      _pMatte->unregisterReference();
      
   return;
}


int
RpCompositer::fillTile( RpImageTile *pWriteHere )
{
   int		iRet = 0;
   RpImageArea	area;
   
   RpImageTile	*pForeTile;
   RpImageTile	*pBackTile;
   RpImageTile	*pMatteTile;
      
   if( _pForeground && _pBackground && _pMatte && pWriteHere )
   {
      area = pWriteHere->getArea();
      
      pForeTile = _pForeground->newTile( area );
      pBackTile = _pBackground->newTile( area );
      
      area.c %= _uChannelCount;
      area.c += _uChannelIndex;            
      pMatteTile = _pMatte->newTile( area );
      
      if ( pForeTile && pBackTile && pMatteTile )
         doComposite( pWriteHere, pForeTile, pBackTile, pMatteTile );
      else
         iRet = -1;
         
      if ( pForeTile )
         pForeTile->deleteTile();
      if ( pBackTile )
         pBackTile->deleteTile();
      if ( pMatteTile )
         pMatteTile->deleteTile();

   } else
      iRet = -1;   
   
   return ( iRet );
}



void
RpCompositer::doComposite
( 
   RpImageTile *pWriteHere, 
   RpImageTile *pFore,
   RpImageTile *pBack,
   RpImageTile *pMatte
)
{
   register float		rRegister1;
   register float		rRegister2;
   unsigned long		ulLoop;
   float			*fpMatteLoop;
#define RpTYPEMACRO( label, type, min, max, black, white, precedence, func ) \
   type *			label##pFore; \
   type *			label##pBack; \
   type *			label##pDest
#include <RpType.m>   
 
   assert( pWriteHere && pFore && pBack && pMatte );
   assert( pFore->getBuffer() && pBack->getBuffer() && pMatte->getBuffer() );

   assert( pWriteHere->getType() == getType() );
   pFore->typecast( getType() );
   pBack->typecast( getType() );  

   pMatte->typecast( RpFloat );
   fpMatteLoop = ( float * ) pMatte->getBuffer();
   
   ulLoop = pWriteHere->getArea().height * pWriteHere->getArea().width;
   
   switch( pWriteHere->getType() )
   {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
      case( label ): 							\
	 label##pFore = ( type * ) pFore->getBuffer();	 		\
	 label##pBack = ( type * ) pBack->getBuffer(); 			\
	 label##pDest = ( type * ) pWriteHere->getBuffer(); 		\
	 while( ulLoop ) { 						\
	 ulLoop--; 							\
	 \
	 rRegister1 = *fpMatteLoop; fpMatteLoop++;		   \
	 rRegister1 = ( rRegister1 > 1.0 )?( 1.0 ):( rRegister1 ); \
	 rRegister1 = ( rRegister1 < 0.0 )?( 0.0 ):( rRegister1 ); \
	 rRegister2 = 1.0 - rRegister1;			\
	 rRegister1 *= ((float) * label##pFore );	\
	 rRegister2 *= ((float) * label##pBack );	\
	 rRegister2 += rRegister1 ; 			\
	 rRegister2 = ( rRegister2 > high ) ? ( high ) : (rRegister2);\
	 rRegister2 = ( rRegister2 < low ) ? ( low ) : (rRegister2);\
	 * label##pDest = ( type ) rRegister2 ; 			\
	 label##pDest ++; label##pFore ++; label##pBack ++; 		\
	 } break
#include <RpType.m>   

   };

   return;
}
