#ifndef RpInputImage_CLASS
#define RpInputImage_CLASS

#include <RpReferenced.h>
#include <RpType.h>
#include <RpImageTile.h>

// ************************************************************************
// CLASS: RpInputImage
// DESC:
//    This is a base class for an image processing operation.
//    Each RpInputImage has associated with it an inherent
//    data type.
// NOTE:
//    There are two interface methods for requesting image data.
//    (a) newTile() instantiates the tile, fills it with data & returns
//        a pointer.   The receiver must remember to use
//        RpImageTile::deleteTile() to deallocate the tile when it is
//        not longer needed.  Don't delete an RpImageTile directly!
//    (b) fillTile() takes an existing tile and validates it directly.
//    Use newTile() whenever possible!  Use fillTile() to bypass all
//    acceleration mechanisms!
//
class RpInputImage : public RpReferenced {
   public:   
      // ------------------------------------------------------------------
      // post: returns a pointer to an RpImageTile containing the
      //       data of the requested area.
      // note: use RpImageTile::deleteTile() when you are done.
      // post: returns 0 on error.
      //
      virtual RpImageTile *
      newTile( const RpImageArea & area );

      // ------------------------------------------------------------------
      // pre: pWriteHere->getType() should match the image type.
      // post: returns a non-zero on error.
      //
      virtual int
      fillTile( RpImageTile *pWriteHere ) = 0;

      RpType
      getType( void ) const
      { return (_mtType ); }
      
   protected:
      RpInputImage( RpType setType=RpFilm ) { _mtType = setType; }
      
      void
      setType( RpType setType ) { _mtType = setType; }

   private:
      RpType		_mtType;
};

#endif
