#ifndef RpContraster_CLASS
#define RpContraster_CLASS

#include <RpInputImage.h>

// ************************************************************************
// CLASS:  RpContraster
// DESC:
//    Stretches the histogram of the input image linearly
//
class RpContraster : public RpInputImage {
   public:      
      RpContraster( RpInputImage *pIn, float rLumFactor, float rGreyPoint = 0.5 );
      
      ~RpContraster( void );
      
      int
      fillTile( RpImageTile *pWriteHere );
      
   protected:
      RpInputImage 	*_pHost;
      float		_rLumFactor;
      float		_rGrey;
      
      void
      contrastFilm( RpImageTile *, RpImageTile * );
      
      void
      contrastFloat( RpImageTile *, RpImageTile * );      
};

#endif

