#ifndef lint
static       char    rcsid[] = "$Header: vector.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	vector.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * normalize a vector
 * return the original length of the vector
 */

FLOAT	VecNormalize(s)
FLOAT	s[3];
{
	FLOAT	t;

	t = VecLength(s);

	if (t < TOE)
		return(0.0);

	s[0] /= t;
	s[1] /= t;
	s[2] /= t;

	return(t);
}

/*
 * find X axis and Y axis for an extrusion vector
 */

VOID	ArbitraryAxis(xaxis, yaxis, zaxis)
FLOAT	xaxis[3];
FLOAT	yaxis[3];
FLOAT	zaxis[3];
{
	if (fabs(zaxis[0]) < (1.0 / 64.0) && fabs(zaxis[1]) < (1.0 / 64.0))
		VecCross(YAxis, zaxis, xaxis);
	else
		VecCross(ZAxis, zaxis, xaxis);
	(VOID) VecNormalize(xaxis);
	VecCross(zaxis, xaxis, yaxis);
	(VOID) VecNormalize(yaxis);
}

#ifdef	MSC
/*
 * for MSC, use function call for reducing code size
 */

VOID	VecCopy(a, b)
FLOAT	a[3], b[3];
{
	b[0] = a[0];
	b[1] = a[1];
	b[2] = a[2];
}

VOID	VecScale(s, a, b)
FLOAT	s;
FLOAT	a[3], b[3];
{
	b[0] = s * a[0];
	b[1] = s * a[1];
	b[2] = s * a[2];
}

VOID	VecAdd(a, b, c)
FLOAT	a[3], b[3], c[3];
{
	c[0] = a[0] + b[0];
	c[1] = a[1] + b[1];
	c[2] = a[2] + b[2];
}

VOID	VecSub(a, b, c)
FLOAT	a[3], b[3], c[3];
{
	c[0] = a[0] - b[0];
	c[1] = a[1] - b[1];
	c[2] = a[2] - b[2];
}

FLOAT	VecDot(a, b)
FLOAT	a[3], b[3];
{
	return(a[0] * b[0] + a[1] * b[1] + a[2] * b[2]);
}

VOID	VecNegate(a, b)
FLOAT	a[3], b[3];
{
	b[0] = - a[0];
	b[1] = - a[1];
	b[2] = - a[2];
}

VOID	VecAddS(s, a, b, c)
FLOAT	s;
FLOAT	a[3], b[3], c[3];
{
	c[0] = s * a[0] + b[0];
	c[1] = s * a[1] + b[1];
	c[2] = s * a[2] + b[2];
}

VOID	VecCross(a, b, c)
FLOAT	a[3], b[3], c[3];
{
	c[0] = a[1] * b[2] - a[2] * b[1];
	c[1] = a[2] * b[0] - a[0] * b[2];
	c[2] = a[0] * b[1] - a[1] * b[0];
}

FLOAT	VecLength(s)
FLOAT	s[3];
{
	return((FLOAT) sqrt(VecDot(s, s)));
}
#endif
