#ifndef lint
static       char    rcsid[] = "$Header: text.c,v 1.2 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	text.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

/*
 * text generation flags. they are bit-coded
 */

#define	TEXTGEN_BACKWARDS	2	/* text is backwards (mirrored in X) */
#define	TEXTGEN_UPSIDEDOWN	4	/* text is upside down (mirrored in Y) */

/*
 * define justification types. they are not bit-coded
 */

#define	TEXTJUSTIFY_LEFT	0	/* text is left justified */
#define	TEXTJUSTIFY_CENTER	1	/* text is centered along its baseline */
#define	TEXTJUSTIFY_RIGHT	2	/* text is right justified */
#define	TEXTJUSTIFY_WIDTHALIGN	3	/* text is aligned between two points */
					/* height varies */
#define	TEXTJUSTIFY_MIDDLE	4	/* text is "middle" (fully) centered */
#define	TEXTJUSTIFY_HEIGHTALIGN	5	/* text is aligned between two points */
					/* width varies */

typedef	struct	text	{
	FLOAT	point[3];		/* insertion point of text */
	FLOAT	height;			/* height of text */
	CHAR	*text;			/* string of the text value */
	FLOAT	rotationangle;		/* rotation angle, default 0 */
	FLOAT	xscalefactor;		/* relative X scale factor, */
					/* default 1 */
	FLOAT	obliquingangle;		/* obliquingangle, default 0 */
	CHAR	*stylename;		/* text style name, defaule */
					/* "STANDARD" */
	INT	generationflag;		/* text generation flag, default 0 */
	INT	justificationtype;	/* text justification type, default 0 */
	FLOAT	*alignmentpoint;	/* alignment point, appears only */
					/* if justification flag is defined */
					/* and nonzero. its size is 3 * FLOAT */
} TEXT;

/*
 * text is not used now, so just skip over it
 */

/*ARGSUSED*/
ENTITY	*TextDxfParse(layerlist)
LAYER	**layerlist;
{
	/*
	 * do nothing, just skip over
	 */

	do
		GetNextGroup();
	while (Group->code != 0);

	return(NULL);
}

/*ARGSUSED*/
VOID	TextDefOutput(entity)
ENTITY	*entity;
{
}

/*ARGSUSED*/
VOID	TextNffOutput(entity)
ENTITY	*entity;
{
}

/*ARGSUSED*/
VOID	TextDxfOutput(entity)
ENTITY	*entity;
{
}

/*ARGSUSED*/
VOID	TextRadOutput(entity)
ENTITY	*entity;
{
}
