#ifndef lint
static       char    rcsid[] = "$Header: group.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	group.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * a group in a DXF file is two lines of ASCII strings, the first is
 * an integer called group code, the secord is a text string, or an
 * integer, or a floating point number
 */

/*
 * compare a given group with specific code and string
 * if the group code and value (i.e. a string) are correct,
 * return 1, else 0
 */

INT	CmpGroupString(group, code, string)
GROUP	*group;
INT	code;
CHAR	*string;
{
	if (group->code != code)
		return(0);

	if (group->type != GROUP_VALUE_STRING)
		return(0);

	if (strcmp(group->string, string) != 0)
		return(0);

	return(1);
}

/*
 * compare a given group with specific code and integer
 * if the group code and value (i.e. a integer) are correct,
 * return 1, else 0
 */

INT	CmpGroupInteger(group, code, integer)
GROUP	*group;
INT	code;
INT	integer;
{
	if (group->code != code)
		return(0);

	if (group->type != GROUP_VALUE_INTEGER)
		return(0);

	if (group->intnum != integer)
		return(0);

	return(1);
}
