#ifndef lint
static       char    rcsid[] = "$Header: entity.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	entity.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * check the type of an entity
 */

INT	EntityType()
{
	INT	entitytype = -1;

	if (Group->code != 0)
		DXFERR("expect group code 0 but get %d\n", Group->code);

	if (strcmp(Group->string, "LINE") == 0)
		entitytype = ENTITY_LINE;
	else
	if (strcmp(Group->string, "POINT") == 0)
		entitytype = ENTITY_POINT;
	else
	if (strcmp(Group->string, "CIRCLE") == 0)
		entitytype = ENTITY_CIRCLE;
	else
	if (strcmp(Group->string, "ARC") == 0)
		entitytype = ENTITY_ARC;
	else
	if (strcmp(Group->string, "TRACE") == 0)
		entitytype = ENTITY_TRACE;
	else
	if (strcmp(Group->string, "SOLID") == 0)
		entitytype = ENTITY_SOLID;
	else
	if (strcmp(Group->string, "TEXT") == 0)
		entitytype = ENTITY_TEXT;
	else
	if (strcmp(Group->string, "SHAPE") == 0)
		entitytype = ENTITY_SHAPE;
	else
	if (strcmp(Group->string, "BLOCK") == 0)
		entitytype = ENTITY_BLOCK;
	else
	if (strcmp(Group->string, "ENDBLK") == 0)
		entitytype = ENTITY_ENDBLK;
	else
	if (strcmp(Group->string, "INSERT") == 0)
		entitytype = ENTITY_INSERT;
	else
	if (strcmp(Group->string, "ATTDEF") == 0)
		entitytype = ENTITY_ATTDEF;
	else
	if (strcmp(Group->string, "ATTRIB") == 0)
		entitytype = ENTITY_ATTRIB;
	else
	if (strcmp(Group->string, "POLYLINE") == 0)
		entitytype = ENTITY_POLYLINE;
	else
	if (strcmp(Group->string, "VERTEX") == 0)
		entitytype = ENTITY_VERTEX;
	else
	if (strcmp(Group->string, "SEQEND") == 0)
		entitytype = ENTITY_SEQEND;
	else
	if (strcmp(Group->string, "3DLINE") == 0)
		entitytype = ENTITY_3DLINE;
	else
	if (strcmp(Group->string, "3DFACE") == 0)
		entitytype = ENTITY_3DFACE;
	else
	if (strcmp(Group->string, "DIMENSION") == 0)
		entitytype = ENTITY_DIMENSION;

	if (entitytype != -1) {
		if (entitytype != EntityProcs[entitytype].type)
			GENERR("Table EntityProcs corrupted \
				\n%s: you may check defs.h and data.c\n",
				ProgName);
		return(entitytype);
	}

	DXFERR("invalid entity name %s\n", Group->string);

	/*NOTREACHED*/
}

/*
 * parse an entity
 *
 * retrun NULL if the entity is not used now
 */

ENTITY	*EntityDxfParse(layerlist)
LAYER	**layerlist;
{
	INT	entitytype;

	entitytype = EntityType();

	/*
	 * check the entity type
	 */

	if (entitytype == ENTITY_BLOCK)
		DXFERR("unexpected BLOCK group %s", "\n");

	if (entitytype == ENTITY_ENDBLK)
		DXFERR("unexpected ENDBLK group %s", "\n");

	if (entitytype == ENTITY_VERTEX)
		DXFERR("unexpected VERTEX group %s", "\n");

	if (entitytype == ENTITY_SEQEND)
		DXFERR("unexpected SEQEND group %s", "\n");

	/*
	 * ATTDEF and ATTRIB are not used now
	 */

	if (entitytype == ENTITY_ATTDEF || entitytype == ENTITY_ATTRIB) {
		(VOID) AttribDxfParse(layerlist);
		return(NULL);
	}

	/*
	 * parse the entity
	 */

	return((*(EntityProcs[entitytype].dxfparse)) (layerlist));
}
