/*
 *  func.c - function generating program.
 *
 *     10/2/86
 */

#include  <stdio.h>


int  nowarn = 0;


main(argc, argv)
int  argc;
char  *argv[];
{
	extern double  eval(), funvalue();
	double  xmin, xmax;
	char  sbuf[4];
	int  npts = 100;
	int  inclusive = 0;
	int  printord = 1;
	int  i, l;
	double  x;

#ifdef  CPM
	fixargs("func", &argc, &argv);
#endif
#ifdef  BIGGERLIB
	biggerlib();
#endif

	varset("PI", 3.14159265358979323846);

	if (argc < 3)
		goto userror;

	for (i = 3; i < argc && argv[i][0] == '-'; i++)
		switch (argv[i][1]) {
		case 'f':
			fcompile(argv[++i]);
			break;
		case 'n':
			npts = atoi(argv[++i]);
			break;
		case 'i':
			inclusive = !inclusive;
			break;
		case 'x':
			printord = !printord;
			break;
		default:
			goto userror;
		}

	for ( ; i < argc; i++)
		scompile(NULL, argv[i]);

	xmin = eval(argv[1]);
	xmax = eval(argv[2]);

	for (i = 0; i < npts; i++) {
		if (inclusive)
			x = i*(xmax-xmin)/(npts-1) + xmin;
		else
			x = (i+.5)*(xmax-xmin)/npts + xmin;
		if (printord)
			printf("%.9g", x);
		for (l = 'A'; l <= 'Z'; l++) {
			sbuf[0] = l; sbuf[1] = '\0';
			if (fundefined(sbuf))
				printf("\t%.9g", funvalue(sbuf, 1, &x));
			else
				break;
		}
		printf("\n");
	}
	quit(0);

userror:
	fprintf(stderr, "Usage: %s xmin xmax ", argv[0]);
	fprintf(stderr, "[-n npts][-x][-i] [-f file | 'funcs']\n");
	quit(1);
}


eputs(msg)
char  *msg;
{
	fputs(msg, stderr);
}


quit(code)
int  code;
{
	exit(code);
}
