/* shaftculling.h */

#ifndef _SHAFTCULLING_H_
#define _SHAFTCULLING_H_

/*
 * Shaft culling ala Haines, E. A. and Wallace, J. R. "Shaft culling for
 *		     efficient ray-traced radiosity", 2nd Eurographics Workshop
 *		     on Rendering, Barcelona, Spain, may 1991
 */

#include "bounds.h"
#include "geomlist.h"
#include "patchlist.h"

typedef struct SHAFTPLANE {
	float	n[3], d;
	int	coord_offset[3];	/* coord. offset for nearest corner in box-plane tests */
} SHAFTPLANE;

typedef struct SHAFT {
	float		*ref1, *ref2, extent[6];
	SHAFTPLANE	plane[8];	/* max. 8 planes in plane-set */
	int             planes;		/* nr of planes in plane-set */
	GEOM		*omit[2];	/* geometries to be ignored during shaftculling */
	int		nromit;		/* nr of geometries to be ignored */
} SHAFT;

/* constructs a shaft for two given bounding boxes */
extern SHAFT *ConstructShaft(float *ref1, float *ref2, SHAFT *shaft);

/* adds all objects from world that overlap or lay inside the shaft to
 * candlist, returns the new candidate list */
extern GEOMLIST *DoShaftCulling(GEOMLIST *world, SHAFT *shaft, GEOMLIST *candlist);

/* shaftculling for patch lists */
extern PATCHLIST *ShaftCullPatchlist(PATCHLIST *pl, SHAFT *shaft, PATCHLIST *culledpatchlist);

/* marks a geometry as to be omitted during shaftculling: it will not be added to the
 * candidatelist, even if the geometry overlaps or is inside the shaft */
extern void ShaftOmit(SHAFT *shaft, GEOM *geom);

/* frees the memory occupied by a candidatelist produced by DoShaftCulling */
extern void FreeCandidateList(GEOMLIST *candlist);

#endif /*_SHAFTCULLING_H_*/
