/* jacobian.c */

#include "jacobian.h"
#include "Memory.h"

#ifndef NULL
#define NULL 0
#endif /*NULL*/

#ifdef BETTER_MEMMAN
static STORAGE *jacobianStor = (STORAGE *)NULL;
#define NEWJACOBIAN()  	(JACOBIAN *)New(sizeof(JACOBIAN), &jacobianStor)
#define DISPOSEJACOBIAN(ptr) Dispose((unsigned char *)(ptr), &jacobianStor)
#else /*BETTER_MEMMAN*/
#define NEWJACOBIAN()	(JACOBIAN *)Alloc(sizeof(JACOBIAN))
#define DISPOSEJACOBIAN(ptr) Free((char *)ptr, sizeof(JACOBIAN))
#endif /*BETTER_MEMMAN*/

JACOBIAN *JacobianCreate(float A, float B, float C)
{
	JACOBIAN *jacobian = (JACOBIAN *)NULL;

	jacobian = NEWJACOBIAN();
	jacobian->A = A;
	jacobian->B = B;
	jacobian->C = C;

	return jacobian;
}

void JacobianDestroy(JACOBIAN *jacobian)
{
	DISPOSEJACOBIAN(jacobian);
}

