/* coefficients.h: some macros for handling sets of radiance... coefficients */

#ifndef _COEFFICIENTS_H_
#define _COEFFICIENTS_H_

#include "color.h"
#include "basis.h"

#define CLEARCOEFFICIENTS(coeff, howmany)	{		\
	int i; 							\
	for (i=0; i<howmany; i++) { 				\
                COLORSET((coeff)[i], 0., 0., 0.); 		\
        }							\
}

#define PRINTCOEFFICIENTS(out, coeff, howmany)	{		\
        int i; 							\
        for (i=0; i<howmany; i++) {				\
                if (i>0) fprintf(out, ", "); 			\
                COLORPrint(out, (coeff)[i]);			\
        }							\
}

/* determines the "largest" coefficient. */
#define MAXCOEFFICIENT(coeff, max, howmany) {			\
        int i; Float sumabsmax;					\
	(max) = (coeff)[0];					\
        sumabsmax = COLORSUMABSCOMPONENTS(max);			\
        for (i=1; i<howmany; i++) {				\
		if (COLORSUMABSCOMPONENTS((coeff)[i]) > sumabsmax) {\
			(max) = (coeff)[i];			\
			sumabsmax = COLORSUMABSCOMPONENTS(max);	\
		}						\
        }							\
}

#endif /*_COEFFICIENTS_H_*/
