/*
   File: global.hh

*/

#ifdef __GNUG__
#pragma interface
#endif

#ifndef GLOBAL
#define EXTERN extern
#else
#define EXTERN
#endif

EXTERN LayerData *ld;   // ld = Layer Data
EXTERN VideoStream* vs;  // vs = Video Stream

/* getvlc.c */
int getMBtype (void);
int getMV (void);
int getDMV (void);
int getCBP (void);
int getMBA (void);
int getDClum (void);
int getDCchrom (void);

/* spatscal.c */
void getspatref(void);

#ifdef TRACE     // trace output
inline void printbits(int code, int bits, int len){
  for (int i=0; i<len; i++) printf("%d",(code>>(bits-1-i))&1);
}
#endif

/* global variables */

EXTERN char version[]
#ifdef GLOBAL
  ="video, 96/02/20"
#endif
;

EXTERN char author[]
#ifdef GLOBAL
  ="1996, Alex Theo de Jong & MPEG Software Simulation Group"
#endif
;

/* zig-zag scan */
EXTERN unsigned char zig_zag_scan[64]
#ifdef GLOBAL
=
{
#ifdef HAVE_MMX
    0*8+0/* 0*/, 1*8+0/* 1*/, 0*8+1/* 8*/, 0*8+2/*16*/, 1*8+1/* 9*/, 2*8+0/* 2*/, 3*8+0/* 3*/, 2*8+1/*10*/,
    1*8+2/*17*/, 0*8+3/*24*/, 0*8+4/*32*/, 1*8+3/*25*/, 2*8+2/*18*/, 3*8+1/*11*/, 4*8+0/* 4*/, 5*8+0/* 5*/,
    4*8+1/*12*/, 5*8+2/*19*/, 2*8+3/*26*/, 1*8+4/*33*/, 0*8+5/*40*/, 0*8+6/*48*/, 1*8+5/*41*/, 2*8+4/*34*/,
    3*8+3/*27*/, 4*8+2/*20*/, 5*8+1/*13*/, 6*8+0/* 6*/, 7*8+0/* 7*/, 6*8+1/*14*/, 5*8+2/*21*/, 4*8+3/*28*/,
    3*8+4/*35*/, 2*8+5/*42*/, 1*8+6/*49*/, 0*8+7/*56*/, 1*8+7/*57*/, 2*8+6/*50*/, 3*8+5/*43*/, 4*8+4/*36*/,
    5*8+3/*29*/, 6*8+2/*22*/, 7*8+1/*15*/, 7*8+2/*23*/, 6*8+3/*30*/, 5*8+4/*37*/, 4*8+5/*44*/, 3*8+6/*51*/,
    2*8+7/*58*/, 3*8+7/*59*/, 4*8+6/*52*/, 5*8+5/*45*/, 6*8+4/*38*/, 7*8+3/*31*/, 7*8+4/*39*/, 6*8+5/*46*/,
    7*8+6/*53*/, 4*8+7/*60*/, 5*8+7/*61*/, 6*8+6/*54*/, 7*8+5/*47*/, 7*8+6/*55*/, 6*8+7/*62*/, 7*8+7/*63*/
#else
  0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,
  12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,
  35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,
  58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63
#endif
}
#endif
;

/* alternate scan */
EXTERN unsigned char alternate_scan[64]
#ifdef GLOBAL
=
{
#ifdef HAVE_MMX
     0*8+0/*0 */, 0*8+1/* 8*/, 0*8+2/*16*/, 0*8+3/*24*/, 1*8+0/* 1*/, 1*8+1/* 9*/, 2*8+0/* 2*/, 2*8+1/*10*/,
     1*8+2/*17*/, 1*8+3/*25*/, 0*8+4/*32*/, 0*8+5/*40*/, 0*8+6/*48*/, 0*8+7/*56*/, 1*8+7/*57*/, 1*8+6/*49*/,
     1*8+5/*41*/, 1*8+4/*33*/, 2*8+3/*26*/, 2*8+2/*18*/, 3*8+0/* 3*/, 3*8+1/*11*/, 4*8+0/* 4*/, 4*8+1/*12*/,
     3*8+2/*19*/, 3*8+3/*27*/, 2*8+4/*34*/, 2*8+5/*42*/, 2*8+6/*50*/, 2*8+7/*58*/, 3*8+4/*35*/, 3*8+5/*43*/,
     3*8+6/*51*/, 3*8+7/*59*/, 4*8+2/*20*/, 4*8+3/*28*/, 5*8+0/* 5*/, 5*8+1/*13*/, 6*8+0/* 6*/, 6*8+1/*14*/,
     5*8+2/*21*/, 5*8+3/*29*/, 4*8+4/*36*/, 4*8+5/*44*/, 4*8+6/*52*/, 4*8+7/*60*/, 5*8+4/*37*/, 5*8+5/*45*/,
     5*8+6/*53*/, 5*8+7/*61*/, 6*8+2/*22*/, 6*8+3/*30*/, 7*8+0/* 7*/, 7*8+1/*15*/, 7*8+2/*23*/, 7*8+3/*31*/,
     6*8+4/*38*/, 6*8+5/*46*/, 6*8+6/*54*/, 6*8+7/*62*/, 7*8+4/*39*/, 7*8+5/*47*/, 7*8+6/*55*/, 7*8+6/*63*/
#else
  0,8,16,24,1,9,2,10,17,25,32,40,48,56,57,49,
  41,33,26,18,3,11,4,12,19,27,34,42,50,58,35,43,
  51,59,20,28,5,13,6,14,21,29,36,44,52,60,37,45,
  53,61,22,30,7,15,23,31,38,46,54,62,39,47,55,63
#endif
}
#endif
;

/* default intra quantization matrix */
EXTERN unsigned char default_intra_quantizer_matrix[64]
#ifdef GLOBAL
=
{
  8, 16, 19, 22, 26, 27, 29, 34,
  16, 16, 22, 24, 27, 29, 34, 37,
  19, 22, 26, 27, 29, 34, 34, 38,
  22, 22, 26, 27, 29, 34, 37, 40,
  22, 26, 27, 29, 32, 35, 40, 48,
  26, 27, 29, 32, 35, 40, 48, 58,
  26, 27, 29, 34, 38, 46, 56, 69,
  27, 29, 35, 38, 46, 56, 69, 83
}
#endif
;

/* non-linear quantization coefficient table */
EXTERN unsigned char non_linear_mquant_table[32]
#ifdef GLOBAL
=
{
   0, 1, 2, 3, 4, 5, 6, 7,
   8,10,12,14,16,18,20,22,
  24,28,32,36,40,44,48,52,
  56,64,72,80,88,96,104,112
}
#endif
;

/* color space conversion coefficients
 *
 * entries are {crv,cbu,cgu,cgv}
 *
 * crv=(255/224)*65536*(1-cr)/0.5
 * cbu=(255/224)*65536*(1-cb)/0.5
 * cgu=(255/224)*65536*(cb/cg)*(1-cb)/0.5
 * cgv=(255/224)*65536*(cr/cg)*(1-cr)/0.5
 *
 * where Y=cr*R+cg*G+cb*B (cr+cg+cb=1)
 */

EXTERN int convmat[8][4]
#ifdef GLOBAL
=
{
  {117504, 138453, 13954, 34903}, /* no sequence_display_extension */
  {117504, 138453, 13954, 34903}, /* ITU-R Rec. 709 (1990) */
  {104597, 132201, 25675, 53279}, /* unspecified */
  {104597, 132201, 25675, 53279}, /* reserved */
  {104448, 132798, 24759, 53109}, /* FCC */
  {104597, 132201, 25675, 53279}, /* ITU-R Rec. 624-4 System B, G */
  {104597, 132201, 25675, 53279}, /* SMPTE 170M */
  {117579, 136230, 16907, 35559}  /* SMPTE 240M (1987) */
}
#endif
;

EXTERN int quiet;
#ifdef TRACE
EXTERN int trace;
#endif
EXTERN char errortext[256];
EXTERN unsigned char *refframe[3],*oldrefframe[3],*auxframe[3],*newframe[3];
EXTERN int horizontal_size,vertical_size,mb_width,mb_height;
EXTERN int coded_picture_width, coded_picture_height;
EXTERN int chroma_format,chrom_width,chrom_height,blk_cnt;
EXTERN int pict_type;
EXTERN int forw_r_size,back_r_size;
EXTERN int full_forw,full_back;
EXTERN int fault;
EXTERN int verbose;
EXTERN int prog_seq;
EXTERN int h_forw_r_size,v_forw_r_size,h_back_r_size,v_back_r_size;
EXTERN int dc_prec,pict_struct,topfirst,frame_pred_dct,conceal_mv;
EXTERN int intravlc,repeatfirst,prog_frame;
EXTERN int secondfield;
EXTERN int stwc_table_index,llw,llh,hm,hn,vm,vn;
EXTERN int lltempref,llx0,lly0,llprog_frame,llfieldsel;
EXTERN unsigned char *llframe0[3],*llframe1[3];
EXTERN short *lltmp;
EXTERN char *llinputname;
// EXTERN int twostreams 
EXTERN int sflag;
EXTERN int matrix_coefficients;
EXTERN int framerate;
EXTERN int playedlastframe;
