/*
 * file:     cursors.c
 * author:   Wes Barris
 * date:     2/25/92
 * purpose:  creates a couple cursors
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include <X11/cursorfont.h>

extern ICOP		icop;

void
BusyCursorCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	*call_data;
{
   static Cursor busyCursor = (Cursor) 0;    
/*
 * Make a busy cursor.
 */
   if (busyCursor == (Cursor) 0) {
      XColor colors[2];

      colors[0].pixel = 1;
      colors[1].pixel = 0;
      XQueryColors(XtDisplay(icop.toplevel),
                   DefaultColormap(XtDisplay(icop.toplevel),
                   DefaultScreen(XtDisplay(icop.toplevel))), colors, 2);
      busyCursor = XCreateFontCursor(XtDisplay(icop.toplevel), XC_watch);
      XRecolorCursor(XtDisplay(icop.toplevel), busyCursor,
                     &colors[0], &colors[1]);
      }
   XDefineCursor(XtDisplay(icop.toplevel), XtWindow(icop.toplevel), busyCursor);
   XFlush(XtDisplay(icop.toplevel));
   return;
}


void
UnBusyCursorCB(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	*call_data;
{
   static Cursor unBusyCursor = (Cursor) 0;

   if (unBusyCursor == (Cursor) 0) {
      XColor colors[2];

      colors[0].pixel = 1;
      colors[1].pixel = 0;
      XQueryColors(XtDisplay(icop.toplevel),
                   DefaultColormap(XtDisplay(icop.toplevel),
                   DefaultScreen(XtDisplay(icop.toplevel))), colors, 2);
      unBusyCursor = XCreateFontCursor(XtDisplay(icop.toplevel), XC_left_ptr);
      XRecolorCursor(XtDisplay(icop.toplevel), unBusyCursor,
                     &colors[0], &colors[1]);
      }
   XDefineCursor(XtDisplay(icop.toplevel), XtWindow(icop.toplevel),
                 unBusyCursor);
   XFlush(XtDisplay(icop.toplevel));
   return;
}
