/*
 * file:     prefMenu.c
 * author:   Wes Barris
 * date:     6/10/92
 * purpose:  creates Pref menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <X11/StringDefs.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>

extern DESI	desi;

extern void	BackPopup();
extern void	GridPopup();

static struct {
	char		*name;			/* name of menu item widget */
	void		(*callbackFcn)();	/* callback function */
	} list[] = {
		{ "back",	BackPopup},
		{ "grid",	GridPopup},
		};

void
PrefMenuInit(parent)
Widget	parent;
{
   int		i, n;
   Arg		arg[10];
   Widget	prefMenu,
		w;
/*
 * Create the pulldown menu.
 */
   n = 0;
   prefMenu = XmCreatePulldownMenu(parent, "prefMenu", arg, n);
/*
 * Create its menu items.
 */
   for (i = 0; i < XtNumber(list); i++) {
      w = XmCreatePushButton(prefMenu, list[i].name, arg, 0);
      XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)list[i].callbackFcn, NULL);
      XtManageChild(w);
      }
/*
 * Create the Pref cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, prefMenu); n++;
   w = XmCreateCascadeButton(parent, "pref", arg, n);
   XtManageChild(w);
} /* PrefMenuInit */
