/*
 * file:     centerMenu.c
 * author:   Wes Barris
 * date:     3/2/92
 * purpose:  creates Center pull-right menu
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <X11/StringDefs.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Separator.h>
#include "SelfM/SelfM.h"
#include "Umsc/List.h"

extern DESI	desi;
/*extern LlTd	theList;*/
extern UmscList	theList;

static void
CenterCB(w, alignment)
Widget	w;
caddr_t	alignment;
{
   Arg		args[3];
   GenericInfo	*thisObject;
   int		i, n;
/*
 * Are there any selected text objects?
 */
   /*thisObject = LlSetCurrent(theList, LlSET_FIRST);*/
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (i=0; i<UmscListGetCount(theList); i++) {
      if (thisObject->selected == True) {
/*
 * Allignment needs to be set on only the first one.
 */
         if (!strcmp(XtName(w),"horizontal")) {
            thisObject->x = desi.back.xoffset
                          + ((int)desi.back.width - (int)thisObject->width)/2;
            n = 0;
            XtSetArg(args[n], XtNxChild, (Dimension)thisObject->x); n++;
            XtSetValues(XtParent(thisObject->w), args, n);
            }
         else if (!strcmp(XtName(w),"vertical")) {
            thisObject->y = desi.back.yoffset
                          + ((int)desi.back.height - (int)thisObject->height)/2;
            n = 0;
            XtSetArg(args[n], XtNyChild, (Dimension)thisObject->y); n++;
            XtSetValues(XtParent(thisObject->w), args, n);
            }
         }
      thisObject = UmscListGetNext(theList);
      /*thisObject = LlNextObj(theList);*/
      }
}

static struct {
	char	*name;			/* name of menu item widget */
	void	(*func)();		/* callback function */
	caddr_t	data;			/* client data */
	} items[] = {
		{ "horizontal",	CenterCB,	(caddr_t)HrALIGN_CENTER},
		{ "vertical",	CenterCB,	(caddr_t)HrALIGN_CENTER_VERTICAL},
		};

void
CenterMenuInit(Widget parent)
{
   int	i,
		n;
   Arg		arg[10];
   Widget	centerMenu,
		w;
/*
 * Create the Center menu.
 */
   n = 0;
   centerMenu = XmCreatePulldownMenu(parent, "centerMenu", arg, n);
/*
 * Create the entries for the center menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreatePushButton(centerMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].func, items[i].data);
         }
      else 
         w = XmCreateSeparator(centerMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Create the Center cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, centerMenu); n++;
   w = XmCreateCascadeButton(parent, "center", arg, n);
   XtManageChild(w);
}
