/*
 * file:     bboard.c
 * author:   Wes Barris
 * date:     2/25/92
 * purpose:  creates main window, a Bulletin Board
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

extern void	daResizeCB();

Widget
BBoardInit(parent, neighbor)
Widget	parent, neighbor;
{
   Arg		args[10];
   Widget	bboard;
   int		n;

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, neighbor); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   bboard = XmCreateDrawingArea(parent, "bboard", args, n);
   XtAddCallback(bboard, XmNresizeCallback, daResizeCB, NULL);
   XtManageChild(bboard);
   return bboard;
}
