/*
 *      File:	Misc.h
 *    Module:	libUmsc.a
 *      Date:	08/24/92
 *    Author:	Daniel B. Waylonis (danw@msc.edu)
 *   Purpose:	Headerfile for Misc.c
 *
 *   Copyright @ 1992 by Research Equipment Inc. (dba)
 *   Minnesota Supercomputer Center, Inc.
 *
 *   Proprietary Information of Minnesota Supercomputer Center, Inc. -
 *   DO NOT DISCLOSE
 *
 * RESTRICTED RIGHTS LEGEND
 *   Use, duplication, or disclosure of this software and its documentation
 *   by the Government is subject to restrictions as set forth in subdivision
 *   { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 *   clause at 52.227-7013.
 *
 * $Log: Misc.h,v $
 * Revision 1.2  1993/01/20  20:40:57  danw
 * Added some macros.
 *
 * Revision 1.1  1992/12/02  17:35:49  danw
 * Initial revision
 *
 * 
 */

#ifndef _Umsc_Misc_H
#define _Umsc_Misc_H
/*-------------------------------------------------------------------------*/
/* includes */

#include <Umsc/ProtoMacro.h>

/* macros */

/* create a new CLEARED data structure -- good for structures that rely on */
/* a newly created structure to be NULL */
#define UmscNew(type) (type *)calloc(1, sizeof(type))

/* Return the minimum of two values */
#define UmscMin(a,b) ((a) < (b) ? (a) : (b))

/* Return the Maximum of two values */
#define UmscMax(a,b) ((a) > (b) ? (a) : (b))

/* return the absolute value of two values */
#define UmscAbs(a) ((a) < 0 ? -(a) : (a))

/* square a number */
#define UmscSqr(a) ((a) * (a))

/* copy of XtNewString for non-X programs */
#define UmscNewString(str) \
    ((str) != NULL ? (strcpy(malloc((unsigned)strlen(str) + 1), str)) : NULL)

/*-------------------------------------------------------------------------*/
/* Prototypes */

UmscProtoBegin

char*	UmscPathToFilename _((char *));
char*	UmscSizeToString _((long));

UmscProtoEnd

/*-------------------------------------------------------------------------*/
#endif 
