/*
 * file:     prefMenu.c
 * author:   Wes Barris
 * date:     10/19/93
 * purpose:  creates Pref menu
 *
 * copyright info:
 *
 *    @Copyright 1993
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>

extern ICOP	icop;
extern int	haveplot;

Widget		standard[2];

static void
StandardCB(Widget w, XtPointer client_data, char *call_data)
{
   if (!((XmToggleButtonCallbackStruct *)call_data)->set)
      return;
   haveplot = 0;
   DrawPlotCB(icop.plot.w, (XtPointer)NULL, (char *)NULL);
   FillImageBuffs();
   ShowImageCB(icop.image.w, (XtPointer)NULL, (char *)NULL);
}

static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)(Widget, XtPointer, char*);      /* callback function */
   } list[] = {
      { "ntsc",	StandardCB},
      { "pal",	StandardCB},
      };

void
PrefMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	prefMenu, w;
/*
 * Create pulldown menu.
 */
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   prefMenu = XmCreatePulldownMenu(parent, "prefMenu", arg, n);
/*
 * Create the entries for the pref menu.
 */
   for (i = 0; i < XtNumber(list); i++) {
      if (list[i].name != NULL) {
         standard[i] = XmCreateToggleButton(prefMenu, list[i].name, arg, 0);
         XtAddCallback(standard[i], XmNvalueChangedCallback, (XtCallbackProc)list[i].func, list[i].name);
         }
      else 
         standard[i] = XmCreateSeparator(prefMenu, "sep", arg, 0);
      XtManageChild(standard[i]);
      }
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, prefMenu); n++;
   w = XmCreateCascadeButton(parent, "pref", arg, n);
   XtManageChild(w);
}
