/*
 * file:     info.c
 * author:   Wes Barris
 * date:     10/15/93
 * purpose:  creates the info panel for icop
 *
 * copyright info:
 *
 *                           @Copyright 1993
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include "Icop.xpm"

extern ICOP	icop;
Widget		infoLabel;
static Widget	aboutPanel;

/*
 * InitIcon:  creates a icop pixmap.
 */
void
InitIcon(void)
{
   Arg		args[1];
   XImage	*image;
   XColor	*colors;
   XVisualInfo	vTemplate, *visualList;
   int		visualsMatched;
   int		x,y,i,n;
   char		*data;
/*
 * First find an 8 bit pseudocolor visual.
 */
   vTemplate.screen = DefaultScreen(XtDisplay(icop.toplevel));
   vTemplate.depth  = 8;
   vTemplate.class  = PseudoColor;
   visualList = XGetVisualInfo(XtDisplay(icop.toplevel),
                VisualScreenMask | VisualDepthMask | VisualClassMask,
                &vTemplate, &visualsMatched);
   if (visualsMatched == 0) {
      fprintf(stderr, "I can't find an 8 bit color mapped visual.\n");
      exit(1);
      }
/*
 * Paul's icon code to show my Desi picture.
 */
   image = XCreateImage(XtDisplay(icop.toplevel),
                        visualList[0].visual,
                        vTemplate.depth,
                        ZPixmap,
                        0,
                        NULL,
                        icop_width,
                        icop_height,
                        vTemplate.depth,
                        0);
   XFree((char *)visualList);

   image->data = (char *)XtMalloc(icop_width*icop_height);
   colors = (XColor *)XtMalloc(sizeof(XColor)*icop_ncolors);

   for (i=0; i<icop_ncolors; i++) {
      XParseColor(XtDisplay(icop.toplevel),
                  DefaultColormapOfScreen(XtScreen(icop.toplevel)),
                  icop_colors[i*2+1],&colors[i]);
      XAllocColor(XtDisplay(icop.toplevel),
                  DefaultColormapOfScreen(XtScreen(icop.toplevel)),
                  &colors[i]);
      }
   for (y=0; y<icop_height; y++) {
      data = icop_pixels[y];
      for (x=0; x<icop_width; x++)
         for (i=0; i<icop_ncolors; i++)
            if (strncmp(data, icop_colors[i*2], icop_chars_per_pixel) == 0) {
               XPutPixel(image,x,y,colors[i].pixel);
               data += icop_chars_per_pixel;
               break;
               }
      }
   if (!XmInstallImage(image,"icopIcon"))
      fprintf(stderr, "Could not install icop icon image.\n");
}

void
LabelSetString(char *str)
{
   Arg	arg;
   XmString	xmstr;

   xmstr = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
   XtSetArg(arg, XmNlabelString, xmstr);
   XtSetValues(infoLabel, &arg, 1);
   XmStringFree(xmstr);
}


static void
AboutInit(void)
{
   int          n;
   Arg          args[10];
/*
 * Create the panel.
 */
   n = 0;
   aboutPanel = XmCreateInformationDialog(icop.toplevel, "aboutPanel", args, n);
   XtUnmanageChild(XmMessageBoxGetChild(aboutPanel, XmDIALOG_CANCEL_BUTTON));
   XtUnmanageChild(XmMessageBoxGetChild(aboutPanel, XmDIALOG_HELP_BUTTON));
   /*XtAddCallback(aboutPanel, XmNhelpCallback, XtUnmanageChild, aboutPanel);*/
   /*XtAddCallback(aboutPanel, XmNhelpCallback, XtUnmanageChild, NULL);*/
   /*XtAddCallback(aboutPanel, XmNhelpCallback, MailCB, NULL);*/
}



/*
 * Display the about panel.
 */
static void
AboutCB(Widget w, XtPointer client_data, char *call_data)
{
   if (aboutPanel == NULL)
      AboutInit();
   XtManageChild(aboutPanel);
}


Widget
InfoInit(parent, neighbor)
Widget	parent, neighbor;
{
   Arg		args[10];
   Widget	info, b1, f1;
   int		n;

   InitIcon();
   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, neighbor); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   f1 = XtCreateManagedWidget("f1", xmFrameWidgetClass, parent, args, n);

   n = 0;
   info = XtCreateManagedWidget("info", xmFormWidgetClass, f1, args, n);

   n = 0;
   XtSetArg(args[n], XmNwidth, icop_width); n++;
   XtSetArg(args[n], XmNheight, icop_height); n++;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   b1 = XtCreateManagedWidget("b1", xmPushButtonWidgetClass, info, args, n);
   XtAddCallback(b1, XmNactivateCallback, (XtCallbackProc)AboutCB, NULL);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   infoLabel = XtCreateManagedWidget("l1", xmLabelWidgetClass, info, args, n);

   return f1;
}
