#include <stdio.h>
#include "config.h"
#include "unixlib.h"

#if defined(ATARI_ST)
#include <string.h>
#include <ext.h>

#elif defined (SUN) || defined(MSDOS) || defined(SEQUENT386) || defined(AVIION)
#include <sys/types.h>
#include <sys/stat.h>

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif

#include "portab.h"
#include "picstat.h"


typedef struct
{
  LONG r_magic;
  LONG r_width;
  LONG r_height;
  LONG r_depth;
  LONG r_length;
  LONG r_type;
  LONG r_maptype;
  LONG r_maplength;
} RASTERBUF;

#define RMT_NONE      (0L)       /* ras_maplength is expected to be 0 */
#define RMT_EQUAL_RGB (1L)     /* red[ras_maplength/3],green[],blue[] */
#define RMT_RAW       (2L)

typedef struct
{
  UBYTE c_col[3*256];
} RASTERCMAP;

/*
 *  return stats of a Sun Rasterfile
 */

int rasterstat (name, buf, mode)
 char *name;
 struct picstat *buf;
 int mode;

{
  int ret;
  struct stat sbuf;
  FILE *fp;
  UWORD length;
  unsigned long llength;
  RASTERBUF rasterbuf;
  RASTERCMAP rastercmap;
  int i, j;
  int ncols;
  UBYTE *col;

  if (mode)
    ret = lstat (name, &sbuf);
  else
    ret = stat (name, &sbuf);
  if (ret)
    return (-1);
  fp = fopen (name, "rb");
  if (fp == NULL)
    {
      return (-1);
    }
  if (sizeof(rasterbuf) != fread (&rasterbuf, 1L, sizeof(rasterbuf),
                                  fp))
    {
      fclose (fp);
      return (-1);
    }
  if (rasterbuf.r_magic != 0x59a66a95)
    {
      fclose (fp);
      return (-1);
    }
  if (sizeof(rastercmap) != fread (&rastercmap, 1L, sizeof(rastercmap),
                                   fp))
    {
      fclose (fp);
      return (-1);
    }
  if (fclose (fp))
    {
      return (-1);
    }
  buf->p_fsize = sbuf.st_size;
  buf->p_sizex = NSWAP4(rasterbuf.r_width);
  buf->p_sizey = NSWAP4(rasterbuf.r_height);
  buf->p_colrez =  NSWAP4(rasterbuf.r_depth);
  ncols = NSWAP4(rasterbuf.r_maplength)/3;
  col = rastercmap.c_col;
  for (buf->p_coltype=CT_BW, i=0; i < buf->p_ncol; i++)
    {
        if (NSWAP4(rasterbuf.r_maptype) == RMT_NONE)
          {
            buf->p_coltype = CT_UNKNOWN;
            break;
          }
        else if (NSWAP4(rasterbuf.r_maptype) ==  RMT_EQUAL_RGB)
          {
            if ( !((col[i] == col[i+ncols]) &&
                   (col[i+ncols] == col[i+2*ncols])) )
              {
                buf->p_coltype = CT_COLOR;
                break;
              }
          }
        else if (NSWAP4(rasterbuf.r_maptype) ==  RMT_RAW)
          {
            if ( !((col[3*i] == col[3*i+1]) &&
                   (col[3*i+1] == col[3*i+2])) )
              {
                buf->p_coltype = CT_COLOR;
                break;
              }
          }
        else
          {
/*
            error
*/
          }
          
      }
  if (buf->p_coltype == CT_COLOR)
    {
      buf->p_colrez *= 3;
    }
  buf->p_ncol = ncols;
  for (i=0; i < ncols; i++)
    {
      for (j=0; j < i; j++)
        {
          if (NSWAP4(rasterbuf.r_maptype) == RMT_NONE)
            {
              break;
            }
          else if (NSWAP4(rasterbuf.r_maptype) ==  RMT_EQUAL_RGB)
            {
              if ((col[i] == col[j]) &&
                  (col[i+ncols] == col[j+ncols]) &&
                  (col[i+2*ncols] == col[j+2*ncols]))
                {
                  col[j] = col[0];
                  col[j+ncols] = col[ncols];
                  col[j+2*ncols] = col[2*ncols];
                  buf->p_ncol--;
                  break;
                }
            }
          else if (NSWAP4(rasterbuf.r_maptype) ==  RMT_RAW)
            {
              if ((col[3*i] == col[3*j]) &&
                  (col[3*i+1] == col[3*j+1]) &&
                  (col[3*i+2] == col[3*j+2]))
                {
                  col[3*j] = col[0];
                  col[3*j+1] = col[1];
                  col[3*j+2] = col[2];
                  buf->p_ncol--;
                  break;
                }
            }
          else
            {
/*
              error
*/
            }
        }
    }
  if (buf->p_ncol >= 1<<buf->p_colrez)
    {
      buf->p_ncol = 1<<buf->p_colrez;
    }
  buf->p_nframes = 1;
  buf->p_speed = 0;
  strcpy (buf->p_type, "SunRas");
  return (0);
}
