/*
 *  CONFIG.H
 *     - Follow the instructions after every 'CONFIG' to set the sources
 *       to your system configuration.
 */


#ifndef CONFIG_H
#define CONFIG_H


/*
 *  CONFIG: configure your machine type. If you have a sun3 or sun4 and
 *          run SunOS, define SUN. If you have an atari st or ste and
 *          run TOS, define ATARI_ST. If you run MSDOS, define MSDOS.
 *          if you run UN?X on Sequent386 or on Aviion then define
 *          SEQUENT386 or AVIION respectively. Sorry, no other
 *          architectures yet.
 */

#undef ATARI_ST
#undef MSDOS
#define SUN
#undef SEQUENT386
#undef AVIION


/*
 *  CONFIG: End of system dependent configurations.
 *          Warning: Do not change anything below this line!
 */

#if defined(ATARI_ST)
#define MACHINE "ST"

#elif defined(MSDOS)
#define MACHINE "MSDOS"

#elif defined(SUN)
#define MACHINE "sun"

#elif defined(SEQUENT386)
#define MACHINE "sequent386"

#elif defined(AVIION)
#define MACHINE "DG Aviion"

#else
#error Wrong machine type. Edit config.h and follow the instructions.

#endif /*  */


#endif /* CONFIG_H */
