/**
 *
 * $Id: DragDrop.c,v 1.2 1997/03/12 01:31:46 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: DragDrop.c,v 1.2 1997/03/12 01:31:46 miers Exp $";

#include <LTconfig.h>
#include <XmI/XmI.h>
#include <XmI/MacrosI.h>

#include <Xm/XmP.h>
#include <Xm/DragCP.h>
#include <Xm/DragDrop.h>
#include <XmI/DragDropI.h>
#include <Xm/DropTransP.h>
#include <Xm/DisplayP.h>
#include <Xm/DropSMgrP.h>

#include <XmI/DebugUtil.h>

/*************************** DragC functions *****************************/

Widget 
XmDragStart(Widget widget, 
	    XEvent *event, 
	    ArgList arglist, 
	    Cardinal argcount)
{
    Widget dc;
    Widget disp = XmGetXmDisplay(XtDisplay(widget));
    Arg arg[1];
    ArgList merged;

    XdbDebug(__FILE__, widget, "XmDragStart()\n");

    /* appears in a dump of DragC's resources, but isn't documented. */
    XtSetArg(arg[0], XmNsourceWidget, widget);

    if (arglist)
	merged = XtMergeArgLists(arglist, argcount, arg, 1);
    else
	merged = arglist;

    dc = XtCreateWidget("drag_context",
			Display_DragContextClass(disp), disp,
			merged, argcount + 1);
    
    if (arglist)
	XtFree((char *)merged);

    _XmDragStart((XmDragContext)dc, widget, event);

    return dc;
}

void 
XmDragCancel(Widget dragcontext)
{
    _XmDragCancel((XmDragContext)dragcontext);
}

Boolean
XmTargetsAreCompatible(Display *dpy,
		       Atom *exportTargets, Cardinal numExportTargets,
		       Atom *importTargets, Cardinal numImportTargets)
{
    int i, j;

    /* if ANY import targets matches any export target, they're compat */
    for (i = 0; i < numExportTargets; i++) {
	for (j = 0; j < numImportTargets; j++) {
	    if (exportTargets[i] == importTargets[j])
		return True;
	}
    }

    return False;
}

/*************************** DropSMgr functions *****************************/

void 
XmDropSiteConfigureStackingOrder(Widget widget, 
				 Widget Sibling, 
				 Cardinal stack_mode)
{
    /* FIXME */
}

void 
XmDropSiteEndUpdate(Widget widget)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));

    DSMEndUpdate(_XmGetDropSiteManagerObject((XmDisplay)disp), widget);
}

Status 
XmDropSiteQueryStackingOrder(Widget widget, 
			     Widget *parent_return, 
			     Widget **child_returns, 
			     Cardinal *num_child_returns)
{
    /* FIXME */

    return 0;
}

void 
XmDropSiteRegister(Widget widget, 
		   ArgList arglist, 
		   Cardinal argcount)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));

    DSMCreateInfo(_XmGetDropSiteManagerObject((XmDisplay)disp),
		  widget, arglist, argcount);
}

void 
XmDropSiteRetrieve(Widget widget, 
		   ArgList arglist, 
		   Cardinal argcount)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));

    DSMRetrieveInfo(_XmGetDropSiteManagerObject((XmDisplay)disp),
		    widget, arglist, argcount);
}

void 
XmDropSiteStartUpdate(Widget widget)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));

    DSMStartUpdate(_XmGetDropSiteManagerObject((XmDisplay)disp), widget);
}

void 
XmDropSiteUnregister(Widget widget)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));

    DSMDestroyInfo(_XmGetDropSiteManagerObject((XmDisplay)disp), widget);
}

void 
XmDropSiteUpdate(Widget widget, 
		 ArgList arglist, 
		 Cardinal argcount)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));

    DSMUpdateInfo(_XmGetDropSiteManagerObject((XmDisplay)disp),
		  widget, arglist, argcount);
}

XmDropSiteVisuals
XmDropSiteGetActiveVisuals(Widget widget)
{
    /* FIXME */

    return NULL;
}

/*************************** DropTrans functions *****************************/

void 
XmDropTransferAdd(Widget drop_transfer, 
		  XmDropTransferEntryRec *transfers, 
		  Cardinal num_transfers)
{
    DTC_AddTransferProc(XtClass(drop_transfer))(drop_transfer,
						transfers,
						num_transfers);
}

Widget 
XmDropTransferStart(Widget widget, 
		    ArgList arglist, 
		    Cardinal argcount)
{
    Widget disp = XmGetXmDisplay(XtDisplay(widget));
    
    return DTC_StartTransferProc(Display_DropTransferClass(disp))(widget,
								  arglist,
								  argcount);
}

