/* OS/2 REXX */
/*
# Generated by Hand (Michael Holzapfel May 1996)
#
# configure for the GNU Lesstif OS/2 shared libraries
#
# Copyright (C) 1995 Free Software Foundation, Inc.
#
# This file is part of the GNU LessTif Library.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
Written by:
Michael Holzapfel

--------------------------------------------------------
Institut fuer Maschinenelemente und Maschinengestaltung
RWTH-Aachen

Tel.   0049-(0)-241-805661
Fax    0049-(0)-241-8888256
Email  michael@ime.rwth-aachen.de
WWW    http://www.ime.rwth-aachen.de/~michael/index.html
--------------------------------------------------------

Thanks to 

Christoph Jaeschke (jaeschke@item.uni-bremen.de)
Mark Goldberg (goldber@primenet.com)
*/
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs
env = 'OS2ENVIRONMENT'
x11root = VALUE('X11ROOT',,env)
hostname = VALUE('HOSTNAME',,env)
versionmajor = 0
versionminor = 77
IF x11root = '' THEN DO
	SAY "The environment variable X11ROOT is not set. configure won't run without it."
	EXIT
END
'@echo off'
SAY 'Configuring MAKE for XFree86/OS2 (emx)'

cd "include"
SAY 'Creating 'DIRECTORY()'\LTconfig.h'
RC=SysFileDelete("LTconfig.h")
CALL Lineout "LTconfig.h" ,"/* LTconfig.h generated by configure.cmd */"
DO WHILE Lines(LTconfig.h.in) 
  Zeile = Linein(LTconfig.h.in)
    SELECT
       WHEN Zeile="#undef HAVE_STRCOLL" THEN CALL Lineout "LTconfig.h","#define HAVE_STRCOLL"
       WHEN Zeile="#undef RETSIGTYPE" THEN CALL Lineout "LTconfig.h","#define RETSIGTYPE void"
       WHEN Zeile="#undef STDC_HEADERS" THEN CALL Lineout "LTconfig.h","#define STDC_HEADERS"
       WHEN Zeile="#undef TIME_WITH_SYS_TIME" THEN CALL Lineout "LTconfig.h","#define TIME_WITH_SYS_TIME"
       WHEN Zeile="#undef HAVE_PUTENV" THEN CALL Lineout "LTconfig.h","#define HAVE_PUTENV"
       WHEN Zeile="#undef HAVE_SELECT" THEN CALL Lineout "LTconfig.h","#define HAVE_SELECT"
       WHEN Zeile="#undef HAVE_STRCASECMP" THEN CALL Lineout "LTconfig.h","#define HAVE_STRCASECMP"
       WHEN Zeile="#undef HAVE_STRNCASECMP" THEN CALL Lineout "LTconfig.h","#define HAVE_STRNCASECMP"
       WHEN Zeile="#undef HAVE_STRSTR" THEN CALL Lineout "LTconfig.h","#define HAVE_STRSTR"
       WHEN Zeile="#undef HAVE_SYSCONF" THEN CALL Lineout "LTconfig.h","#define HAVE_SYSCONF"
       WHEN Zeile="#undef HAVE_WAITPID" THEN CALL Lineout "LTconfig.h","#define HAVE_WAITPID"
       WHEN Zeile="#undef HAVE_DIRENT_H" THEN CALL Lineout "LTconfig.h","#define HAVE_DIRENT_H"
       WHEN Zeile="#undef HAVE_FCNTL_H" THEN CALL Lineout "LTconfig.h","#define HAVE_FCNTL_H"
       WHEN Zeile="#undef HAVE_MEMORY_H" THEN CALL Lineout "LTconfig.h","#define HAVE_MEMORY_H"
       WHEN Zeile="#undef HAVE_PWD_H" THEN CALL Lineout "LTconfig.h","#define HAVE_PWD_H"
       WHEN Zeile="#undef HAVE_STRING_H" THEN CALL Lineout "LTconfig.h","#define HAVE_STRING_H"
       WHEN Zeile="#undef HAVE_SYS_DIR_H" THEN CALL Lineout "LTconfig.h","#define HAVE_SYS_DIR_H"
       WHEN Zeile="#undef HAVE_SYS_SELECT_H" THEN CALL Lineout "LTconfig.h","#define HAVE_SYS_SELECT_H"
       WHEN Zeile="#undef HAVE_SYS_STAT_H" THEN CALL Lineout "LTconfig.h","#define HAVE_SYS_STAT_H"
       WHEN Zeile="#undef HAVE_SYS_TIME_H" THEN CALL Lineout "LTconfig.h","#define HAVE_SYS_TIME_H"
       WHEN Zeile="#undef HAVE_SYS_TYPES_H" THEN CALL Lineout "LTconfig.h","#define HAVE_SYS_TYPES_H"
       WHEN Zeile="#undef HAVE_SYS_WAIT_H" THEN CALL Lineout "LTconfig.h","#define HAVE_SYS_WAIT_H"
       WHEN POS("HAVE_UNISTD_H",Zeile)>0 THEN CALL Lineout "LTconfig.h","#define HAVE_UNISTD_H"
       WHEN POS("HAVE_GETHOSTNAME",Zeile)>0 THEN CALL Lineout "LTconfig.h","#define HAVE_GETHOSTNAME"
       WHEN POS("SIZEOF_SHORT",Zeile)>0 THEN CALL Lineout "LTconfig.h","#define	SIZEOF_SHORT		2"
       WHEN POS("SIZEOF_INT",Zeile)>0 THEN CALL Lineout "LTconfig.h","#define	SIZEOF_INT		4"
       WHEN POS("SIZEOF_LONG_LONG",Zeile)>0 THEN CALL Lineout "LTconfig.h","#define	SIZEOF_LONG_LONG	8"
       WHEN POS("SIZEOF_LONG",Zeile)>0 THEN CALL Lineout "LTconfig.h","#define	SIZEOF_LONG		4"

       OTHERWISE CALL Lineout "LTconfig.h",Zeile
    END
END
CALL Lineout "LTconfig.h",""
CALL Lineout "LTconfig.h","#ifdef __EMX__"
CALL Lineout "LTconfig.h","#define strcasecmp stricmp"
CALL Lineout "LTconfig.h","#define strncasecmp strnicmp"
CALL Lineout "LTconfig.h","#endif"

CALL MAKEMAKEFILE x11root versionmajor versionminor "" 

cd "Motif-1.2"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd "Xm"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd ..
cd "XmI"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd ..
cd "Mrm"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd ..
cd ..
cd ..

'if exist INSTALL del INSTALL.unix 2>nul'
'if exist INSTALL move INSTALL INSTALL.unix'
/* Now lets make the root-Makefile */
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd "lib"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd "Xm"
/* Now lets make the libXm-Makefile */
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 

SAY 'Creating 'DIRECTORY()'\XmOS2.def.in'
RC=SysFileDelete("XmOS2.def.in")
RC=STREAM("XmOS2.def.in",'C','OPEN WRITE')

CALL Lineout "XmOS2.def.in" ,"LIBRARY XM INITINSTANCE TERMINSTANCE"
CALL Lineout "XmOS2.def.in" ,"DESCRIPTION ""X11R6.1 XFree86 XM.dll for OS/2 EMX VERSION="versionmajor"."versionminor""""
CALL Lineout "XmOS2.def.in" ,"CODE"
CALL Lineout "XmOS2.def.in" ,"	PRELOAD"
CALL Lineout "XmOS2.def.in" ,"DATA"
CALL Lineout "XmOS2.def.in" ,"	MULTIPLE NONSHARED"
CALL Lineout "XmOS2.def.in" ,"STACKSIZE 32768"
CALL Lineout "XmOS2.def.in" ,"EXPORTS"
CALL Lineout "XmOS2.def.in" ," "


RC=STREAM("XmOS2.def.in",'C','CLOSE')

cd ..

cd "Mrm"

/* Now lets make the libMrm-Makefile */

CALL MAKEMAKEFILE x11root versionmajor versionminor "-L../Xm -lXm" 

SAY 'Creating 'DIRECTORY()'\MrmOS2.def.in'
RC=SysFileDelete("MrmOS2.def.in")
RC=STREAM("MrmOS2.def.in",'C','OPEN WRITE')

CALL Lineout "MrmOS2.def.in" ,"LIBRARY Mrm"
CALL Lineout "MrmOS2.def.in" ,"DESCRIPTION ""X11R6 XFree86 Mrm.dll for OS/2 EMX VERSION="versionmajor"."versionminor""""
CALL Lineout "MrmOS2.def.in" ,"CODE"
CALL Lineout "MrmOS2.def.in" ,"	PRELOAD"
CALL Lineout "MrmOS2.def.in" ,"DATA"
CALL Lineout "MrmOS2.def.in" ,"	MULTIPLE NONSHARED"
CALL Lineout "MrmOS2.def.in" ,"STACKSIZE 32768"
CALL Lineout "MrmOS2.def.in" ,"EXPORTS"
CALL Lineout "MrmOS2.def.in" ," "


RC=STREAM("MrmOS2.def.in",'C','CLOSE')

cd ..
cd ..

cd "test"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd "Mrm"
/* Now lets make the test.Makefile */
SAY 'Creating 'DIRECTORY()'\test.Makefile'
RC=SysFileDelete("test.Makefile")
RC=STREAM("test.Makefile",'C','OPEN WRITE')

CALL Lineout "test.Makefile" ,"# test.Makefile generated by configure.cmd"

CALL Lineout "test.Makefile", "SHELL=CMD.EXE"

RC=STREAM("test.Makefile.in",'C','OPEN READ')
DO WHILE Lines("test.Makefile.in") 
  Zeile = Linein("test.Makefile.in")
    SELECT
       WHEN POS("@R6libs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@R6libs@" "-lXext~-lSM~-lICE" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@x_includes@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_includes@" "-I"x11root"/XFree86/include" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@x_libraries@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_libraries@" "-L"x11root"/XFree86/lib" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@CC@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CC@" "gcc" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("-lm",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("-lm" "-lm~-Zexe~-Zmtd~-g" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@CFLAGS@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CFLAGS@" "-g~-Wall~-ansi~-pedantic~-fno-strength-reduce~-Zmtd~-DFUNCPROTO=15~-DNARROWPROTO" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_mrm@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@build_lesstif_mrm@" "-L../../../lib/Xm~${XM_LIBRARY}" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_libraries@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@build_lesstif_libraries@" "-L../../../lib/Xm~-L../../../lib/Mrm~$(XM_LIBRARY)" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_mrmg@",Zeile) > 0 THEN NOP
       WHEN POS("@motif_libraries@",Zeile) > 0 THEN NOP
       WHEN POS("@srcdir_src_pat_subst@",Zeile) > 0 THEN NOP
       WHEN POS("@test_depend_xm@",Zeile) > 0 THEN NOP
       WHEN POS("@test_depend_mrm@",Zeile) > 0 THEN NOP
       WHEN POS("@depend_xm_shared@",Zeile) > 0 THEN NOP
       WHEN POS("@depend_mrm_shared@",Zeile) > 0 THEN NOP
       WHEN POS("	(cd ../../../lib/Xm && ${MAKE} $(@:../../libXm/%=%)) || exit 1",Zeile) > 0 THEN NOP
       WHEN POS("@obj_rule",Zeile) > 0 THEN NOP
       WHEN POS("@freebsd20",Zeile) > 0 THEN NOP
       OTHERWISE CALL Lineout "test.Makefile",Zeile
    END
END
RC=STREAM("test.Makefile",'C','CLOSE')
RC=STREAM("test.Makefile.in",'C','CLOSE')

/* Now lets make the testMrm/Makefile */
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 

'dir > MSubDirs'

RC=SysFileDelete("MSubDirs.cmd")
RC=STREAM("MSubDirs.cmd",'C','OPEN WRITE')

CALL Lineout "MSubDirs.cmd" ,"/* OS/2 REXX generated by configure.cmd */"

RC=STREAM("MMubDirs",'C','OPEN READ')
DO WHILE Lines("MSubDirs") 
  Zeile = Linein("MSubDirs")
    SELECT
       WHEN POS("<DIR>",Zeile) = 0 THEN NOP
       OTHERWISE DO 
  	  VALUE = "cd "DELSTR(Zeile,1,40)
             IF POS("cd .",VALUE) > 0 THEN NOP 
             ELSE DO
               CALL Lineout "MSubDirs.cmd",VALUE
               CALL Lineout "MSubDirs.cmd","CALL MFMAK"
               CALL Lineout "MSubDirs.cmd","cd .."
             END
       END
    END
END
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","EXIT"
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","MFMAK: PROCEDURE"
CALL Lineout "MSubDirs.cmd","SAY 'Creating 'DIRECTORY()'\Makefile'"
CALL Lineout "MSubDirs.cmd","RC=SysFileDelete('Makefile')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile','C','OPEN WRITE')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile.in','C','OPEN READ')"
CALL Lineout "MSubDirs.cmd","DO WHILE Lines('Makefile.in') "
CALL Lineout "MSubDirs.cmd","  Zeile = Linein('Makefile.in')"
CALL Lineout "MSubDirs.cmd","    SELECT"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@srcdir@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@srcdir@' '.' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@test_include@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@test_include@' 'include~../test.Makefile' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('../../clients/uil/uil',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('../../clients/uil/uil' '..\\..\\clients\\uil\\uil' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       OTHERWISE CALL Lineout 'Makefile',Zeile"
CALL Lineout "MSubDirs.cmd","    END"
CALL Lineout "MSubDirs.cmd","END"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile','C','CLOSE')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile.in','C','CLOSE')"
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","RETURN RC"
CALL Lineout "MSubDirs.cmd",'REPLACE: PROCEDURE'
CALL Lineout "MSubDirs.cmd",'   PARSE ARG VALUE1 VALUE2 VALUE3 '
CALL Lineout "MSubDirs.cmd",'/* REXX does not transport Blanks in this Function */'
CALL Lineout "MSubDirs.cmd",'       VALUE2=TRANSLATE(VALUE2," ","~")'
CALL Lineout "MSubDirs.cmd",'       POSITION=(POS(VALUE1,VALUE3)+LENGTH(VALUE2)-1)'
CALL Lineout "MSubDirs.cmd",'       LM=LEFT(OVERLAY(VALUE2,VALUE3,POS(VALUE1,VALUE3)),POSITION)'
CALL Lineout "MSubDirs.cmd",'       RM=RIGHT(VALUE3,(LENGTH(VALUE3)+LENGTH(VALUE2)-LENGTH(VALUE1)-POSITION))'
CALL Lineout "MSubDirs.cmd",'       RR=INSERT(LM, RM)'
CALL Lineout "MSubDirs.cmd",'RETURN RR'

RC=STREAM("MSubDirs.cmd",'C','CLOSE')
RC=STREAM("MSubDirs",'C','CLOSE')

CALL MSubDirs

RC=SysFileDelete("MSubDirs.cmd")
RC=SysFileDelete("MSubDirs")

cd ..
cd ..


cd "test"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd "Xm"
/* Now lets make the test.Makefile */
SAY 'Creating 'DIRECTORY()'\test.Makefile'
RC=SysFileDelete("test.Makefile")
RC=STREAM("test.Makefile",'C','OPEN WRITE')

CALL Lineout "test.Makefile" ,"# test.Makefile generated by configure.cmd"

CALL Lineout "test.Makefile", "SHELL=CMD.EXE"

RC=STREAM("test.Makefile.in",'C','OPEN READ')
DO WHILE Lines("test.Makefile.in") 
  Zeile = Linein("test.Makefile.in")
    SELECT
       WHEN POS("@R6libs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@R6libs@" "-lXext~-lSM~-lICE" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@x_includes@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_includes@" "-I"x11root"/XFree86/include" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@x_libraries@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_libraries@" "-L"x11root"/XFree86/lib" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@CC@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CC@" "gcc" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("-lm",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("-lm" "-lm~-Zexe~-Zmtd~-g" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@CFLAGS@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CFLAGS@" "-g~-Wall~-ansi~-pedantic~-fno-strength-reduce~-Zmtd~-DFUNCPROTO=15~-DNARROWPROTO" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_xm@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@build_lesstif_xm@" "-L../../../lib/Xm~${XM_LIBRARY}" Zeile)
          CALL Lineout "test.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_xmg@",Zeile) > 0 THEN NOP
       WHEN POS("@motif_libraries@",Zeile) > 0 THEN NOP
       WHEN POS("@srcdir_src_pat_subst@",Zeile) > 0 THEN NOP
       WHEN POS("@test_depend_xm@",Zeile) > 0 THEN NOP
       WHEN POS("@depend_xm_shared@",Zeile) > 0 THEN NOP
       WHEN POS("	(cd ../../../libXm && ${MAKE} $(@:../../libXm/%=%)) || exit 1",Zeile) > 0 THEN NOP
       WHEN POS("@obj_rule",Zeile) > 0 THEN NOP
       WHEN POS("@freebsd20",Zeile) > 0 THEN NOP
       OTHERWISE CALL Lineout "test.Makefile",Zeile
    END
END
RC=STREAM("test.Makefile",'C','CLOSE')
RC=STREAM("test.Makefile.in",'C','CLOSE')

/* Now lets make the testXm/Makefile */
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 

'dir > MSubDirs'

RC=SysFileDelete("MSubDirs.cmd")
RC=STREAM("MSubDirs.cmd",'C','OPEN WRITE')

CALL Lineout "MSubDirs.cmd" ,"/* OS/2 REXX generated by configure.cmd */"

RC=STREAM("MMubDirs",'C','OPEN READ')
DO WHILE Lines("MSubDirs") 
  Zeile = Linein("MSubDirs")
    SELECT
       WHEN POS("<DIR>",Zeile) = 0 THEN NOP
       OTHERWISE DO 
  	  VALUE = "cd "DELSTR(Zeile,1,40)
             IF POS("cd .",VALUE) > 0 THEN NOP 
             ELSE DO
               CALL Lineout "MSubDirs.cmd",VALUE
               CALL Lineout "MSubDirs.cmd","CALL MFMAK"
               CALL Lineout "MSubDirs.cmd","cd .."
             END
       END
    END
END
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","EXIT"
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","MFMAK: PROCEDURE"
CALL Lineout "MSubDirs.cmd","SAY 'Creating 'DIRECTORY()'\Makefile'"
CALL Lineout "MSubDirs.cmd","RC=SysFileDelete('Makefile')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile','C','OPEN WRITE')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile.in','C','OPEN READ')"
CALL Lineout "MSubDirs.cmd","DO WHILE Lines('Makefile.in') "
CALL Lineout "MSubDirs.cmd","  Zeile = Linein('Makefile.in')"
CALL Lineout "MSubDirs.cmd","    SELECT"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@srcdir@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@srcdir@' '.' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@test_include@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@test_include@' 'include~../test.Makefile' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       OTHERWISE CALL Lineout 'Makefile',Zeile"
CALL Lineout "MSubDirs.cmd","    END"
CALL Lineout "MSubDirs.cmd","END"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile','C','CLOSE')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile.in','C','CLOSE')"
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","RETURN RC"
CALL Lineout "MSubDirs.cmd",'REPLACE: PROCEDURE'
CALL Lineout "MSubDirs.cmd",'   PARSE ARG VALUE1 VALUE2 VALUE3 '
CALL Lineout "MSubDirs.cmd",'/* REXX does not transport Blanks in this Function */'
CALL Lineout "MSubDirs.cmd",'       VALUE2=TRANSLATE(VALUE2," ","~")'
CALL Lineout "MSubDirs.cmd",'       POSITION=(POS(VALUE1,VALUE3)+LENGTH(VALUE2)-1)'
CALL Lineout "MSubDirs.cmd",'       LM=LEFT(OVERLAY(VALUE2,VALUE3,POS(VALUE1,VALUE3)),POSITION)'
CALL Lineout "MSubDirs.cmd",'       RM=RIGHT(VALUE3,(LENGTH(VALUE3)+LENGTH(VALUE2)-LENGTH(VALUE1)-POSITION))'
CALL Lineout "MSubDirs.cmd",'       RR=INSERT(LM, RM)'
CALL Lineout "MSubDirs.cmd",'RETURN RR'

RC=STREAM("MSubDirs.cmd",'C','CLOSE')
RC=STREAM("MSubDirs",'C','CLOSE')

CALL MSubDirs

RC=SysFileDelete("MSubDirs.cmd")
RC=SysFileDelete("MSubDirs")

cd ..
cd ..

cd "clients"
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 
cd "Motif-1.2"
/* Now lets make the test.Makefile */
SAY 'Creating 'DIRECTORY()'\client.Makefile'
RC=SysFileDelete("client.Makefile")
RC=STREAM("client.Makefile",'C','OPEN WRITE')

CALL Lineout "client.Makefile" ,"# client.Makefile generated by configure.cmd"

CALL Lineout "client.Makefile", "SHELL=CMD.EXE"

RC=STREAM("client.Makefile.in",'C','OPEN READ')
DO WHILE Lines("client.Makefile.in") 
  Zeile = Linein("client.Makefile.in")
    SELECT
       WHEN POS("@R6libs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@R6libs@" "-lXext~-lSM~-lICE" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@x_includes@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_includes@" "-I"x11root"/XFree86/include" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@x_libraries@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_libraries@" "-L"x11root"/XFree86/lib" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@CC@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CC@" "gcc" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN Zeile="	(cd ../lib && ${MAKE}) || exit 1" THEN CALL Lineout "client.Makefile","	(cd ..\\lib && ${MAKE}) || exit 1"
       WHEN POS("-lm",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("-lm" "-lm~-Zexe~-Zmtd" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@CFLAGS@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CFLAGS@" "-g~-fno-strength-reduce~-Zmtd~-DFUNCPROTO=15~-DNARROWPROTO" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_xm@",Zeile) > 0 THEN DO
	  NeuZeile=REPLACE("@build_lesstif_xm@" "-L../../../lib/Xm~-lXm" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_mrm@",Zeile) > 0 THEN DO
	  NeuZeile=REPLACE("@build_lesstif_mrm@" "-L../../../lib/Mrm~-lMrm" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
        END
       WHEN POS("@build_lesstif_xmg@",Zeile) > 0 THEN NOP
       WHEN POS("@motif_libraries@",Zeile) > 0 THEN NOP
       WHEN POS("@srcdir_src_pat_subst@",Zeile) > 0 THEN NOP
       WHEN POS("@client_depend_xm@",Zeile) > 0 THEN NOP
       WHEN POS("@client_depend_mrm@",Zeile) > 0 THEN NOP
       WHEN POS("@depend_xm_shared@",Zeile) > 0 THEN NOP
       WHEN POS("@depend_mrm_shared@",Zeile) > 0 THEN NOP
       WHEN POS("	(cd ../../../lib",Zeile) > 0 THEN NOP
       WHEN POS("@obj_rule",Zeile) > 0 THEN NOP
       WHEN POS("@freebsd20",Zeile) > 0 THEN NOP
       WHEN POS("${x_libraries}",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("${x_libraries}" "${x_libraries}~-Zexe~-Zmtd" Zeile)
          CALL Lineout "client.Makefile",NeuZeile
       END
       OTHERWISE CALL Lineout "client.Makefile",Zeile
    END
END
RC=STREAM("client.Makefile",'C','CLOSE')
RC=STREAM("client.Makefile.in",'C','CLOSE')

/* Now lets make the clients/Makefile */
CALL MAKEMAKEFILE x11root versionmajor versionminor "" 

'dir > MSubDirs'

RC=SysFileDelete("MSubDirs.cmd")
RC=STREAM("MSubDirs.cmd",'C','OPEN WRITE')

CALL Lineout "MSubDirs.cmd" ,"/* OS/2 REXX generated by configure.cmd */"
CALL Lineout "MSubDirs.cmd","call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'"
CALL Lineout "MSubDirs.cmd","call SysLoadFuncs"
CALL Lineout "MSubDirs.cmd","env = 'OS2ENVIRONMENT'"
CALL Lineout "MSubDirs.cmd","x11root = VALUE('X11ROOT',,env)"

RC=STREAM("MMubDirs",'C','OPEN READ')
DO WHILE Lines("MSubDirs") 
  Zeile = Linein("MSubDirs")
    SELECT
       WHEN POS("<DIR>",Zeile) = 0 THEN NOP
       OTHERWISE DO 
  	  VALUE = "cd "DELSTR(Zeile,1,40)
             IF POS("cd .",VALUE) > 0 THEN NOP 
             ELSE DO
               CALL Lineout "MSubDirs.cmd",VALUE
               CALL Lineout "MSubDirs.cmd","CALL MFMAK x11root"
               CALL Lineout "MSubDirs.cmd","cd .."
             END
       END
    END
END
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","EXIT"
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","MFMAK: PROCEDURE"
CALL Lineout "MSubDirs.cmd","PARSE ARG x11root"
CALL Lineout "MSubDirs.cmd","SAY 'Creating 'DIRECTORY()'\Makefile'"
CALL Lineout "MSubDirs.cmd","RC=SysFileDelete('Makefile')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile','C','OPEN WRITE')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile.in','C','OPEN READ')"
CALL Lineout "MSubDirs.cmd","DO WHILE Lines('Makefile.in') "
CALL Lineout "MSubDirs.cmd","  Zeile = Linein('Makefile.in')"
CALL Lineout "MSubDirs.cmd","    SELECT"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@srcdir@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@srcdir@' '.' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@objs_pat_subst@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@objs_pat_subst@' '$(SRCS:%.c=%.o)' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@client_include@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@client_include@' 'include~../client.Makefile' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@x_includes@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@x_includes@' '-I'x11root'/XFree86/include' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@CC@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@CC@' 'gcc' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@LEX@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@LEX@' 'flex' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@LEXLIB@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@LEXLIB@' '-lfl' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@YACC@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@YACC@' 'bison~-y' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('#define VERSION',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile='	echo #define VERSION """versionmajor"."versionminor""" > version.h'"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('lex.yy.c',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('lex.yy.c' 'lexyy.c' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@x_lib_path@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@x_lib_path@' x11root'/XFree86/lib' Zeile)"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@x_inc_path@' x11root'/XFree86/include' NeuZeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@x_libraries@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@x_libraries@' '-lMrm~-lXm~-lXt~-lX11~-lXext~-lSM~-lICE' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@extralibs@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@extralibs@' '-lsocket~-Zexe~-Zmtd' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@CFLAGS@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@CFLAGS@' '-g~-fno-strength-reduce~-Zmtd~-Zsysv-signals' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","       END"

CALL Lineout "MSubDirs.cmd","       WHEN POS('@RANLIB@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@RANLIB@' 'ar~s' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@AR@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@AR@' 'ar' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@INSTALL@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@INSTALL@' 'copy' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@INSTALL_DATA@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@INSTALL_DATA@' 'copy' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@prefix@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@prefix@' x11root'\XFree86' Zeile)"
CALL Lineout "MSubDirs.cmd","          IF POS('eader_dir',NeuZeile)>0 THEN NeuZeile=SLASH2BACKSLASH(NeuZeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@exec_prefix@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@exec_prefix@' '$(prefix)' Zeile)"
CALL Lineout "MSubDirs.cmd","          NeuZeile=TRANSLATE(NeuZeile,'\','/')"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"

CALL Lineout "MSubDirs.cmd","       WHEN POS('@libdir@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@libdir@' '$(prefix)\lib' Zeile)"
CALL Lineout "MSubDirs.cmd","          NeuZeile=TRANSLATE(NeuZeile,'\','/')"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"

CALL Lineout "MSubDirs.cmd","       WHEN POS('@major_shared@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@major_shared@' '"versionmajor"' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@minor_shared@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@minor_shared@' '"versionminor"' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@srcdir_src_pat_subst@',Zeile) > 0 THEN NOP"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@LIBOBJS@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@LIBOBJS@' '~' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@shobjs_pat_subst@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@shobjs_pat_subst@' '$(SRCS:%.c=shared/%.obj)' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","       END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@static_prefix@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","	  NeuZeile=REPLACE('@static_prefix@' '#' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","        END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@obj_rule1@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@obj_rule1@' '%.o~:~%.c' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","       END"
CALL Lineout "MSubDirs.cmd","       WHEN POS('@obj_rule2@',Zeile) > 0 THEN DO"
CALL Lineout "MSubDirs.cmd","          NeuZeile=REPLACE('@obj_rule2@' '	${CC}~${CFLAGS_STATIC}~-D_SVID_SOURCE~-D_GNU_SOURCE~-D_POSIX_SOURCE~-c~-o~$@~$<' Zeile)"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',NeuZeile"
CALL Lineout "MSubDirs.cmd","       END"
CALL Lineout "MSubDirs.cmd","       WHEN Zeile='@obj_rule3@' THEN NOP"
CALL Lineout "MSubDirs.cmd","       WHEN Zeile='@obj_rule4@' THEN NOP"
CALL Lineout "MSubDirs.cmd","       OTHERWISE DO"
CALL Lineout "MSubDirs.cmd","          CALL Lineout 'Makefile',Zeile"
CALL Lineout "MSubDirs.cmd","       END"
CALL Lineout "MSubDirs.cmd","    END"
CALL Lineout "MSubDirs.cmd","END"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile','C','CLOSE')"
CALL Lineout "MSubDirs.cmd","RC=STREAM('Makefile.in','C','CLOSE')"
CALL Lineout "MSubDirs.cmd",""
CALL Lineout "MSubDirs.cmd","RETURN RC"
CALL Lineout "MSubDirs.cmd",'REPLACE: PROCEDURE'
CALL Lineout "MSubDirs.cmd",'   PARSE ARG VALUE1 VALUE2 VALUE3 '
CALL Lineout "MSubDirs.cmd",'/* REXX does not transport Blanks in this Function */'
CALL Lineout "MSubDirs.cmd",'       VALUE2=TRANSLATE(VALUE2," ","~")'
CALL Lineout "MSubDirs.cmd",'       POSITION=(POS(VALUE1,VALUE3)+LENGTH(VALUE2)-1)'
CALL Lineout "MSubDirs.cmd",'       LM=LEFT(OVERLAY(VALUE2,VALUE3,POS(VALUE1,VALUE3)),POSITION)'
CALL Lineout "MSubDirs.cmd",'       RM=RIGHT(VALUE3,(LENGTH(VALUE3)+LENGTH(VALUE2)-LENGTH(VALUE1)-POSITION))'
CALL Lineout "MSubDirs.cmd",'       RR=INSERT(LM, RM)'
CALL Lineout "MSubDirs.cmd",'RETURN RR'

RC=STREAM("MSubDirs.cmd",'C','CLOSE')
RC=STREAM("MSubDirs",'C','CLOSE')

CALL MSubDirs

RC=SysFileDelete("MSubDirs.cmd")
RC=SysFileDelete("MSubDirs")

cd ..
cd ..

EXIT

MAKEMAKEFILE: PROCEDURE 
PARSE ARG x11root versionmajor versionminor OS2LIB 
SAY 'Creating 'DIRECTORY()'\Makefile'

RC=SysFileDelete("Makefile")
RC=STREAM("Makefile",'C','OPEN WRITE')
RC=STREAM("Makefile.in",'C','OPEN READ')

CALL Lineout "Makefile" ,"# Makefile generated by configure.cmd"
IF LENGTH(OS2LIB) >0 THEN CALL Lineout "Makefile" ,"OS2LIB="OS2LIB

CALL Lineout "Makefile", "SHELL=CMD.EXE"

DO WHILE Lines("Makefile.in") 
  Zeile = Linein("Makefile.in")
    SELECT
       WHEN POS("mkdir -p ${header_dir}",Zeile) > 0 THEN DO
          Zeile=Zeile" > nul 2>&1"
          NeuZeile=REPLACE("-p" " " Zeile)
          CALL Lineout "Makefile",NeuZeile
          CALL Lineout "Makefile","	$(INSTALL_DATA) $(srcdir)\\*.h ${header_dir}"
       END
       WHEN POS("/$$i ${header_dir}",Zeile)>0 THEN NOP 
       WHEN POS("@include_subdirs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@include_subdirs@" "Motif-1.2" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@client_subdirs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@client_subdirs@" "Motif-1.2" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@static_prefix@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@static_prefix@" "#" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@major_shared@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@major_shared@" versionmajor Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@minor_shared@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@minor_shared@" versionminor Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@prefix@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@prefix@" x11root"\XFree86" Zeile)
          IF POS("eader_dir",NeuZeile)>0 THEN NeuZeile=SLASH2BACKSLASH(NeuZeile)
          CALL Lineout "Makefile",NeuZeile
        END
       WHEN POS("@exec_prefix@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@exec_prefix@" "$(prefix)" Zeile)
          NeuZeile=TRANSLATE(NeuZeile,"\","/")
          CALL Lineout "Makefile",NeuZeile
        END
       WHEN POS("@libdir@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@libdir@" "$(prefix)\lib" Zeile)
          NeuZeile=TRANSLATE(NeuZeile,"\","/")
          CALL Lineout "Makefile",NeuZeile
        END
       WHEN POS("${prefix}/include",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("${prefix}/include" "$(prefix)\include" Zeile)
          NeuZeile=TRANSLATE(NeuZeile,"\","/")
          CALL Lineout "Makefile",NeuZeile
        END
       WHEN POS("eader_dir",Zeile)>0 THEN DO
          NeuZeile=SLASH2BACKSLASH(Zeile)
          CALL Lineout "Makefile",NeuZeile
        END
       WHEN POS("echo Installing in",Zeile) >0 THEN CALL Lineout "Makefile","	@for %i in ($(subst /,\,$(subdirs))) do cd %i && $(MAKE) install && cd .."
       WHEN POS("echo Making all in $$i ; \",Zeile) >0 THEN CALL Lineout "Makefile","	@for %i in ($(subst /,\,$(subdirs))) do cd %i && $(MAKE) all && cd .."
       WHEN POS("echo Depending in $$i",Zeile) >0 THEN CALL Lineout "Makefile","	@for %i in ($(subst /,\,$(subdirs))) do cd %i && $(MAKE) depend && cd .."
       WHEN POS("echo Cleaning in $$i ; \",Zeile) >0 THEN CALL Lineout "Makefile","	@for %i in ($(subst /,\,$(subdirs))) do cd %i && $(MAKE) clean && cd .."
       WHEN POS("echo DistCleaning in $$i ; \",Zeile) >0 THEN CALL Lineout "Makefile","	@for %i in ($(subst /,\,$(subdirs))) do cd %i && $(MAKE) distclean && cd .."
       WHEN POS("echo Making motif",Zeile) >0 THEN NOP
       WHEN POS("@for i in ${subdirs}; do \",Zeile)>0 THEN NOP
       WHEN POS("(cd $$i && ${MAKE}",Zeile)>0 THEN NOP 
       WHEN POS("done",Zeile)>0 THEN NOP 
       WHEN POS("@SET_MAKE@",Zeile) THEN NOP
       WHEN POS("@srcdir@",Zeile) > 0 THEN DO
	  NeuZeile=REPLACE("@srcdir@" "." Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@INSTALL@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@INSTALL@" "copy" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@INSTALL_DATA@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@INSTALL_DATA@" "copy" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("dir -p",Zeile) > 0 THEN DO
          CALL Lineout "Makefile","	del ${header_dir}\\*.h"
          CALL Lineout "Makefile","	rmdir ${header_dir}"
          NeuZeile=REPLACE("-p" " " Zeile)
          CALL Lineout "Makefile",NeuZeile
          CALL Lineout "Makefile","	copy *.h ${header_dir}"
       END
       WHEN POS("for i in",Zeile)>0 THEN NOP
       WHEN POS("${INSTALL_DATA} $(srcdir)",Zeile)>0 THEN NOP
       WHEN POS("SHELL=/bin/sh",Zeile)>0 THEN NOP
       WHEN POS("@subdirs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE('@subdirs@' 'include~lib~clients' Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@lib_subdirs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE('@lib_subdirs@' 'Xm~Mrm' Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@lib_cleandirs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE('@lib_cleandirs@' 'Xm~Mrm' Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@cleandirs@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE('@cleandirs@' 'include~lib~test~clients' Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@obj_rule1@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@obj_rule1@" "%.o~:~%.c" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@obj_rule2@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@obj_rule2@" "	${CC}~${CFLAGS_STATIC}~-D_SVID_SOURCE~-D_GNU_SOURCE~-D_POSIX_SOURCE~-c~-o~$@~$<" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@CFLAGS@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CFLAGS@" "-g~-Wall~-ansi~-pedantic~-fno-strength-reduce~-Zmtd~-Zsysv-signals~-Zomf" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN Zeile="@obj_rule3@" THEN NOP
       WHEN Zeile="@obj_rule4@" THEN NOP
       WHEN Zeile="@gprof_rule1@" THEN NOP
       WHEN Zeile="@gprof_rule2@" THEN NOP
       WHEN Zeile="@gprof_rule3@" THEN NOP
       WHEN Zeile="@gprof_rule4@" THEN NOP
       WHEN Zeile="@shared_rule3@" THEN NOP
       WHEN Zeile="@shared_rule4@" THEN NOP
       WHEN POS("@CC@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@CC@" "gcc" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@RANLIB@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@RANLIB@" "ar~s" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@AR@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@AR@" "ar" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@srcdir_src_pat_subst@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@srcdir_src_pat_subst@" "$(SRCS:%.c=$(srcdir)/%.c)" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@shared_include@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@shared_include@" "include~../../config/os2-shared.mk" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("./mkinline",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("./mkinline" ".\\mkinline" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@shared_rule1@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@shared_rule1@" "shared/%.obj~:~%.c" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@shared_rule2@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@shared_rule2@" "	${CC}~${CFLAGS}~-D_SVID_SOURCE~-D_GNU_SOURCE~-D_POSIX_SOURCE~-c~-o~$@~$<" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@objs_pat_subst@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@objs_pat_subst@" "$(SRCS:%.c=%.o)" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@shobjs_pat_subst@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@shobjs_pat_subst@" "$(SRCS:%.c=shared/%.obj)" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@gprofobjs_pat_subst@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@gprofobjs_pat_subst@" "$(SRCS:%.c=gprof/%.o)" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("@x_includes@",Zeile) > 0 THEN DO
          NeuZeile=REPLACE("@x_includes@"  "-I"x11root"/XFree86/include" Zeile)
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN POS("rm -f *~ core *.bak *.o shared/*.o libXm.* mkinline",Zeile) > 0 THEN DO
          NeuZeile='	del  *~ core *.bak *.o shared\\*.obj Xm.* mkinline mkinline.exe gdb-inline.c'
          CALL Lineout "Makefile",NeuZeile
       END
       WHEN Zeile="		$(srcdir)/gdb-inline.c" THEN NOP
       WHEN POS("makedepend -a -pshared",Zeile)>0 THEN CALL Lineout "Makefile","	makedepend -a -pshared/ -o.obj -- ${CFLAGS} -- ${SRCDIR_SRCS}"
       WHEN POS("${CFLAGS} -o $@",Zeile) > 0 THEN DO
          NeuZeile='	${CC} -Zexe -o $@ $<'
          CALL Lineout "Makefile",NeuZeile
       END
       OTHERWISE DO
	CALL Lineout "Makefile",Zeile
       END
    END      
END
RC=STREAM("Makefile",'C','CLOSE')
RC=STREAM("Makefile.in",'C','CLOSE')

RETURN

REPLACE: PROCEDURE
   PARSE ARG VALUE1 VALUE2 VALUE3 
/* REXX does not transport Blanks in this Function */
       VALUE2=TRANSLATE(VALUE2," ","~")
       POSITION=(POS(VALUE1,VALUE3)+LENGTH(VALUE2)-1)
       LM=LEFT(OVERLAY(VALUE2,VALUE3,POS(VALUE1,VALUE3)),POSITION)
       RM=RIGHT(VALUE3,(LENGTH(VALUE3)+LENGTH(VALUE2)-LENGTH(VALUE1)-POSITION))
       RR=INSERT(LM, RM)
RETURN RR

SLASH2BACKSLASH: PROCEDURE
   PARSE ARG VALUE1
    VALUE1=TRANSLATE(VALUE1,"/","\")
    DO WHILE (POS("/",VALUE1)>0) 
       position =POS("/",VALUE1)
       VALUE1=INSERT('\',VALUE1,position)
       VALUE1=OVERLAY('\',VALUE1,position)
    END

RETURN VALUE1




