.TH stateviews 3U "6 August 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
BrushVarView, CompNameVarView, FileNameVarView,
FontVarView, GravityVarView, MagnifVarView,
ModifStatusVarView, NameVarView, PatternVarView \- various state
variable view subclasses
.SH SYNOPSIS
.B #include <Unidraw/stateviews.h>
.SH DESCRIPTION
Unidraw predefines several state variable view subclasses for the the
state variable subjects it predefines, as described below.
.SH PUBLIC OPERATIONS
.TP
.B "BrushVarView(BrushVar*, ColorVar* = nil)"
.ns
.TP
.B "FontVarView(FontVar*, Alignment = Center)"
.ns
.TP
.B "PatternVarView(PatternVar*, ColorVar* = nil)"
Views of graphics state state variable subjects.  BrushVarView
displays a short line drawn in the subject's brush and in a color
specified by the given ColorVar (black if no ColorVar is supplied).
The BrushVarView displays ``None'' if the BrushVar's brush is
invisible.  Similarly, PatternVarView displays a filled rectangle
drawn in the subject's pattern and in a color specified by the given
ColorVar (black if no ColorVar is supplied).  The PatternVarView
displays ``None'' if the PatternVar's pattern is invisible.
FontVarView displays the name of its subject's font, aligned as
specified in its canvas.
.TP
.B "GravityVarView(GravityVar*, Alignment = Center)"
Displays either ``gravity on'' or a blank, depending on whether the
subject indicates that gravity is on or not.
.TP
.B "MagnifVarView(MagnifVar*, Alignment = Center)"
Displays ``mag \fIx\fPx'', where \fIx\fP is the current modification
factor recorded in the subject.
.TP
.B "ModifStateVarView(ModifStateVar*, Alignment = Center)"
Displays either an asterisk or a blank, depending on whether the
subject records that its component is modified.
.TP
.B "NameVarView("
.ns
.TP
.B "    NameVar*, Alignment = Center, const char* sample = nil"
.ns
.TP
.B ")"
.ns
.TP
.B "FileNameVarView("
.ns
.TP
.B "    NameVar*, Alignment = Center,"
.ns
.TP
.B "    boolean relative = true, const char* sample = nil"
.ns
.TP
.B ")"
.ns
.TP
.B "CompNameVarView("
.ns
.TP
.B "    CompNameVarView*, Alignment = Center,"
.ns
.TP
.B "    boolean relative = true, const char* sample = nil"
.ns
.TP
.B ")"
.br
Display the subject's string aligned as specified with respect to the
canvas.  Each constructor takes an optional sample string that defines
the view's natural size.  FileNameVarView provides a specialized view
of a NameVar for displaying file names.  It adds a \fIrelative\fP
argument for displaying the file name either as a relative or full
path.  CompNameVarView provides similar functionality for CompNameVar
subjects, except it precedes its subject's component's name with
``[part of]'' for components that have a named parent but that are not
named themselves.
.SH SEE ALSO
statevars(3U), StateVarView(3U)
