.TH Tool 3U "24 January 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
Tool \- base class for tool objects
.SH SYNOPSIS
.B #include <Unidraw/Tools/tool.h>
.SH DESCRIPTION
Tool is an abstract base class for objects that support direct
manipulation of components.  Tools employ animation and other visual
effects for immediate feedback to reinforce the user's perception that
he is dealing with real objects.  The user \fIgrasps\fP and
\fIwields\fP a tool to achieve a desired \fIeffect\fP.  The effect may
involve a change to one or more components' internal state, or it may
change the way components are viewed, or there may be no effect at all
(if for example the tool is used in an inapropriate context).
.sp
Conceptually, tools do their work within viewers, in which graphical
component views are displayed and manipulated.  Whenever a viewer
receives an input event (such as a mouse click or key press), it in
turn asks the current tool (defined by the enclosing editor object) to
produce a manipulator object. A tool implements its CreateManipulator
operation to create and initialize an appropriate manipulator, which
encapsulates the tool's manipulation semantics by defining the three
phases (grasp, wield, effect) of the manipulation.  Moreover, a tool
can delegate manipulator creation to one or more of the GraphicView
objects in the viewer to allow component-specific interaction.  A
tool's InterpretManipulator operation accesses and analyzes
information in the manipulator that characterizes the manipulation and
then creates a command that carries out the desired effect.  If a tool
delegated manipulator creation to a graphical view, then it must
delegate its interpretation to the same view.
.SH PUBLIC OPERATIONS
.TP
.B "virtual Manipulator* CreateManipulator("
.ns
.TP
.B "   Viewer*, Event&, Transformer*"
.ns
.TP
.B ")"
.ns
.TP
.B "virtual void InterpretManipulator(Manipulator*)"
Operations that define how the tool reacts when it is used and its
ultimate effect.  The tool can defer manipulator creation and
interpretation to a GraphicView.  This allows the same tool to behave
differently depending on the component it manipulates.
.sp
.sp
CreateManipulator creates a manipulator that is appropriate for the
tool.  It receives the viewer in which the manipulation will
take place, an event with which to initialize the manipulator if
necessary, and the coordinate transformation that maps canvas
coordinates into the subject's coordinate space.  InterpretManipulator
is called following manipulation and defines how to construct a
command that carries out the manipulation's desired effect.
.TP
.B "virtual void SetControlInfo(ControlInfo*)"
.ns
.TP
.B "virtual ControlInfo* GetControlInfo()"
Tools use a ControlInfo object to store information from which to
build a user interface for engaging the tool.  These operations set
and get the ControlInfo object.  SetControlInfo does \fInot\fP delete
the ControlInfo being replaced.
.TP
.B "virtual Component* Copy()"
Return a copy of the tool.  Subclasses should redefine this
operation to return an instance of their type.
.TP
.B "virtual void Read(istream&)"
.ns
.TP
.B "virtual void Write(ostream&)"
Read and write the tool's contents to a stream to support catalog
operations.  Read and write typically call first the corresponding
operations defined by their parent class, and then they read or write
their class-specific state.  Note that you must ensure that the
objects are read in the same order they are written.
.TP
.B "virtual ClassId GetClassId()"
.ns
.TP
.B "virtual boolean IsA(ClassId)"
GetClassId returns the unique class identifier for the Tool
subclass, while IsA returns whether the instance is of a class or
subclass corresponding to the given identifier.  IsA typically checks
the given identifier against the instance's own (as defined by its
GetClassId operation) and, failing that, calls its parent classes' IsA
operation.  All subclasses must redefine GetClassId and IsA to ensure
that their identifiers are unique and that instances are written and
read properly.
.SH PROTECTED OPERATIONS
.TP
.B "Tool(ControlInfo* = nil)"
The constructor is protected to prevent instatiation of the abstract
base class.  The ControlInfo object is optional, but only tools that
have no visible manifestion in the interface should omit it.
.TP
.B "ControlInfo* CopyControlInfo()"
CopyControlInfo is a convenience function that subclasses may use in
their Copy operation.  It returns a copy of the tool's ControlInfo
object if it non-nil, simply checking for a nil argument before
calling the corresponding Copy on the ControlInfo object.
.SH SEE ALSO 
Catalog(3U), Command(3U), ControlInfo(3U), Editor(3U), Event(3I),
GraphicView(3U), Manipulator(3U), Transformer(3I), Viewer(3U),
classes(3U), istream(3C++), ostream(3C++)
