/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include	"rcs.h"
RCS_ID("$Id: browser.c,v 1.12 1997/08/18 03:24:10 timj Exp $")


#define		__browser_c__

#include	"browser.h"
#include	"gsi.h"
#include	"treelist.h"
#include	"editor.h"
#include	"widgets.h"
#include	"windows.h"
#include	"widdata.h"
#include	"ufunc.h"
#include	"misc.h"
#include	"defines.h"
#include	"config.h"



/* --- structures --- */
typedef	struct	listwid_widget_list_S	listwid_widget_list_S;
struct	listwid_widget_list_S {
	gb_wdat_base_S	*widget_data;
	GtkWidget	*Label_symbol_name;
	GtkWidget	*Label_parent_name;
	GtkWidget	*Box_selected;
	GtkWidget	*ScrolledWindow;
	GtkWidget	*List;
};



/* --- variables --- */
static	add_type_E	Add_Type;



/* --- prototypes --- */
static	void	SigH_Browser_List_selection_changed	(GtkList	*widget,
							 gpointer	func_data);
static	void	SigH_Delete_widget_real		(GtkWidget	*widget,
						 gpointer	 func_data);



/* --- variables --- */
static	gboolean	ignore_selection_events=FALSE;



/* --- functions --- */
void
Browser_create	(gb_wdat_base_S	*WidDat)
{
	if (!GUBI_DATA(WidDat)->browser) {
		register listwid_widget_list_S	*widget_list;
		

		/* clone window
		*/
		gb_widget_data_clone(GB_wCAST(base, Browser_Window));
		
		
		/* initialize widgets
		*/
		GB_wCAST(label, Browser_Label_symbol_name->clone)->label=
			(gchar*)widget_data_symbol_name_get(WidDat);
		
		
		/* build & connect window
		*/
		gb_window_build(GB_wCAST(window, Browser_Window->clone));
		gb_window_connect(GB_wCAST(window, Browser_Window->clone));
		
		
		/* set GtkWindow* in the browser field and reset to NULL
		 * if the window is destroyed
		*/
		GUBI_DATA(WidDat)->browser=Browser_Window->clone->widget;
		GB_NULLIFY_ON_DESTROY(Browser_Window->clone->widget,
				      &GUBI_DATA(WidDat)->browser);
		
		
		/* we set user_data of the browser window to our widget_list
		 * structure, which will be freed if the window is destroyed.
		*/
		widget_list=g_new(listwid_widget_list_S, 1);
		widget_list->widget_data=WidDat;
		widget_list->Label_symbol_name=Browser_Label_symbol_name->clone->widget;
		widget_list->Label_parent_name=Browser_Label_parent_name->clone->widget;
		widget_list->Box_selected=Browser_Box_Selected->clone->widget;
		widget_list->ScrolledWindow=Browser_ScrolledWin->clone->widget;
		widget_list->List=Browser_List->clone->widget;
		GB_GFREE_ON_DESTROY(Browser_Window->clone->widget, widget_list);
		gtk_object_set_user_data(GTK_OBJECT(Browser_Window->clone->widget),
					 widget_list);
		
		
		/* track selection_changed on single lists
		 * and connect SigH to buttons
		*/
		gtk_signal_connect(GTK_OBJECT(widget_list->List),
				   "selection_changed",
				   GTK_SIGNAL_FUNC(SigH_Browser_List_selection_changed),
				   NULL);
		gtk_signal_connect_object(GTK_OBJECT(Browser_Button_Close->clone->widget),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(Browser_Window->clone->widget));
	
	
		/* show window
		*/
		gtk_widget_show(Browser_Window->clone->widget);
		
		
		/* build up contents
		*/
		Browser_refresh(WidDat, FALSE);
	} else
		_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
}


void
Browser_refresh		(gb_wdat_base_S	*WidDat,
			 guint		selection_only)
{
	register listwid_widget_list_S	*widget_list;
	register GtkList		*List;
	register GtkScrolledWindow	*ScrolledWindow;
	register tree_S			*tree;
	register gboolean		reposition;
	         gchar			*old_label;
	
	g_assert(GB_IS_WIDDAT(WidDat));
	
	g_assert(GUBI_DATA(WidDat)->browser);
	widget_list=gtk_object_get_user_data(GTK_OBJECT(GUBI_DATA(WidDat)->browser));
	g_assert(widget_list);
	
	List=GTK_LIST(widget_list->List);
	ScrolledWindow=GTK_SCROLLED_WINDOW(widget_list->ScrolledWindow);
		
	g_assert((tree=GUBI_DATA(WidDat)->tree));
	
	reposition=FALSE;
	
	ignore_selection_events=TRUE;

	if (!selection_only) {
		register GList			*list;
		register GList			*last;
		register GList			*item_list;
		register guint			parent_level;
		register GtkAdjustment		*Adjustment;
		register gfloat			old_hvalue;
		register gfloat			value;
		
		Adjustment=gtk_scrolled_window_get_hadjustment(ScrolledWindow);
		old_hvalue=Adjustment->value;
		
		gtk_list_clear_items(List, 0, -1);
		reposition=TRUE;
		
		list=g_list_find(tree->widget_data_list, WidDat);
		last=g_list_find(tree->widget_data_list, widget_data_last_child(WidDat));
		
		parent_level=widget_data_parent_level(WidDat);
		
		item_list=NULL;
		
		while (list) {
			register GtkWidget	*item;
			
			item=widget_data_item_new(list->data,
						  2 * ( widget_data_parent_level(list->data) -
						        parent_level ),
						  NULL, 0);
			gtk_object_set_data(GTK_OBJECT(item), "button_1_clicked_2", (gpointer)GB_LA_BROWSER);
			gtk_object_set_data(GTK_OBJECT(item), "button_2_clicked_1", (gpointer)GB_LA_WIDGET_DUMP);
			gtk_object_set_data(GTK_OBJECT(item), "button_3_clicked_1", (gpointer)GB_LA_EDITOR);
			gtk_signal_connect(GTK_OBJECT(item),
					   "button_press_event",
					   GTK_SIGNAL_FUNC(SigH_WidDat_item_clicked),
					   NULL);
			gtk_signal_connect(GTK_OBJECT(item),
					   "button_release_event",
					   GTK_SIGNAL_FUNC(SigH_WidDat_item_clicked),
					   NULL);
			item_list=g_list_append(item_list, item);
			
			if (list!=last)
				list=list->next;
			else
				list=NULL;
		}
		gtk_list_append_items(List, item_list);

		Adjustment=gtk_scrolled_window_get_hadjustment(ScrolledWindow);
		value=CLAMP(old_hvalue,
			    Adjustment->lower,
			    Adjustment->upper-Adjustment->page_size);
		_gtk_adjustment_set_value(Adjustment, value);
	}
	
	if (List->selection &&
	    tree->current!=gtk_object_get_user_data(List->selection->data) ) {
		gtk_list_unselect_child(List, List->selection->data);
	}

	if (!List->selection && tree->current) {
		register GList	*list;
		
		list=List->children;
		while (list) {
			if (gtk_object_get_user_data(GTK_OBJECT(list->data))==tree->current)
				break;
			list=list->next;
		}
		if (list) {
			gtk_list_select_child(List, list->data);
			reposition=TRUE;
		}
	}
	
	ignore_selection_events=FALSE;
	
	
	/* reposition the scrolled window
	 * to show the selected widget
	*/
	if (reposition) {
		register GtkAdjustment		*Adjustment;
		register gfloat			pos;
		register gfloat			range;
		register gfloat			value;
		
		
		if (List->selection)
			pos=gtk_list_child_position(List,
						    List->selection->data) /
			    (g_list_length(List->children) - 1.0);
		else
			pos=0;
		
		Adjustment=gtk_scrolled_window_get_vadjustment(ScrolledWindow);
		range=Adjustment->upper-Adjustment->lower;
		value=Adjustment->lower-Adjustment->page_size/2;
		value+=range*pos;
		value=CLAMP(value,
			    Adjustment->lower,
			    Adjustment->upper-Adjustment->page_size);
		_gtk_adjustment_set_value(Adjustment, value);
	}

	gtk_label_get(GTK_LABEL(widget_list->Label_symbol_name), &old_label);
	if (!old_label || strcmp(old_label, widget_data_symbol_name_get(WidDat))!=0)
		gtk_label_set(GTK_LABEL(widget_list->Label_symbol_name),
			      (gchar*)widget_data_symbol_name_get(WidDat));
	gtk_label_set(GTK_LABEL(widget_list->Label_parent_name),
			List->selection && tree->current->parent ?
			  (gchar*)widget_data_symbol_name_get(tree->current->parent) : "");
	
	
	/* what should the window be raised for,
	 * if we only do a refresh?
	*/
	/* if (WidDat==tree->current &&
	 *    GUBI_DATA(WidDat)->browser)
	 *    	_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
	*/
}


void	Browser_tree_select	(tree_S		*tree,
				 gboolean	selected)
{
	register GList	*list;
	
	g_assert(tree);
	g_assert((list=tree->widget_data_list));
	
	while (list) {
		register gb_wdat_base_S	*WidDat=list->data;
		
		if (GUBI_DATA(WidDat)->browser) {
			register listwid_widget_list_S	*widget_list;
			
			widget_list=gtk_object_get_user_data(GTK_OBJECT(GUBI_DATA(WidDat)->browser));
			g_assert(widget_list);
			
			if (GTK_WIDGET_IS_SENSITIVE(widget_list->Box_selected)!=selected)
				gtk_widget_set_sensitive(widget_list->Box_selected, selected);
		}
		list=list->next;
	}

}


void
SigH_Browser_List_selection_changed	(GtkList	*gtklist,
					 gpointer	func_data)
{
	register gb_wdat_base_S		*WidDat;
	register tree_S			*tree;
	
	
	/* just return if a list refresh is done
	*/
	if (ignore_selection_events)
		return;
	
	
	/* we get the widget from the current item
	 * and our tree from the widget
	*/
	if (gtklist->selection) {
		WidDat=gtk_object_get_user_data(gtklist->selection->data);
		g_assert(GB_IS_WIDDAT(WidDat));
		g_assert((tree=GUBI_DATA(WidDat)->tree));
	} else {
		WidDat=NULL;
		tree=NULL;
	}
	
	
	
	/* check current selection for the tree
	*/
	if (tree && tree->current!=WidDat) {
		register GList	*list;
		
		tree_set_current_widget_data(tree, WidDat);
		
		/* reflect new selection on the whole tree
		*/
		g_assert((list=tree->widget_data_list));
		
		while (list) {
			register gb_wdat_base_S	*WidDat;
			
			WidDat=list->data;
			if (GUBI_DATA(WidDat)->browser)
				Browser_refresh(WidDat, TRUE);
			
			list=list->next;
		}
	}
}


void
SigH_Browser_Widgets_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	if (!TypeList_Window->widget) {
		register GtkWidget	*item;
		register GList		*list, *free_list;
		
		Add_Type=ADD_AS_CHILD;
		
		
		/* initialize widgets
		*/
		
		
		/* build window
		*/
		gb_window_build(TypeList_Window);
		
		
		/* connect window signal handlers
		*/
		gb_window_connect(TypeList_Window);
		
		
		/* fill list with widget types,
		 * we use user_data of the GtkListItem for the widget index
		*/
		free_list=list=gsi_struct_info_list(GSI_SORT_BY_TYPE);
		while (list) {
			register gchar				*name;
			register const gsi_struct_info_S	*struct_info;
			
			struct_info=list->data;
			
			if ( (!gsi_struct_info_is_a(struct_info, GB_WIDGET_BASE)) ||
			     gsi_struct_info_is_a(struct_info, GB_WIDGET_WINDOW) ||
			     GSI_STRUCT_FLAGS(struct_info, GB_FLAG_HIDDEN) ) {
				list=list->next;
				continue;
			}
			
			name=g_strdup((gchar*)to_UpCase(struct_info->struct_name));
			if ( TRUE /* configurable? */ ) {
				register gchar	*free_name;
				register guint	indent, l;
				
				indent=gsi_struct_info_n_parents(struct_info);
				indent=2*(MAX(1, indent)-1);
				
				free_name=name;
				l=strlen(name);
				
				name=g_new(gchar, l+2+1+indent);
				memcpy(&name[indent], free_name, l);
				
				if (GSI_STRUCT_FLAGS(struct_info, GB_FLAG_BASE_TYPE)) {
					name[l+indent]=':';
					name[l+indent+1]=':';
					name[l+indent+2]=0;
				} else
					name[l+indent]=0;
				
				for (l=0; l<indent; l++)
					name[l]=' ';
				
				g_free(free_name);
			}
			item=gtk_list_item_new_with_label(name);
			if (GSI_STRUCT_FLAGS(struct_info, GB_FLAG_BASE_TYPE))
				gtk_widget_set_sensitive(item, FALSE);
			gtk_object_set_user_data(GTK_OBJECT(item), (gpointer)struct_info->struct_type);
			gtk_container_add(GTK_CONTAINER(TypeList_List->widget), item);
			gtk_widget_show(item);
			g_free(name);
			
			list=list->next;
		}
		g_list_free(free_list);
		
		
		/* show window
		*/
		gtk_widget_show(TypeList_Window->widget);
	} else {
		_gtk_widget_raise(TypeList_Window->widget);
	}
}


void
SigH_Browser_List_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*WidDat;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (!tree || !tree->current)
		return;
	WidDat=tree->current;
	if (!GUBI_DATA(WidDat)->browser) {
		if (g_list_length(GUBI_DATA(WidDat)->children)>0)
			Browser_create(WidDat);
	} else
		_gtk_widget_raise(GUBI_DATA(WidDat)->browser);
}


void
SigH_Browser_Delete_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	static	 GtkWidget	*Dialog_delete=NULL;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (tree && tree->current && GB_TYPE_IS_WIDDAT_WINDOW(tree->current->type)) {
		SigH_TreeList_Delete_clicked(widget, func_data);
		return;
	}

	if (tree && tree->current) {
		register gb_wdat_base_S	*WidDat;
		
		WidDat=tree->current;
		
		if (!Dialog_delete)
			Dialog_delete=
				Dialog_create(GTK_OBJECT(widget),
					      &Dialog_delete,
					      "Delete",
					      GTK_SIGNAL_FUNC(SigH_Delete_widget_real),
					      WidDat,
					      "Delete  <%s> %s ?",
					      widget_data_symbol_name_get(WidDat),
					      g_list_length(GUBI_DATA(WidDat)->children)>0 ?
					      	" recursively" : "");
	}
}


void
SigH_Browser_Edit_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register gb_wdat_base_S	*WidDat;
	register tree_S		*tree;
	
	tree=tree_get_current();
	
	if (!tree || !tree->current)
		return;
	WidDat=tree->current;
	if (!GUBI_DATA(WidDat)->editor)
		Editor_create(WidDat);
	else
		_gtk_widget_raise(GUBI_DATA(WidDat)->editor);
}


void
SigH_Delete_widget_real	(GtkWidget	*widget,
			 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_base_S		*WidDat;
	register gb_wdat_base_S		*ParDat;
	register gb_wdat_base_S		*CurDat;
	
	WidDat=func_data;
		
	g_assert(GB_IS_WIDDAT(WidDat));
	
	g_assert((tree=GUBI_DATA(WidDat)->tree));
	

	CurDat=tree->current;
	
	tree_set_current_widget_data(tree, NULL);
	
	
	/* refresh widget lists of all parents
	*/
	ParDat=WidDat->parent;
	while (ParDat) {
		if (GUBI_DATA(ParDat)->browser)
			Browser_refresh(ParDat, TRUE);
		ParDat=ParDat->parent;
	}
	
	ParDat=WidDat->parent;
	
	tree_widget_data_unlink_R(tree, WidDat);
	widget_data_delete_R(WidDat);
	WidDat=NULL;
	
	
	/* refresh widget lists of all parents
	 * with old current widget
	*/
	if (!g_list_find(tree->widget_data_list, CurDat))
		CurDat=ParDat;
	tree_set_current_widget_data(tree, CurDat);
	while (ParDat) {
		if (GUBI_DATA(ParDat)->browser)
			Browser_refresh(ParDat, TRUE);
		ParDat=ParDat->parent;
	}
}


void
SigH_TypeList_AddType_changed	(GtkWidget	*widget,
				 add_type_E	add_type)
{
	Add_Type=add_type;
}


gint
SigH_TypeList_event		(GtkWidget	*widget,
				 GdkEventButton	*event)
{
	if (event->type==GDK_2BUTTON_PRESS && event->button==1) {
		SigH_TypeList_Add_clicked(widget, NULL);
	}
	
	return FALSE;
}


void
SigH_TypeList_Add_clicked	(GtkWidget	*widget,
				 gpointer	func_data)
{
	register tree_S			*tree;
	register gb_wdat_base_S		*Parent;
	register gb_wdat_base_S		*WidDat;
	register gb_struct_type_E	struct_type;
	register gboolean		need_rebuild;
	
	tree=tree_get_current();
	
	
	/* check for error conditions
	*/
	if (!tree || !tree->current) {
		Message_create(GTK_OBJECT(widget),
				"No widget selected for adding.");
		return;
	}
	if (!GTK_LIST(TypeList_List->widget)->selection)
		struct_type=GB_STRUCT_NONE;
	else
		struct_type=(gb_struct_type_E)gtk_object_get_user_data(
			GTK_OBJECT(GTK_LIST(TypeList_List->widget)->selection->data));
	
	if (!GB_TYPE_IS_WIDDAT(struct_type) ||
	    GB_TYPE_IS_ABSTRACT(struct_type) ||
	    GB_TYPE_IS_WIDDAT_WINDOW(struct_type)) {
		Message_create(GTK_OBJECT(widget),
				"No widget type selected for adding.");
		return;
	}
	
	Parent=tree->current;
	WidDat=NULL;
	switch (Add_Type) {
	
	case	ADD_AS_CHILD:
		if (HAS_MAX_CHILD_COUNT(Parent)) {
			Message_create(GTK_OBJECT(widget),
					"Maximum child count reached\nin parent  <%s>.",
					widget_data_symbol_name_get(Parent));
			return;
		}
		break;
	
	case	ADD_AS_PARENT:
	case	ADD_AS_SIB_BEFORE:
	case	ADD_AS_SIB_AFTER:
		if (!Parent->parent) {
			Message_create(GTK_OBJECT(widget),
					"Widget  <%s>\nhas no parent.",
					widget_data_symbol_name_get(Parent));
			return;
		}
		if (Add_Type==ADD_AS_PARENT)
			break;
		if (HAS_MAX_CHILD_COUNT(Parent->parent)) {
			Message_create(GTK_OBJECT(widget),
					"Maximum child count reached\nin parent  <%s>.",
					widget_data_symbol_name_get(Parent->parent));
			return;
		}
		break;
	
	default:
		g_assert_not_reached();
		break;
	}
	
	
	/* add widget
	*/
	need_rebuild=FALSE;
	switch (Add_Type) {
		register GList		*list;
		register gb_wdat_base_S	*TmpDat;
		register guint		position;
	
	case	ADD_AS_CHILD:
		WidDat=widget_data_new(struct_type, NULL, FALSE);
		tree_widget_data_insert_R(tree, Parent, WidDat, ~0);
		break;
	
	case	ADD_AS_PARENT:
		WidDat=Parent;
		Parent=Parent->parent;
		list=g_list_find(GUBI_DATA(Parent)->children, WidDat);
		position=0;
		if (list) 
			list=list->prev;
		while (list) {
			position++;
			list=list->prev;
		}
		TmpDat=widget_data_new(struct_type, NULL, FALSE);
		if (HAS_MAX_CHILD_COUNT(TmpDat)) {
			Message_create(GTK_OBJECT(widget),
					"Maximum child count reached\nin parent  <%s>.",
					widget_data_symbol_name_get(TmpDat));
			widget_data_delete_R(TmpDat);
			return;
		}
		tree_widget_data_unlink_R(tree, WidDat);
		g_assert(!TmpDat->linkage);
		TmpDat->linkage=WidDat->linkage;
		WidDat->linkage=NULL;
		tree_widget_data_insert_R(tree, Parent, TmpDat, position);
		tree_widget_data_insert_R(tree, TmpDat, WidDat, 1);
		need_rebuild=TRUE;
		break;
	
	case	ADD_AS_SIB_BEFORE:
	case	ADD_AS_SIB_AFTER:
		WidDat=Parent;
		Parent=Parent->parent;
		list=g_list_find(GUBI_DATA(Parent)->children, WidDat);
		position=0;
		if (list && Add_Type==ADD_AS_SIB_BEFORE) 
			list=list->prev;
		while (list) {
			position++;
			list=list->prev;
		}
		WidDat=widget_data_new(struct_type, NULL, FALSE),
		tree_widget_data_insert_R(tree, Parent, WidDat, position);
		need_rebuild=TRUE;
		break;
	
	default:
		g_assert_not_reached();
		break;
	}
	
	
	/* refresh widget lists of all parents
	*/
	while (WidDat) {
		if (GUBI_DATA(WidDat)->browser)
			Browser_refresh(WidDat, FALSE);
		WidDat=WidDat->parent;
	}
	
	
	/* rebuilg tree if neccessary
	*/
	if (need_rebuild) {
		tree_rebuild(tree);
		tree_show(tree);
	}
}
